/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message;

import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.message.WSSecHeader;
import org.apache.ws.security.message.token.SecurityContextToken;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;

public class WSSecSecurityContextToken {
    private SecurityContextToken sct;
    private String sctId;
    private String identifier;
    protected byte[] secret;
    private int wscVersion = 1;

    public void prepare(Document doc, Crypto crypto) throws WSSecurityException, ConversationException {
        if (this.sct == null) {
            if (this.identifier != null) {
                this.sct = new SecurityContextToken(this.wscVersion, doc, this.identifier);
            } else {
                this.sct = new SecurityContextToken(this.wscVersion, doc);
                this.identifier = this.sct.getIdentifier();
            }
        }
        if (this.sctId != null) {
            this.sct.setID(this.sctId);
        }
    }

    public void prependSCTElementToHeader(Document doc, WSSecHeader secHeader) throws WSSecurityException {
        WSSecurityUtil.prependChildElement(secHeader.getSecurityHeader(), this.sct.getElement());
    }

    public SecurityContextToken getSct() {
        return this.sct;
    }

    public void setSct(SecurityContextToken sct) {
        this.sct = sct;
    }

    public byte[] getSecret() {
        return this.secret;
    }

    protected void setSecret(byte[] ephemeralKey) {
        this.secret = ephemeralKey;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getSctId() {
        if (this.sct != null) {
            return this.sct.getID();
        }
        return this.sctId;
    }

    public void setSctId(String sctId) {
        this.sctId = sctId;
    }

    public void setWscVersion(int wscVersion) {
        this.wscVersion = wscVersion;
    }
}

