/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.gen;

import com.sun.codemodel.JCodeModel;
import com.sun.tools.xjc.api.ErrorListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.gen.GenerationContext;
import org.codehaus.xfire.gen.GeneratorPlugin;
import org.codehaus.xfire.gen.PluginProfile;
import org.codehaus.xfire.gen.SchemaSupport;
import org.codehaus.xfire.gen.jaxb.JAXBSchemaSupport;
import org.codehaus.xfire.gen.jsr181.Jsr181Profile;
import org.codehaus.xfire.util.ClassLoaderUtils;
import org.codehaus.xfire.util.Resolver;
import org.codehaus.xfire.wsdl11.parser.WSDLServiceBuilder;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wsdl11Generator {
    private static final Log log = LogFactory.getLog(Wsdl11Generator.class);
    public static final String JAXB = "jaxb";
    public static final String XMLBEANS = "xmlbeans";
    private String wsdl;
    private String baseURI;
    private String outputDirectory;
    private String destinationPackage;
    private JCodeModel codeModel = new JCodeModel();
    private String profile;
    private String binding = "jaxb";
    private SchemaSupport support;
    private String externalBindings;
    private boolean explicitAnnotation;
    private boolean overwrite;
    private boolean generateServerStubs = true;
    private boolean forceBare = false;
    private ErrorListener jaxbErrorListener;

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean forceOverwrite) {
        this.overwrite = forceOverwrite;
    }

    private static void configureSSL() {
        HostnameVerifier hv = new HostnameVerifier(){

            public boolean verify(String arg0, SSLSession arg1) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(hv);
    }

    public void generate() throws Exception {
        Resolver resolver;
        File dest = new File(this.outputDirectory);
        dest.mkdirs();
        if (this.wsdl.toLowerCase().startsWith("https")) {
            Wsdl11Generator.configureSSL();
        }
        this.loadSchemaSupport();
        if (this.baseURI != null && new File(this.baseURI).exists()) {
            this.baseURI = new File(this.baseURI).toURI().toString();
        }
        if ((resolver = new Resolver(this.baseURI, this.wsdl)).getInputStream() == null) {
            throw new XFireException("Could not find wsdl " + this.wsdl + " with a base URI of " + this.baseURI + ".");
        }
        String wsdlUri = resolver.getURI().toString();
        if (this.baseURI == null) {
            this.baseURI = wsdlUri;
        }
        log.info((Object)("Generating code for WSDL at " + wsdlUri + " with a base URI of " + this.baseURI));
        InputSource source = new InputSource(resolver.getInputStream());
        source.setSystemId(wsdlUri);
        WSDLServiceBuilder builder = new WSDLServiceBuilder(this.baseURI, source);
        builder.setBindingProvider(this.support.getBindingProvider());
        builder.setForceBare(this.forceBare);
        builder.build();
        if (this.profile == null) {
            this.profile = Jsr181Profile.class.getName();
        }
        PluginProfile profileObj = (PluginProfile)ClassLoaderUtils.loadClass(this.profile, this.getClass()).newInstance();
        GenerationContext context = new GenerationContext(this.codeModel, builder.getDefinition());
        context.setOutputDirectory(dest);
        context.setWsdlLocation(wsdlUri);
        context.setBaseURI(this.baseURI);
        context.setSchemas(builder.getSchemas());
        context.setExternalBindings(this.getExternalBindingFiles());
        context.setExplicitAnnotation(this.isExplicitAnnotation());
        context.setServerStubOverwritten(this.isOverwrite());
        context.setDescriptorOverwritten(this.isOverwrite());
        context.setServerStubGenerated(this.isGenerateServerStubs());
        if (this.binding.equals(JAXB) && this.jaxbErrorListener != null) {
            ((JAXBSchemaSupport)this.support).setErrorListener(this.jaxbErrorListener);
        }
        this.support.initialize(context);
        this.codeModel = context.getCodeModel();
        context.setServices(builder.getServices());
        context.setDestinationPackage(this.getDestinationPackage());
        context.setSchemaGenerator(this.support);
        for (GeneratorPlugin plugin : profileObj.getPlugins()) {
            plugin.generate(context);
        }
        this.codeModel.build(dest);
    }

    private void loadSchemaSupport() throws Exception {
        if (this.support == null) {
            if (this.binding.equals(JAXB)) {
                this.support = this.loadSupport("org.codehaus.xfire.gen.jaxb.JAXBSchemaSupport");
            } else if (this.binding.equals(XMLBEANS)) {
                this.support = this.loadSupport("org.codehaus.xfire.gen.xmlbeans.XmlBeansSchemaSupport");
            } else {
                throw new Exception("Illegal binding: " + this.binding);
            }
        }
    }

    private Map<String, InputStream> getExternalBindingFiles() throws IOException {
        if (this.externalBindings == null) {
            return null;
        }
        HashMap<String, InputStream> files = new HashMap<String, InputStream>();
        StringTokenizer st = new StringTokenizer(this.externalBindings, ",");
        while (st.hasMoreTokens()) {
            String name = st.nextToken();
            Resolver resolver = new Resolver(this.baseURI, name);
            if (resolver.getInputStream() == null) {
                throw new IllegalStateException("Could not find binding file " + name);
            }
            files.put(resolver.getURI().toString(), resolver.getInputStream());
        }
        return files;
    }

    private SchemaSupport loadSupport(String name) throws Exception {
        return (SchemaSupport)ClassLoaderUtils.loadClass(name, this.getClass()).newInstance();
    }

    public SchemaSupport getSchemaSupport() {
        return this.support;
    }

    public void setSchemaSupport(SchemaSupport support) {
        this.support = support;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public JCodeModel getCodeModel() {
        return this.codeModel;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public String getDestinationPackage() {
        return this.destinationPackage;
    }

    public void setDestinationPackage(String destinationPackage) {
        this.destinationPackage = destinationPackage;
    }

    public String getBinding() {
        return this.binding;
    }

    public void setBinding(String binding) {
        this.binding = binding;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setExternalBindings(String externalBindings) {
        this.externalBindings = externalBindings;
    }

    public String getExternalBindings() {
        return this.externalBindings;
    }

    public boolean isExplicitAnnotation() {
        return this.explicitAnnotation;
    }

    public void setExplicitAnnotation(boolean explicitAnnotation) {
        this.explicitAnnotation = explicitAnnotation;
    }

    public boolean isGenerateServerStubs() {
        return this.generateServerStubs;
    }

    public void setGenerateServerStubs(boolean generateServerStubs) {
        this.generateServerStubs = generateServerStubs;
    }

    public void setJAXBErrorListener(ErrorListener jaxbErrorListener) {
        this.jaxbErrorListener = jaxbErrorListener;
    }

    public boolean isForceBare() {
        return this.forceBare;
    }

    public void setForceBare(boolean forceBare) {
        this.forceBare = forceBare;
    }
}

