/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.spring;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xbean.spring.context.SpringApplicationContext;
import org.apache.xbean.spring.context.impl.XBeanHelper;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.XFireException;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.spring.GenericApplicationContext;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class XFireConfigLoader {
    private Log log = LogFactory.getLog((Class)XFireConfigLoader.class);
    private File basedir;

    public File getBasedir() {
        return this.basedir;
    }

    public void setBasedir(File basedir) {
        this.basedir = basedir;
    }

    public ApplicationContext loadContext(String configPath, ApplicationContext parent) throws XFireException {
        ApplicationContext newCtx = this.getXFireApplicationContext(configPath, parent);
        return newCtx;
    }

    public XFire loadConfig(String configPath) throws XFireException {
        ApplicationContext ctx = this.loadContext(configPath, null);
        return (XFire)ctx.getBean("xfire");
    }

    public XFire loadConfig(String configPath, ApplicationContext parent) throws XFireException {
        ApplicationContext ctx = this.loadContext(configPath, parent);
        return (XFire)ctx.getBean("xfire");
    }

    private ApplicationContext getXFireApplicationContext(String configPath, ApplicationContext parent) throws XFireException {
        if (configPath == null) {
            throw new XFireException("Configuration file required");
        }
        org.springframework.context.support.GenericApplicationContext ctx = this.createContext(parent);
        XmlBeanDefinitionReader xmlReader = XBeanHelper.createBeanDefinitionReader((SpringApplicationContext)((SpringApplicationContext)ctx), (BeanDefinitionRegistry)ctx.getDefaultListableBeanFactory(), (List)Collections.EMPTY_LIST);
        if (parent == null || !parent.containsBean("xfire")) {
            xmlReader.loadBeanDefinitions((Resource)new ClassPathResource("org/codehaus/xfire/spring/xfire.xml"));
        } else {
            xmlReader.loadBeanDefinitions((Resource)new ClassPathResource("org/codehaus/xfire/spring/customEditors.xml"));
        }
        String[] configs = null;
        configs = configPath.indexOf(",") != -1 ? configPath.split(",") : new String[]{configPath};
        for (int i = 0; i < configs.length; ++i) {
            File file;
            String config = configs[i].trim();
            File file2 = file = this.basedir != null ? new File(this.basedir, config) : new File(config);
            if (file.exists()) {
                xmlReader.loadBeanDefinitions((Resource)new FileSystemResource(file));
                continue;
            }
            xmlReader.loadBeanDefinitions((Resource)new ClassPathResource(config));
        }
        ctx.refresh();
        XFire xfire = (XFire)ctx.getBean("xfire");
        this.log.debug((Object)("Setting XFire instance: " + xfire));
        XFireFactory.newInstance().setXFire(xfire);
        return ctx;
    }

    protected org.springframework.context.support.GenericApplicationContext createContext(ApplicationContext parent) {
        GenericApplicationContext ctx = new GenericApplicationContext(parent);
        return ctx;
    }
}

