﻿/**
 * Copyright (c) 2006-2009, Opera Software ASA
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Opera Software ASA nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY OPERA SOFTWARE ASA AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL OPERA SOFTWARE ASA AND CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

// Modified version of date.js for the twitter widget

Date.prototype.toAge = function() {
  var months = [
    'January',
    'February',
    'March',
    'April',
    'May',
    'June',
    'July',
    'August',
    'September',
    'October',
    'November',
    'December'
  ];
  var now = new Date();
  var ticks = now.getTime() - this.getTime();
  
  // Seconds
  ticks = Math.floor( ticks / 1000 );
  if (ticks < 60) {
    var d;
    if (ticks < 5) d = "less than 5 seconds ago";
    else if (ticks < 10) d = "less than 10 seconds ago";
    else if (ticks < 20) d = "less than 20 seconds ago";
    else if (ticks >= 30 && ticks <= 45) d = "half a minute ago";
    else d = "less than a minute ago";
    return d;
  }
  
  // Minutes
  ticks = Math.floor( ticks / 60 );
  if (ticks < 45) {
    return ticks + ' minute' + (ticks == 1 ? '' : 's') + ' ago';
  }
  
  // Hours
  ticks = Math.round( ticks / 60 );
  if (ticks <= 36) {
    if (ticks >= 24) return '1 day ago';
    return 'about ' + ticks + ' hour' + (ticks == 1 ? '': 's') + ' ago';
  }
  // Otherwise, write out the time
  else {
    var d = zfill(this.getHours()) + ':' + zfill(this.getMinutes()) +
      ' ' + months[this.getMonth()] + ' ' + this.getDate();
    if (this.getFullYear() != now.getFullYear()) d += ', ' + this.getFullYear();
    return d;
  }
};

function zfill(n) {
  return (n < 10) ? '0' + n : '' + n;
}
