/*
 * Copyright (c) 2009, Opera Software ASA
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Opera Software ASA nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY OPERA SOFTWARE ASA ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL OPERA SOFTWARE ASA BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @fileoverview
 * 
 * Ping.fm Library
 * 
 * Library to use Ping.fm API. 
 * 
 * @author Vivek Jishtu
 */


/**
 * Use the Ping.fm library to use in your project.
 * You can change the XHR library to handle timeouts
 * and other network errors.
 * 
 * @class
 * The main class for ping.fm.
 */
function Pingfm(userkey) 
{
    /**
     * The APP KEY provided by Ping.fm
     * 
     * @private
     * @type String
     */              
    var APP_KEY = "3205813e849841e2bc0582e63f0bd5cb";
	var xhr = new Opera.Net.Ajax();
	
    /**
     * Helper function to get the value of an element in an XML dom tree
     * 
     * @private
     * @param {XMLDomNode} xml The XML Node to search on.
     * @param {String}  elementName The name of the element to find
     * @param {Integer} index  Index of the node in the list.
     * 
     * @returns {String} Returns the value of the element in the node list.
     */
    function getValue(xml, elementName, index)
    {
    	if(!index) index = 0;	
    	try
    	{
    		return xml.getElementsByTagName(elementName)[index].firstChild.nodeValue;	
    	}
    	catch(e)
    	{
    		return "";
    	}	
    }
    
    /**
     * Helper function to get the attribute of a given XMLNode
     * 
     * @private
     * @param {XMLDomNode} xml
     * @param {String} attribute
     * 
     * @returns {String} Returns the value of the attribute of the node.
     */
    function getAttribute(xml, attribute)
    {
    	try
    	{
            var att = xml.attributes;
    		for(var j = 0; j < att.length; j++) 
            {
    			if (att[j].nodeName == attribute) 
                {                
                   return att[j].nodeValue;
                }
    		}
            return "";
    	}
    	catch(e)
    	{    		
            return "";
    	}
    }
    
 	this.abort = function()
	{
		xhr.abort();	
	}
	
	this.getSystemServices = function(callback)
	{		
		var postdata = "api_key=" + APP_KEY + "&user_app_key=" + userkey;
        xhr.Post("http://api.ping.fm/v1/system.services", postdata, function(res)        
        {            
            if(callback) callback(parseResults(res.responseXML));
        });
	}
	
	this.getUserServices = function(callback)
	{
		var postdata = "api_key=" + APP_KEY + "&user_app_key=" + userkey;
        xhr.Post("http://api.ping.fm/v1/user.services", postdata, function(res)        
        {
  			var response = {};
			opera.postError(res.responseText);
			if(res.responseXML)
			{
				var rsp = res.responseXML.getElementsByTagName("rsp");
				response.status = getAttribute(rsp[0], "status");
				response.transaction = getValue(rsp[0], "transaction");
				response.method = getValue(rsp[0], "method");
				
				var services = rsp[0].getElementsByTagName("service");
				response.services = [];
				
				for(var x = 0; x < services.length; x++)
				{
					var service = {};
					service.name 	= getAttribute(services[x], "name");
					service.id 		= getAttribute(services[x], "id");
					service.trigger = getValue(services[x], "trigger");
					service.url 	= getValue(services[x], "url");
					service.icon 	= getValue(services[x], "icon");
					service.methods = getValue(services[x], "methods");
					response.services.push(service);
				}
			}
			else
			{
				response.status = "FAIL";
			}			
			if(callback) callback(response);
        });
	},
	
	this.validateUser = function(callback)
	{
		var postdata = "api_key=" + APP_KEY + "&user_app_key=" + userkey;
        xhr.Post("http://api.ping.fm/v1/user.validate", postdata, function(res)        
        {
			var response = {};
			if(res.responseXML)
			{
				var rsp = res.responseXML.getElementsByTagName("rsp");
				response.status = getAttribute(rsp[0], "status");
				response.transaction = getValue(rsp[0], "transaction");
				response.method = getValue(rsp[0], "method");
				response.message = getValue(rsp[0], "message");	
			}
			else
			{
				response.status = "FAIL";
			}			
			if(callback) callback(response);
        });
	},
	
	this.postStatus = function(body, callback)
	{
		var postdata = "api_key=" + APP_KEY + "&user_app_key=" + userkey + "&post_method=status&body=" + body;
        xhr.Post("http://api.ping.fm/v1/user.post", postdata, function(res)
        {
            var response = {};
			if(res.responseXML)
			{
				var rsp = res.responseXML.getElementsByTagName("rsp");
				response.status = getAttribute(rsp[0], "status");
				response.transaction = getValue(rsp[0], "transaction");
				response.method = getValue(rsp[0], "method");
				response.message = getValue(rsp[0], "message");	
			}
			else
			{
				response.status = "FAIL";
			}
			
            if(callback) callback(response);
        });
		
	}
	
    /**
     * A wrapper function to use any AJAX library. Modification to use any other
     * library should be made in this function. Timeouts and network errors should
     * be handled at the AJAX libary level.
     * 
     * @param {String} url
     * @param {function} callback Function to be called when the results have been parsed
     */
    function getAndParseResults(url, callback)
    {
        var xhr = new Opera.Net.Ajax();
        xhr.Get(url, function(res)        
        {
            opera.postError(res.responseText);
            if(callback) callback(parseResults(res.responseXML));
        });        
    }   
     
}
