/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.appframework.swingx;

import com.jgoodies.binding.list.ArrayListModel;
import java.awt.Component;
import java.beans.DefaultPersistenceDelegate;
import java.beans.Encoder;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.XMLEncoder;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;

public class XProperties {
    public void registerPersistenceDelegates() {
        XMLEncoder xMLEncoder = new XMLEncoder(System.out);
        xMLEncoder.setPersistenceDelegate(SortKeyState.class, new DefaultPersistenceDelegate(new String[]{"sortOrder", "modelIndex"}));
        xMLEncoder.setPersistenceDelegate(ColumnState.class, new DefaultPersistenceDelegate(new String[]{"width", "preferredWidth", "modelIndex", "visible", "viewIndex"}));
        xMLEncoder.setPersistenceDelegate(XTableState.class, new DefaultPersistenceDelegate(new String[]{"columnStates", "sortKeyState", "horizontalScrollEnabled"}));
        xMLEncoder.setPersistenceDelegate(ArrayListModel.class, xMLEncoder.getPersistenceDelegate(List.class));
        PrimitivePersistenceDelegate primitivePersistenceDelegate = new PrimitivePersistenceDelegate();
        xMLEncoder.setPersistenceDelegate(URL.class, new PrimitivePersistenceDelegate());
        xMLEncoder.setPersistenceDelegate(File.class, primitivePersistenceDelegate);
    }

    public static class VisibleColumnIndexComparator
    implements Comparator<ColumnState> {
        @Override
        public int compare(ColumnState columnState, ColumnState columnState2) {
            return columnState.getViewIndex() - columnState2.getViewIndex();
        }
    }

    public static class ColumnState {
        private int width;
        private int preferredWidth;
        private int modelIndex;
        private boolean visible;
        private int viewIndex;

        public ColumnState(int n, int n2, int n3, boolean bl, int n4) {
            this.width = n;
            this.preferredWidth = n2;
            this.modelIndex = n3;
            this.visible = bl;
            this.viewIndex = n4;
        }

        public ColumnState(TableColumnExt tableColumnExt, int n) {
            this(tableColumnExt.getWidth(), tableColumnExt.getPreferredWidth(), tableColumnExt.getModelIndex(), tableColumnExt.isVisible(), n);
        }

        public void configureColumn(TableColumnExt tableColumnExt) {
            if (this.modelIndex != tableColumnExt.getModelIndex()) {
                return;
            }
            tableColumnExt.setPreferredWidth(this.preferredWidth);
            tableColumnExt.setWidth(this.width);
            tableColumnExt.setVisible(this.visible);
        }

        public int getModelIndex() {
            return this.modelIndex;
        }

        public int getViewIndex() {
            return this.viewIndex;
        }

        public boolean getVisible() {
            return this.visible;
        }

        public int getWidth() {
            return this.width;
        }

        public int getPreferredWidth() {
            return this.preferredWidth;
        }
    }

    public static class SortKeyState {
        int modelIndex;
        int sortOrder;

        public SortKeyState(int n, int n2) {
            this.sortOrder = n;
            this.modelIndex = n2;
        }

        public SortKeyState(RowSorter.SortKey sortKey) {
            this(sortKey.getSortOrder().ordinal(), sortKey.getColumn());
        }

        protected RowSorter.SortKey getSortKey() {
            return new RowSorter.SortKey(this.getModelIndex(), SortOrder.values()[this.getSortOrder()]);
        }

        public int getSortOrder() {
            return this.sortOrder;
        }

        public int getModelIndex() {
            return this.modelIndex;
        }
    }

    public static class XTableState {
        ColumnState[] columnStates = new ColumnState[0];
        boolean horizontalScrollEnabled;
        SortKeyState sortKeyState;

        public XTableState() {
        }

        public XTableState(ColumnState[] columnStateArray, SortKeyState sortKeyState, boolean bl) {
            this.columnStates = this.copyColumnStates(columnStateArray);
            this.sortKeyState = sortKeyState;
            this.setHorizontalScrollEnabled(bl);
        }

        public void setSortKey(RowSorter.SortKey sortKey) {
            this.sortKeyState = new SortKeyState(sortKey);
        }

        private RowSorter.SortKey getSortKey() {
            if (this.sortKeyState != null) {
                return this.sortKeyState.getSortKey();
            }
            return null;
        }

        public XTableState(ColumnState[] columnStateArray) {
            this.columnStates = this.copyColumnStates(columnStateArray);
        }

        public ColumnState[] getColumnStates() {
            return this.copyColumnStates(this.columnStates);
        }

        public boolean getHorizontalScrollEnabled() {
            return this.horizontalScrollEnabled;
        }

        public void setHorizontalScrollEnabled(boolean bl) {
            this.horizontalScrollEnabled = bl;
        }

        private ColumnState[] copyColumnStates(ColumnState[] columnStateArray) {
            if (columnStateArray == null) {
                throw new IllegalArgumentException("invalid columnWidths");
            }
            ColumnState[] columnStateArray2 = new ColumnState[columnStateArray.length];
            System.arraycopy(columnStateArray, 0, columnStateArray2, 0, columnStateArray.length);
            return columnStateArray2;
        }

        public SortKeyState getSortKeyState() {
            return this.sortKeyState;
        }
    }

    public static class XTableProperty
    implements PropertySupport {
        public Object getSessionState(Component component) {
            Object object2;
            this.checkComponent(component);
            JXTable jXTable = (JXTable)component;
            ArrayList<ColumnState> arrayList = new ArrayList<ColumnState>();
            List list = jXTable.getColumns(true);
            List list2 = jXTable.getColumns();
            for (Object object2 : list) {
                arrayList.add(new ColumnState((TableColumnExt)object2, list2.indexOf(object2)));
            }
            XTableState xTableState = new XTableState(arrayList.toArray(new ColumnState[arrayList.size()]));
            xTableState.setHorizontalScrollEnabled(jXTable.isHorizontalScrollEnabled());
            object2 = jXTable.getRowSorter().getSortKeys();
            RowSorter.SortKey sortKey = null;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                RowSorter.SortKey sortKey2 = (RowSorter.SortKey)iterator.next();
                if (SortOrder.UNSORTED.equals((Object)sortKey2.getSortOrder())) continue;
                sortKey = sortKey2;
                break;
            }
            if (sortKey != null) {
                xTableState.setSortKey(sortKey);
            }
            return xTableState;
        }

        public void setSessionState(Component component, Object object) {
            this.checkComponent(component);
            JXTable jXTable = (JXTable)component;
            XTableState xTableState = (XTableState)object;
            ColumnState[] columnStateArray = xTableState.getColumnStates();
            List list = jXTable.getColumns(true);
            if (this.canRestore(columnStateArray, list)) {
                for (int i = 0; i < columnStateArray.length; ++i) {
                    columnStateArray[i].configureColumn((TableColumnExt)list.get(i));
                }
                this.restoreVisibleSequence(columnStateArray, jXTable.getColumnModel());
            }
            jXTable.setHorizontalScrollEnabled(xTableState.getHorizontalScrollEnabled());
            if (xTableState.getSortKey() != null) {
                jXTable.getRowSorter().setSortKeys(Collections.singletonList(xTableState.getSortKey()));
            }
        }

        private void restoreVisibleSequence(ColumnState[] columnStateArray, TableColumnModel tableColumnModel) {
            List<ColumnState> list = this.getSortedVisibleColumnStates(columnStateArray);
            for (int i = 0; i < list.size(); ++i) {
                TableColumn tableColumn = tableColumnModel.getColumn(i);
                int n = list.get(i).getModelIndex();
                if (n == tableColumn.getModelIndex()) continue;
                int n2 = -1;
                for (int j = i + 1; j < tableColumnModel.getColumnCount(); ++j) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(j);
                    if (tableColumn2.getModelIndex() != n) continue;
                    n2 = j;
                    break;
                }
                tableColumnModel.moveColumn(n2, i);
            }
        }

        private List<ColumnState> getSortedVisibleColumnStates(ColumnState[] columnStateArray) {
            ArrayList<ColumnState> arrayList = new ArrayList<ColumnState>();
            for (ColumnState columnState : columnStateArray) {
                if (!columnState.getVisible()) continue;
                arrayList.add(columnState);
            }
            Collections.sort(arrayList, new VisibleColumnIndexComparator());
            return arrayList;
        }

        private boolean canRestore(ColumnState[] columnStateArray, List<TableColumn> list) {
            if (columnStateArray == null || columnStateArray.length != list.size()) {
                return false;
            }
            for (int i = 0; i < columnStateArray.length; ++i) {
                if (columnStateArray[i].getModelIndex() == list.get(i).getModelIndex()) continue;
                return false;
            }
            return true;
        }

        private void checkComponent(Component component) {
            if (component == null) {
                throw new IllegalArgumentException("null component");
            }
            if (!(component instanceof JXTable)) {
                throw new IllegalArgumentException("invalid component - expected JXTable");
            }
        }
    }

    class PrimitivePersistenceDelegate
    extends PersistenceDelegate {
        PrimitivePersistenceDelegate() {
        }

        @Override
        protected Expression instantiate(Object object, Encoder encoder) {
            return new Expression(object, object.getClass(), "new", new Object[]{object.toString()});
        }
    }
}

