/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.tasks.DownloadTask;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.logging.Logger;
import javax.swing.filechooser.FileSystemView;

public class FileUtils {
    private static final Logger logger = Logger.getLogger(FileUtils.class.getName());
    public static final String BACKUP_EXTENSION = ".backup";

    private FileUtils() {
    }

    public static OutputStream createEmptyFile(File file, long l, long l2, DownloadTask downloadTask) throws IOException {
        byte[] byArray = new byte[0x100000];
        RandomAccessFile randomAccessFile = null;
        long l3 = file.exists() ? file.length() : 0L;
        try {
            randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.setLength(l);
            randomAccessFile.seek(l3);
            int n = 0x100000;
            for (long i = l3; i != l; i += (long)n) {
                if (downloadTask.isTerminated()) {
                    return null;
                }
                if (l - i < 0x100000L) {
                    n = (int)(l - i);
                }
                randomAccessFile.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            if (randomAccessFile != null) {
                randomAccessFile.close();
            }
            throw iOException;
        }
        randomAccessFile.seek(l2);
        return new FileOutputStream(randomAccessFile.getFD());
    }

    public static void makeBackup(File file) throws IOException {
        boolean bl;
        if (!file.exists() || file.length() <= 0L) {
            return;
        }
        File file2 = FileUtils.getBackupFile(file);
        File file3 = new File(file.getParentFile(), "FRD" + (int)(Math.random() * 1000000.0) + "templist.txt");
        boolean bl2 = file.renameTo(file3);
        if (!bl2) {
            logger.warning("Failed to rename oldSrc file to " + file3);
        }
        if (file2.exists() && !(bl = file2.delete())) {
            logger.warning("Deleting old backup file " + file2 + " failed.");
        }
        if (!(bl = file3.renameTo(file2))) {
            logger.warning("Making backup of file " + file + " to backup file " + file2 + " failed.");
        }
    }

    public static void renewBackup(File file) throws IOException {
        File file2 = FileUtils.getBackupFile(file);
        try {
            if (!file2.exists()) {
                throw new FileNotFoundException("Backup file does not exists");
            }
            FileUtils.copyfile(file2, file);
        }
        catch (IOException iOException) {
            logger.warning("Renewing file " + file + " from backup file " + file2 + " failed.");
            throw iOException;
        }
    }

    public static File getBackupFile(File file) {
        return new File(file.getParentFile(), file.getName() + BACKUP_EXTENSION);
    }

    public static File getRelativeDirectory(File file, File file2) {
        String string;
        try {
            string = FileUtils.getRelativePath(file, file2);
            logger.info("Relative path of '" + file2 + "' to " + file + " is " + string);
        }
        catch (IOException iOException) {
            return file2;
        }
        if (string == null) {
            return file2;
        }
        return new File(string);
    }

    private static String getRelativePath(File file, File file2) throws IOException {
        String string;
        String string2;
        String string3 = file2.getCanonicalPath();
        if (file.isFile()) {
            File file3 = file.getParentFile();
            if (file3 == null) {
                return null;
            }
            string2 = file3.getCanonicalPath();
        } else {
            string2 = file.getCanonicalPath();
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        int n = string2.indexOf(File.separatorChar);
        String string4 = null;
        while (n != -1 && string3.startsWith(string = string2.substring(0, n + 1))) {
            string4 = string;
            n = string2.indexOf(File.separatorChar, n + 1);
        }
        if (string4 == null) {
            return null;
        }
        string3 = string3.substring(string4.length());
        if (string4.length() == string2.length()) {
            return string3;
        }
        int n2 = 0;
        n = string2.indexOf(File.separatorChar, string4.length());
        while (n != -1) {
            ++n2;
            n = string2.indexOf(File.separatorChar, n + 1);
        }
        for (int i = 0; i < n2; ++i) {
            string3 = ".." + File.separator + string3;
        }
        return string3;
    }

    public static void copyfile(File file, File file2) throws IOException {
        if (!file.exists() || !file.isFile()) {
            return;
        }
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            boolean bl;
            File file3 = file2.getParentFile();
            if (!file3.exists() && !(bl = file3.mkdirs())) {
                logger.warning("Creating path " + file3 + " failed");
            }
            inputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            byte[] byArray = new byte[8192];
            while ((n = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
            throw iOException;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LogUtils.processException(logger, iOException);
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    LogUtils.processException(logger, iOException);
                }
            }
        }
    }

    public static String getAbsolutPath(String string) {
        return FileUtils.getAbsolutPath(new File(string));
    }

    public static String getAbsolutPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static File getAbsolutFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    public static File getFileDrive(File file) {
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        while (!fileSystemView.isDrive(file)) {
            file = file.getParentFile();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            int n;
            int n2;
            fileInputStream = new FileInputStream(file);
            long l = file.length();
            if (l > Integer.MAX_VALUE) {
                // empty if block
            }
            byte[] byArray = new byte[(int)l];
            for (n = 0; n < byArray.length && (n2 = ((InputStream)fileInputStream).read(byArray, n, byArray.length - n)) >= 0; n += n2) {
            }
            if (n < byArray.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            if (fileInputStream != null) {
                ((InputStream)fileInputStream).close();
            }
        }
    }

    public static void deleteFileWithRecycleBin(File file) {
        com.sun.jna.platform.FileUtils fileUtils;
        boolean bl;
        if (AppPrefs.getProperty("useRecycleBin", false) && (bl = (fileUtils = com.sun.jna.platform.FileUtils.getInstance()).hasTrash())) {
            if (!file.exists()) {
                return;
            }
            logger.info("Moving file to trash " + file);
            try {
                fileUtils.moveToTrash(new File[]{file});
                return;
            }
            catch (Exception exception) {
                logger.warning("Failed to delete file via recycle bin ");
                LogUtils.processException(logger, exception);
                FileUtils.deleteFile(file);
                return;
            }
        }
        FileUtils.deleteFile(file);
    }

    public static void deleteFile(File ... fileArray) {
        for (File file : fileArray) {
            boolean bl;
            if (!file.exists() || (bl = file.delete())) continue;
            logger.info("Failed to delete file " + file);
        }
    }
}

