/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.utilities;

import cz.vity.freerapid.utilities.LogUtils;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class DataURI {
    private static final Logger logger = Logger.getLogger(DataURI.class.getName());
    private final byte[] bytes;
    private final boolean base64;
    private final String contentType;
    private final String charset;

    private DataURI(byte[] byArray, boolean bl, String string, String string2) {
        this.bytes = byArray;
        this.base64 = bl;
        this.contentType = string;
        this.charset = string2;
    }

    public boolean isBase64() {
        return this.base64;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharset() {
        return this.charset;
    }

    public byte[] toBytes() {
        return Arrays.copyOf(this.bytes, this.bytes.length);
    }

    public String toString() {
        String string;
        try {
            string = new String(this.bytes, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LogUtils.processException(logger, unsupportedEncodingException);
            return null;
        }
        return string;
    }

    public BufferedImage toImage() {
        BufferedImage bufferedImage;
        try {
            bufferedImage = ImageIO.read(new ByteArrayInputStream(this.bytes));
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
            return null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LogUtils.processException(logger, illegalArgumentException);
            return null;
        }
        return bufferedImage;
    }

    public static DataURI parse(String string) {
        byte[] byArray;
        String string2;
        if (!string.startsWith("data:")) {
            logger.warning("Data URI doesn't start with 'data:'");
            return null;
        }
        if (!string.contains(",")) {
            logger.warning("Data URI doesn't contain a comma");
            return null;
        }
        Matcher matcher = Pattern.compile("data:([^;,]+?)?(;base64)?(?:;charset=([^;,]+?))?(;base64)?,(.*)", 42).matcher(string);
        if (!matcher.find()) {
            logger.warning("Invalid data URI " + string);
            return null;
        }
        boolean bl = false;
        String string3 = "text/plain";
        String string4 = "US-ASCII";
        if (matcher.group(2) != null || matcher.group(4) != null) {
            bl = true;
        }
        if ((string2 = matcher.group(1)) != null) {
            string3 = string2;
        }
        if ((string2 = matcher.group(3)) != null) {
            string4 = string2;
        }
        String string5 = matcher.group(5);
        if (bl) {
            string5 = string5.replaceAll("\\s+", "");
        } else {
            try {
                string5 = URLDecoder.decode(string5, string4);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                LogUtils.processException(logger, unsupportedEncodingException);
                return null;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                LogUtils.processException(logger, illegalArgumentException);
                return null;
            }
        }
        try {
            byArray = string5.getBytes(string4);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LogUtils.processException(logger, unsupportedEncodingException);
            return null;
        }
        if (bl) {
            byArray = Base64.decodeBase64((byte[])byArray);
        }
        return new DataURI(byArray, bl, string3, string4);
    }
}

