/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.swing.models;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.FRDUtils;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import javax.swing.DefaultComboBoxModel;

public final class RecentsFilesComboModel
extends DefaultComboBoxModel {
    private final Stack<String> stack;
    private String keyProperties = null;
    private boolean autosave;
    private int maxRecentPhrasesCount;

    public RecentsFilesComboModel(String string, boolean bl) {
        this(new Stack<String>());
        this.maxRecentPhrasesCount = AppPrefs.getProperty("maxRecentPhrasesCount", 6);
        this.keyProperties = string;
        this.autosave = bl;
        String[] stringArray = AppPrefs.getProperty(string, "").split("\\|");
        int n = 0;
        for (String string2 : stringArray) {
            File file = new File(string2);
            if (!file.exists() || !file.isDirectory() || string2.length() <= 0) continue;
            this.stack.add(0, FileUtils.getAbsolutPath(file));
            if (++n == this.maxRecentPhrasesCount) break;
        }
    }

    private RecentsFilesComboModel(Stack<String> stack) {
        super(stack);
        this.stack = stack;
        this.autosave = false;
    }

    @Override
    public void setSelectedItem(Object object) {
        super.setSelectedItem(object);
        this.addElement(object);
    }

    @Override
    public final void addElement(Object object) {
        if (object == null) {
            return;
        }
        int n = this.getIndexOf(object);
        if (n < 0) {
            String string = object.toString().trim();
            if (!("".equals(string) || "?".equals(string) || this.getNormalizedFiles(this.stack).contains(new File(string)))) {
                super.insertElementAt(object, 0);
                if (this.stack.size() > this.maxRecentPhrasesCount) {
                    int n2 = this.stack.size() - 1;
                    this.remove(n2);
                    if (this.autosave) {
                        this.storeFiles();
                    }
                }
            }
            if (this.autosave) {
                this.storeFiles();
            }
        }
    }

    private void remove(int n) {
        this.setSelectedItem(this.getElementAt(0));
        this.stack.remove(n);
        this.fireIntervalRemoved(this, n, n);
    }

    public final Collection<String> getList() {
        return this.stack;
    }

    public void removeAllProperties() {
        AppPrefs.removeProperty(this.keyProperties);
    }

    private Set<File> getNormalizedFiles(Collection<String> collection) {
        HashSet<File> hashSet = new HashSet<File>(collection.size());
        boolean bl = Utils.isWindows();
        for (String string : collection) {
            File file;
            if (bl && !string.endsWith("\\")) {
                string = string + "\\";
            }
            if (hashSet.contains(file = new File(string))) continue;
            hashSet.add(file);
        }
        return hashSet;
    }

    public void storeFiles() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<File> iterator = this.getNormalizedFiles(this.stack).iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            stringBuilder.append(FRDUtils.getAbsRelPath(file));
            if (!iterator.hasNext()) continue;
            stringBuilder.append("|");
        }
        AppPrefs.storeProperty(this.keyProperties, stringBuilder.toString());
    }
}

