/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient.utils;

import cz.vity.freerapid.plugins.webclient.utils.IntHashMap;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

final class Entities {
    private static final String[][] BASIC_ARRAY = new String[][]{{"quot", "34"}, {"amp", "38"}, {"lt", "60"}, {"gt", "62"}};
    private static final String[][] APOS_ARRAY = new String[][]{{"apos", "39"}};
    static final String[][] ISO8859_1_ARRAY = new String[][]{{"nbsp", "160"}, {"iexcl", "161"}, {"cent", "162"}, {"pound", "163"}, {"curren", "164"}, {"yen", "165"}, {"brvbar", "166"}, {"sect", "167"}, {"uml", "168"}, {"copy", "169"}, {"ordf", "170"}, {"laquo", "171"}, {"not", "172"}, {"shy", "173"}, {"reg", "174"}, {"macr", "175"}, {"deg", "176"}, {"plusmn", "177"}, {"sup2", "178"}, {"sup3", "179"}, {"acute", "180"}, {"micro", "181"}, {"para", "182"}, {"middot", "183"}, {"cedil", "184"}, {"sup1", "185"}, {"ordm", "186"}, {"raquo", "187"}, {"frac14", "188"}, {"frac12", "189"}, {"frac34", "190"}, {"iquest", "191"}, {"Agrave", "192"}, {"Aacute", "193"}, {"Acirc", "194"}, {"Atilde", "195"}, {"Auml", "196"}, {"Aring", "197"}, {"AElig", "198"}, {"Ccedil", "199"}, {"Egrave", "200"}, {"Eacute", "201"}, {"Ecirc", "202"}, {"Euml", "203"}, {"Igrave", "204"}, {"Iacute", "205"}, {"Icirc", "206"}, {"Iuml", "207"}, {"ETH", "208"}, {"Ntilde", "209"}, {"Ograve", "210"}, {"Oacute", "211"}, {"Ocirc", "212"}, {"Otilde", "213"}, {"Ouml", "214"}, {"times", "215"}, {"Oslash", "216"}, {"Ugrave", "217"}, {"Uacute", "218"}, {"Ucirc", "219"}, {"Uuml", "220"}, {"Yacute", "221"}, {"THORN", "222"}, {"szlig", "223"}, {"agrave", "224"}, {"aacute", "225"}, {"acirc", "226"}, {"atilde", "227"}, {"auml", "228"}, {"aring", "229"}, {"aelig", "230"}, {"ccedil", "231"}, {"egrave", "232"}, {"eacute", "233"}, {"ecirc", "234"}, {"euml", "235"}, {"igrave", "236"}, {"iacute", "237"}, {"icirc", "238"}, {"iuml", "239"}, {"eth", "240"}, {"ntilde", "241"}, {"ograve", "242"}, {"oacute", "243"}, {"ocirc", "244"}, {"otilde", "245"}, {"ouml", "246"}, {"divide", "247"}, {"oslash", "248"}, {"ugrave", "249"}, {"uacute", "250"}, {"ucirc", "251"}, {"uuml", "252"}, {"yacute", "253"}, {"thorn", "254"}, {"yuml", "255"}};
    static final String[][] HTML40_ARRAY = new String[][]{{"fnof", "402"}, {"Alpha", "913"}, {"Beta", "914"}, {"Gamma", "915"}, {"Delta", "916"}, {"Epsilon", "917"}, {"Zeta", "918"}, {"Eta", "919"}, {"Theta", "920"}, {"Iota", "921"}, {"Kappa", "922"}, {"Lambda", "923"}, {"Mu", "924"}, {"Nu", "925"}, {"Xi", "926"}, {"Omicron", "927"}, {"Pi", "928"}, {"Rho", "929"}, {"Sigma", "931"}, {"Tau", "932"}, {"Upsilon", "933"}, {"Phi", "934"}, {"Chi", "935"}, {"Psi", "936"}, {"Omega", "937"}, {"alpha", "945"}, {"beta", "946"}, {"gamma", "947"}, {"delta", "948"}, {"epsilon", "949"}, {"zeta", "950"}, {"eta", "951"}, {"theta", "952"}, {"iota", "953"}, {"kappa", "954"}, {"lambda", "955"}, {"mu", "956"}, {"nu", "957"}, {"xi", "958"}, {"omicron", "959"}, {"pi", "960"}, {"rho", "961"}, {"sigmaf", "962"}, {"sigma", "963"}, {"tau", "964"}, {"upsilon", "965"}, {"phi", "966"}, {"chi", "967"}, {"psi", "968"}, {"omega", "969"}, {"thetasym", "977"}, {"upsih", "978"}, {"piv", "982"}, {"bull", "8226"}, {"hellip", "8230"}, {"prime", "8242"}, {"Prime", "8243"}, {"oline", "8254"}, {"frasl", "8260"}, {"weierp", "8472"}, {"image", "8465"}, {"real", "8476"}, {"trade", "8482"}, {"alefsym", "8501"}, {"larr", "8592"}, {"uarr", "8593"}, {"rarr", "8594"}, {"darr", "8595"}, {"harr", "8596"}, {"crarr", "8629"}, {"lArr", "8656"}, {"uArr", "8657"}, {"rArr", "8658"}, {"dArr", "8659"}, {"hArr", "8660"}, {"forall", "8704"}, {"part", "8706"}, {"exist", "8707"}, {"empty", "8709"}, {"nabla", "8711"}, {"isin", "8712"}, {"notin", "8713"}, {"ni", "8715"}, {"prod", "8719"}, {"sum", "8721"}, {"minus", "8722"}, {"lowast", "8727"}, {"radic", "8730"}, {"prop", "8733"}, {"infin", "8734"}, {"ang", "8736"}, {"and", "8743"}, {"or", "8744"}, {"cap", "8745"}, {"cup", "8746"}, {"int", "8747"}, {"there4", "8756"}, {"sim", "8764"}, {"cong", "8773"}, {"asymp", "8776"}, {"ne", "8800"}, {"equiv", "8801"}, {"le", "8804"}, {"ge", "8805"}, {"sub", "8834"}, {"sup", "8835"}, {"sube", "8838"}, {"supe", "8839"}, {"oplus", "8853"}, {"otimes", "8855"}, {"perp", "8869"}, {"sdot", "8901"}, {"lceil", "8968"}, {"rceil", "8969"}, {"lfloor", "8970"}, {"rfloor", "8971"}, {"lang", "9001"}, {"rang", "9002"}, {"loz", "9674"}, {"spades", "9824"}, {"clubs", "9827"}, {"hearts", "9829"}, {"diams", "9830"}, {"OElig", "338"}, {"oelig", "339"}, {"Scaron", "352"}, {"scaron", "353"}, {"Yuml", "376"}, {"circ", "710"}, {"tilde", "732"}, {"ensp", "8194"}, {"emsp", "8195"}, {"thinsp", "8201"}, {"zwnj", "8204"}, {"zwj", "8205"}, {"lrm", "8206"}, {"rlm", "8207"}, {"ndash", "8211"}, {"mdash", "8212"}, {"lsquo", "8216"}, {"rsquo", "8217"}, {"sbquo", "8218"}, {"ldquo", "8220"}, {"rdquo", "8221"}, {"bdquo", "8222"}, {"dagger", "8224"}, {"Dagger", "8225"}, {"permil", "8240"}, {"lsaquo", "8249"}, {"rsaquo", "8250"}, {"euro", "8364"}};
    public static final Entities XML = new Entities();
    public static final Entities HTML32;
    public static final Entities HTML40;
    EntityMap map = new LookupEntityMap();

    Entities() {
    }

    static void fillWithHtml40Entities(Entities entities) {
        entities.addEntities(BASIC_ARRAY);
        entities.addEntities(ISO8859_1_ARRAY);
        entities.addEntities(HTML40_ARRAY);
    }

    public void addEntities(String[][] stringArray) {
        for (String[] stringArray2 : stringArray) {
            this.addEntity(stringArray2[0], Integer.parseInt(stringArray2[1]));
        }
    }

    public void addEntity(String string, int n) {
        this.map.add(string, n);
    }

    public String entityName(int n) {
        return this.map.name(n);
    }

    public int entityValue(String string) {
        return this.map.value(string);
    }

    public String escape(String string) {
        StringWriter stringWriter = this.createStringWriter(string);
        try {
            this.escape(stringWriter, string);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return stringWriter.toString();
    }

    public void escape(Writer writer, String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            String string2 = this.entityName(c);
            if (string2 == null) {
                if (c > '\u007f') {
                    writer.write("&#");
                    writer.write(Integer.toString(c, 10));
                    writer.write(59);
                    continue;
                }
                writer.write(c);
                continue;
            }
            writer.write(38);
            writer.write(string2);
            writer.write(59);
        }
    }

    public String unescape(String string) {
        int n = string.indexOf(38);
        if (n < 0) {
            return string;
        }
        StringWriter stringWriter = this.createStringWriter(string);
        try {
            this.doUnescape(stringWriter, string, n);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        return stringWriter.toString();
    }

    private StringWriter createStringWriter(String string) {
        return new StringWriter((int)((double)string.length() + (double)string.length() * 0.1));
    }

    public void unescape(Writer writer, String string) throws IOException {
        int n = string.indexOf(38);
        if (n < 0) {
            writer.write(string);
        } else {
            this.doUnescape(writer, string, n);
        }
    }

    private void doUnescape(Writer writer, String string, int n) throws IOException {
        writer.write(string, 0, n);
        int n2 = string.length();
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (c == '&') {
                int n3 = i + 1;
                int n4 = string.indexOf(59, n3);
                if (n4 == -1) {
                    writer.write(c);
                    continue;
                }
                int n5 = string.indexOf(38, i + 1);
                if (n5 != -1 && n5 < n4) {
                    writer.write(c);
                    continue;
                }
                String string2 = string.substring(n3, n4);
                int n6 = -1;
                int n7 = string2.length();
                if (n7 > 0) {
                    if (string2.charAt(0) == '#') {
                        if (n7 > 1) {
                            char c2 = string2.charAt(1);
                            try {
                                switch (c2) {
                                    case 'X': 
                                    case 'x': {
                                        n6 = Integer.parseInt(string2.substring(2), 16);
                                        break;
                                    }
                                    default: {
                                        n6 = Integer.parseInt(string2.substring(1), 10);
                                    }
                                }
                                if (n6 > 65535) {
                                    n6 = -1;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                n6 = -1;
                            }
                        }
                    } else {
                        n6 = this.entityValue(string2);
                    }
                }
                if (n6 == -1) {
                    writer.write(38);
                    writer.write(string2);
                    writer.write(59);
                } else {
                    writer.write(n6);
                }
                i = n4;
                continue;
            }
            writer.write(c);
        }
    }

    static {
        XML.addEntities(BASIC_ARRAY);
        XML.addEntities(APOS_ARRAY);
        HTML32 = new Entities();
        HTML32.addEntities(BASIC_ARRAY);
        HTML32.addEntities(ISO8859_1_ARRAY);
        HTML40 = new Entities();
        Entities.fillWithHtml40Entities(HTML40);
    }

    static class BinaryEntityMap
    extends ArrayEntityMap {
        public BinaryEntityMap() {
        }

        public BinaryEntityMap(int n) {
            super(n);
        }

        private int binarySearch(int n) {
            int n2 = 0;
            int n3 = this.size - 1;
            while (n2 <= n3) {
                int n4 = n2 + n3 >>> 1;
                int n5 = this.values[n4];
                if (n5 < n) {
                    n2 = n4 + 1;
                    continue;
                }
                if (n5 > n) {
                    n3 = n4 - 1;
                    continue;
                }
                return n4;
            }
            return -(n2 + 1);
        }

        @Override
        public void add(String string, int n) {
            this.ensureCapacity(this.size + 1);
            int n2 = this.binarySearch(n);
            if (n2 > 0) {
                return;
            }
            n2 = -(n2 + 1);
            System.arraycopy(this.values, n2, this.values, n2 + 1, this.size - n2);
            this.values[n2] = n;
            System.arraycopy(this.names, n2, this.names, n2 + 1, this.size - n2);
            this.names[n2] = string;
            ++this.size;
        }

        @Override
        public String name(int n) {
            int n2 = this.binarySearch(n);
            if (n2 < 0) {
                return null;
            }
            return this.names[n2];
        }
    }

    static class ArrayEntityMap
    implements EntityMap {
        protected int growBy = 100;
        protected int size = 0;
        protected String[] names;
        protected int[] values;

        public ArrayEntityMap() {
            this.names = new String[this.growBy];
            this.values = new int[this.growBy];
        }

        public ArrayEntityMap(int n) {
            this.growBy = n;
            this.names = new String[n];
            this.values = new int[n];
        }

        @Override
        public void add(String string, int n) {
            this.ensureCapacity(this.size + 1);
            this.names[this.size] = string;
            this.values[this.size] = n;
            ++this.size;
        }

        protected void ensureCapacity(int n) {
            if (n > this.names.length) {
                int n2 = Math.max(n, this.size + this.growBy);
                String[] stringArray = new String[n2];
                System.arraycopy(this.names, 0, stringArray, 0, this.size);
                this.names = stringArray;
                int[] nArray = new int[n2];
                System.arraycopy(this.values, 0, nArray, 0, this.size);
                this.values = nArray;
            }
        }

        @Override
        public String name(int n) {
            for (int i = 0; i < this.size; ++i) {
                if (this.values[i] != n) continue;
                return this.names[i];
            }
            return null;
        }

        @Override
        public int value(String string) {
            for (int i = 0; i < this.size; ++i) {
                if (!this.names[i].equals(string)) continue;
                return this.values[i];
            }
            return -1;
        }
    }

    static class LookupEntityMap
    extends PrimitiveEntityMap {
        private String[] lookupTable;
        private int LOOKUP_TABLE_SIZE = 256;

        LookupEntityMap() {
        }

        @Override
        public String name(int n) {
            if (n < this.LOOKUP_TABLE_SIZE) {
                return this.lookupTable()[n];
            }
            return super.name(n);
        }

        private String[] lookupTable() {
            if (this.lookupTable == null) {
                this.createLookupTable();
            }
            return this.lookupTable;
        }

        private void createLookupTable() {
            this.lookupTable = new String[this.LOOKUP_TABLE_SIZE];
            for (int i = 0; i < this.LOOKUP_TABLE_SIZE; ++i) {
                this.lookupTable[i] = super.name(i);
            }
        }
    }

    static class TreeEntityMap
    extends MapIntMap {
        public TreeEntityMap() {
            this.mapNameToValue = new TreeMap();
            this.mapValueToName = new TreeMap();
        }
    }

    static class HashEntityMap
    extends MapIntMap {
        public HashEntityMap() {
            this.mapNameToValue = new HashMap();
            this.mapValueToName = new HashMap();
        }
    }

    static abstract class MapIntMap
    implements EntityMap {
        protected Map<String, Integer> mapNameToValue;
        protected Map<Integer, String> mapValueToName;

        MapIntMap() {
        }

        @Override
        public void add(String string, int n) {
            this.mapNameToValue.put(string, n);
            this.mapValueToName.put(n, string);
        }

        @Override
        public String name(int n) {
            return this.mapValueToName.get(n);
        }

        @Override
        public int value(String string) {
            Integer n = this.mapNameToValue.get(string);
            if (n == null) {
                return -1;
            }
            return n;
        }
    }

    static class PrimitiveEntityMap
    implements EntityMap {
        private Map<String, Integer> mapNameToValue = new HashMap<String, Integer>();
        private IntHashMap mapValueToName = new IntHashMap();

        PrimitiveEntityMap() {
        }

        @Override
        public void add(String string, int n) {
            this.mapNameToValue.put(string, n);
            this.mapValueToName.put(n, string);
        }

        @Override
        public String name(int n) {
            return (String)this.mapValueToName.get(n);
        }

        @Override
        public int value(String string) {
            Integer n = this.mapNameToValue.get(string);
            if (n == null) {
                return -1;
            }
            return n;
        }
    }

    static interface EntityMap {
        public void add(String var1, int var2);

        public String name(int var1);

        public int value(String var1);
    }
}

