/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.plugins.webclient;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.Proxy;
import javax.swing.event.SwingPropertyChangeSupport;
import org.jdesktop.application.Application;

public class ConnectionSettings {
    private String userName;
    private String password;
    private String proxyURL;
    private int proxyPort;
    private boolean proxySet;
    private boolean enabled = true;
    private String defaultConnectionLabel;
    private final PropertyChangeSupport pcs;
    private boolean isDefault = false;
    private Proxy.Type proxyType = Proxy.Type.DIRECT;

    public ConnectionSettings() {
        this.defaultConnectionLabel = Application.getInstance().getContext().getResourceMap().getString("defaultConnection", new Object[0]);
        this.pcs = new SwingPropertyChangeSupport(this);
        this.proxyType = Proxy.Type.DIRECT;
    }

    public void setProxy(String string, int n, Proxy.Type type, String string2, String string3) {
        this.userName = string2;
        this.password = string3;
        this.setProxy(string, n, type);
    }

    public void setProxy(String string, int n) {
        this.setProxy(string, n, Proxy.Type.HTTP);
    }

    public void setProxy(String string, int n, Proxy.Type type) {
        this.proxyURL = string;
        this.proxyPort = n;
        this.proxyType = type;
        this.proxySet = true;
    }

    public boolean isProxySet() {
        return this.proxySet;
    }

    public Proxy.Type getProxyType() {
        return this.proxyType;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyURL() {
        return this.proxyURL;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserName() {
        return this.userName;
    }

    public boolean hasUserName() {
        return this.userName != null;
    }

    public String toString() {
        if (this.isProxySet()) {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.hasUserName()) {
                stringBuilder.append(this.getUserName()).append('@');
            }
            stringBuilder.append(this.getProxyURL()).append(':').append(this.getProxyPort()).append(' ').append('(').append((Object)this.getProxyType()).append(')');
            return stringBuilder.toString();
        }
        return this.defaultConnectionLabel;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ConnectionSettings connectionSettings = (ConnectionSettings)object;
        if (this.proxyPort != connectionSettings.proxyPort) {
            return false;
        }
        if (this.proxySet != connectionSettings.proxySet) {
            return false;
        }
        if (this.proxyType != connectionSettings.proxyType) {
            return false;
        }
        if (this.proxyURL != null ? !this.proxyURL.equalsIgnoreCase(connectionSettings.proxyURL) : connectionSettings.proxyURL != null) {
            return false;
        }
        return !(this.userName != null ? !this.userName.equals(connectionSettings.userName) : connectionSettings.userName != null);
    }

    public void setProxyType(Proxy.Type type) {
        this.proxyType = type;
    }

    public int hashCode() {
        int n = this.userName != null ? this.userName.hashCode() : 0;
        n = 31 * n + (this.proxyURL != null ? this.proxyURL.toLowerCase().hashCode() : 0);
        n = 31 * n + this.proxyPort;
        n = 31 * n + (this.proxySet ? 1 : 0);
        n = 31 * n + (this.proxyType != null ? this.proxyType.hashCode() : 0);
        return n;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        boolean bl2 = this.enabled;
        this.enabled = bl;
        this.pcs.firePropertyChange("enabled", bl2, bl);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean bl) {
        this.isDefault = bl;
    }
}

