/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.application.TaskService;

public class TaskServiceManager {
    private static final Logger logger = Logger.getLogger(TaskServiceManager.class.getName());
    public static final String DOWNLOAD_SERVICE = "downloadService";
    public static final String MOVE_FILE_SERVICE = "moveFile";
    public static final String WORK_WITH_FILE_SERVICE = "workWithFile";
    private ApplicationContext context;

    public TaskServiceManager(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    public synchronized TaskService getTaskService(String string) {
        TaskService taskService = this.context.getTaskService(string);
        if (taskService == null) {
            if (DOWNLOAD_SERVICE.equals(string)) {
                return this.initDownloadTaskService();
            }
            if (MOVE_FILE_SERVICE.equals(string)) {
                return this.initMoveFileTaskService();
            }
            if (WORK_WITH_FILE_SERVICE.equals(string)) {
                return this.initWorkWithFileTaskService();
            }
        }
        return taskService;
    }

    private TaskService initDownloadTaskService() {
        return this.initTaskService(1, 11, 60L, DOWNLOAD_SERVICE, new SynchronousQueue<Runnable>());
    }

    private TaskService initMoveFileTaskService() {
        return this.initTaskService(1, 1, 5L, MOVE_FILE_SERVICE, new LinkedBlockingQueue<Runnable>());
    }

    private TaskService initWorkWithFileTaskService() {
        return this.initTaskService(1, 1, 5L, WORK_WITH_FILE_SERVICE, new LinkedBlockingQueue<Runnable>());
    }

    private TaskService initTaskService(int n, int n2, long l, String string, BlockingQueue<Runnable> blockingQueue) {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(n, n2, l, TimeUnit.SECONDS, blockingQueue);
        TaskService taskService = new TaskService(string, (ExecutorService)threadPoolExecutor);
        this.context.addTaskService(taskService);
        logger.info("Creating pool " + string);
        return taskService;
    }

    public void runTask(String string, Task task) {
        this.getTaskService(string).execute(task);
    }
}

