/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.dialogs;

import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.layout.Size;
import com.jgoodies.forms.layout.Sizes;
import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.gui.content.ContentPanel;
import cz.vity.freerapid.gui.dialogs.AppDialog;
import cz.vity.freerapid.gui.dialogs.WrappedPluginData;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.UpdateManager;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import cz.vity.freerapid.swing.SwingUtils;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.Task;
import org.jdesktop.swinghelper.buttonpanel.JXButtonPanel;
import org.jdesktop.swingx.JXTable;

public class UpdateDialog
extends AppDialog
implements PropertyChangeListener {
    private static final Logger logger = Logger.getLogger(UpdateDialog.class.getName());
    private final ManagerDirector managerDirector;
    private static final int COLUMN_SELECTED = 0;
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_VERSION = 2;
    private static final int COLUMN_SERVICES = 3;
    private static final int COLUMN_AUTHOR = 4;
    private static final int COLUMN_PROGRESS = 5;
    private static final int COLUMN_STATUS = 6;
    private ArrayListModel<WrappedPluginData> listModel = new ArrayListModel();
    private JXTable table;
    private JLabel labelServer;
    private JLabel labelUpdatesCount;
    private JButton btnOK;
    private JButton btnCancel;

    public UpdateDialog(Frame frame, ManagerDirector managerDirector) throws HeadlessException {
        super(frame, true);
        this.managerDirector = managerDirector;
        this.setName("UpdateDialog");
        try {
            this.initComponents();
            this.build();
        }
        catch (Exception exception) {
            LogUtils.processException(logger, exception);
            this.doClose();
        }
    }

    @Override
    protected AbstractButton getBtnOK() {
        return this.btnCancel;
    }

    @Override
    protected AbstractButton getBtnCancel() {
        return this.btnCancel;
    }

    private void build() {
        this.inject();
        this.buildGUI();
        this.setAction(this.btnOK, "okBtnAction");
        this.setAction(this.btnCancel, "btnCancelAction");
    }

    @Action
    public void okBtnAction() {
        this.getActionMap().get("okBtnAction").setEnabled(false);
        this.table.setEditable(false);
        Swinger.inputFocus(this.btnCancel);
        UpdateManager updateManager = this.managerDirector.getUpdateManager();
        Task task = updateManager.getDownloadPluginsTask(new LinkedList<WrappedPluginData>((Collection<WrappedPluginData>)this.listModel), false);
        if (task == null) {
            return;
        }
        updateManager.executeUpdateTask(task);
    }

    @Action
    public void btnCancelAction() {
        this.doClose();
    }

    @Action
    public void btnCloseAction() {
        this.doClose();
    }

    private void buildGUI() {
        this.initTable();
        this.labelServer.setText(AppPrefs.getProperty("pluginCheckUrlSelected", "http://wordrider.net/freerapid/pluginsCheck.php"));
        Swinger.inputFocus((JComponent)this.table);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DownloadFile downloadFile = (DownloadFile)propertyChangeEvent.getSource();
                UpdateDialog.this.listModel.fireContentsChanged(UpdateDialog.this.getIndex(downloadFile));
            }
        });
    }

    private int getIndex(DownloadFile downloadFile) {
        int n = 0;
        for (WrappedPluginData wrappedPluginData : this.listModel) {
            if (wrappedPluginData.getHttpFile().equals(downloadFile)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void initTable() {
        this.table.setName("updatePluginsTable");
        this.table.setModel((TableModel)new CustomTableModel(this.listModel, this.getList("columns")));
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.setEditable(true);
        this.table.setColumnControlVisible(true);
        this.table.setSortable(true);
        this.table.setRolloverEnabled(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.createDefaultColumnsFromModel();
        this.table.setSelectionMode(0);
        Swinger.updateColumn((JTable)this.table, "Selected", 0, 25, 40, null).setMaxWidth(75);
        Swinger.updateColumn((JTable)this.table, "Name", 1, -1, 70, null);
        Swinger.updateColumn((JTable)this.table, "Version", 2, -1, 50, null);
        Swinger.updateColumn((JTable)this.table, "Services", 3, -1, 50, null);
        Swinger.updateColumn((JTable)this.table, "Author", 4, -1, 50, null);
        Swinger.updateColumn((JTable)this.table, "Progress", 5, -1, 70, new ProgressBarCellRenderer());
        Swinger.updateColumn((JTable)this.table, "Status", 6, -1, 80, null);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (!UpdateDialog.this.table.hasFocus()) {
                    Swinger.inputFocus((JComponent)UpdateDialog.this.table);
                }
            }
        });
        InputMap inputMap = this.table.getInputMap();
        ActionMap actionMap = this.table.getActionMap();
        ActionMap actionMap2 = this.getActionMap();
        inputMap.put(SwingUtils.getCtrlKeyStroke(67), "copy");
        actionMap.put("copy", actionMap2.get("copyContent"));
        KeyStroke keyStroke = SwingUtils.getCtrlKeyStroke(70);
        inputMap.remove(keyStroke);
        this.table.getParent().setPreferredSize(new Dimension(450, 250));
        inputMap.put(SwingUtils.getShiftKeyStroke(36), "selectFirstRowExtendSelection");
        inputMap.put(SwingUtils.getShiftKeyStroke(35), "selectLastRowExtendSelection");
    }

    public void initData(List<WrappedPluginData> list) {
        this.cleanup();
        this.labelUpdatesCount.setText(this.getResourceMap().getString("labelUpdatesCount", new Object[]{list.size()}));
        this.listModel.clear();
        for (WrappedPluginData wrappedPluginData : list) {
            wrappedPluginData.getHttpFile().addPropertyChangeListener(this);
            this.listModel.add((Object)wrappedPluginData);
        }
    }

    @Override
    public void doClose() {
        super.doClose();
        this.cleanup();
    }

    private void cleanup() {
        for (WrappedPluginData wrappedPluginData : this.listModel) {
            wrappedPluginData.getHttpFile().removePropertyChangeListener(this);
        }
    }

    private void initComponents() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this.table = new JXTable();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel = new JLabel();
        this.labelServer = new JLabel();
        this.labelUpdatesCount = new JLabel();
        JXButtonPanel jXButtonPanel = new JXButtonPanel();
        this.btnOK = new JButton();
        this.btnCancel = new JButton();
        CellConstraints cellConstraints = new CellConstraints();
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        jPanel.setBorder(new EmptyBorder(12, 12, 12, 12));
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout(4, 4));
        jScrollPane.setViewportView((Component)this.table);
        jPanel2.add((Component)jScrollPane, "Center");
        jLabel.setName("labelUpdateServer");
        this.labelServer.setName("server");
        this.labelUpdatesCount.setName("labelUpdatesCount");
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.LABEL_COMPONENT_GAP_COLSPEC, new ColumnSpec(ColumnSpec.FILL, (Size)Sizes.DEFAULT, 1.0), FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC}, RowSpec.decodeSpecs((String)"default")), jPanel3);
        panelBuilder.add((Component)jLabel, cellConstraints.xy(1, 1));
        panelBuilder.add((Component)this.labelServer, cellConstraints.xy(3, 1));
        panelBuilder.add((Component)this.labelUpdatesCount, cellConstraints.xy(7, 1));
        jPanel2.add((Component)jPanel3, "North");
        jPanel.add((Component)jPanel2, "Center");
        jXButtonPanel.setBorder(Borders.BUTTON_BAR_GAP_BORDER);
        jXButtonPanel.setCyclic(true);
        this.btnOK.setName("btnOK");
        this.btnCancel.setName("btnCancel");
        panelBuilder = new PanelBuilder(new FormLayout(new ColumnSpec[]{FormFactory.LABEL_COMPONENT_GAP_COLSPEC, FormFactory.DEFAULT_COLSPEC, FormFactory.GLUE_COLSPEC, new ColumnSpec("max(pref;42dlu)"), FormFactory.RELATED_GAP_COLSPEC, FormFactory.PREF_COLSPEC}, RowSpec.decodeSpecs((String)"pref")), (JPanel)jXButtonPanel);
        ((FormLayout)jXButtonPanel.getLayout()).setColumnGroups((int[][])new int[][]{{4, 6}});
        panelBuilder.add((Component)this.btnOK, cellConstraints.xy(4, 1));
        panelBuilder.add((Component)this.btnCancel, cellConstraints.xy(6, 1));
        jPanel.add((Component)jXButtonPanel, "South");
        container.add((Component)jPanel, "Center");
    }

    private static class ProgressBarCellRenderer
    extends JProgressBar
    implements TableCellRenderer {
        public ProgressBarCellRenderer() {
            super(0, 100);
            int n = this.getPreferredSize().height;
            this.setPreferredSize(new Dimension(70, n));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            DownloadFile downloadFile = (DownloadFile)object;
            this.setToolTipText(null);
            int n3 = ContentPanel.getProgress(downloadFile);
            this.setStringPainted(true);
            this.setString(n3 + "%");
            this.setValue(n3);
            return this;
        }
    }

    private class CustomTableModel
    extends AbstractTableModel
    implements ListDataListener {
        private final ArrayListModel<WrappedPluginData> model;
        private final String[] columns;

        public CustomTableModel(ArrayListModel<WrappedPluginData> arrayListModel, String[] stringArray) {
            this.model = arrayListModel;
            this.columns = stringArray;
            arrayListModel.addListDataListener((ListDataListener)this);
        }

        @Override
        public int getRowCount() {
            return this.model.getSize();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                ((WrappedPluginData)this.model.get(n)).setSelected((Boolean)object);
                this.fireTableCellUpdated(n, n2);
            }
        }

        @Override
        public String getColumnName(int n) {
            return this.columns[n];
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            WrappedPluginData wrappedPluginData = (WrappedPluginData)this.model.get(n);
            switch (n2) {
                case 0: {
                    return wrappedPluginData.isSelected();
                }
                case 1: {
                    return wrappedPluginData.getID();
                }
                case 2: {
                    return wrappedPluginData.getVersion();
                }
                case 3: {
                    return wrappedPluginData.getServices();
                }
                case 4: {
                    return wrappedPluginData.getAuthor();
                }
                case 5: {
                    return wrappedPluginData.getHttpFile();
                }
                case 6: {
                    return this.getStatus(wrappedPluginData);
                }
            }
            assert (false);
            return wrappedPluginData;
        }

        private Object getStatus(WrappedPluginData wrappedPluginData) {
            DownloadState downloadState = wrappedPluginData.getHttpFile().getState();
            if (downloadState == DownloadState.PAUSED || downloadState == DownloadState.QUEUED) {
                if (wrappedPluginData.isToBeDeleted()) {
                    return UpdateDialog.this.getResourceMap().getString("stateOldPlugin", new Object[0]);
                }
                if (wrappedPluginData.isNew()) {
                    return UpdateDialog.this.getResourceMap().getString("stateNew", new Object[0]);
                }
                return UpdateDialog.this.getResourceMap().getString("stateNotActualized", new Object[0]);
            }
            if (downloadState == DownloadState.CANCELLED) {
                return UpdateDialog.this.getResourceMap().getString("stateCancelled", new Object[0]);
            }
            if (downloadState == DownloadState.ERROR) {
                return UpdateDialog.this.getResourceMap().getString("stateError", new Object[0]) + ":" + wrappedPluginData.getHttpFile().getErrorMessage();
            }
            if (downloadState == DownloadState.COMPLETED) {
                return UpdateDialog.this.getResourceMap().getString("stateActualized", new Object[0]);
            }
            return null;
        }

        @Override
        public void intervalAdded(ListDataEvent listDataEvent) {
            this.fireTableRowsInserted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.fireTableRowsDeleted(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }

        @Override
        public void contentsChanged(ListDataEvent listDataEvent) {
            this.fireTableRowsUpdated(listDataEvent.getIndex0(), listDataEvent.getIndex1());
        }
    }
}

