/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.actions;

import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.PluginsManager;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.apache.commons.httpclient.URIException;

public abstract class URLTransferHandler
extends TransferHandler {
    private static final Logger logger = Logger.getLogger(URLTransferHandler.class.getName());
    private static final Pattern REGEXP_URL = Pattern.compile("((http|https)://)?([a-zA-Z0-9\\.\\-]+(:[a-zA-Z0-9\\.:&%\\$\\-]+)*@)?((25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9])\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[1-9]|0)\\.(25[0-5]|2[0-4][0-9]|[0-1][0-9]{2}|[1-9][0-9]|[0-9])|([a-zA-Z0-9\\-]+\\.)*[a-zA-Z0-9\\-]+\\.[a-zA-Z]{2,4})(:[0-9]+)?(/[^/][\\p{Lu}\\p{Ll}0-9\\[\\]\\.:,\\?'\\\\/\\+&%\\$#=~_\\-@]*)*", 8);
    private static final String URL_LIST_MIME_TYPE = "application/x-java-url; class=java.net.URL";
    private List<URL> urls;
    private PluginsManager pluginsManager;

    protected abstract void doDropAction(List<URL> var1);

    public URLTransferHandler(ManagerDirector managerDirector) {
        this.pluginsManager = managerDirector.getPluginsManager();
    }

    public static List<URL> textURIListToFileList(String string, PluginsManager pluginsManager, boolean bl) {
        HashSet<Object> hashSet = new HashSet<Object>();
        LinkedList<URL> linkedList = new LinkedList<URL>();
        string = string.replaceAll("(\\p{Punct}|[\\t\\n\\x0B\\f\\r])http(s)?(?!%3A%2F%2F)", "  http$2");
        Matcher matcher = REGEXP_URL.matcher(string);
        int n = 0;
        Pattern pattern = Pattern.compile("(.+)\\.{3,}");
        while (matcher.find(n)) {
            try {
                int n2;
                int n3;
                URL uRL;
                boolean bl2;
                String string2 = matcher.group();
                if (!string2.startsWith("http://")) {
                    string2 = "http://" + string2;
                }
                if (!(bl2 = pluginsManager.isSupported(uRL = new URL(URLTransferHandler.updateApostrophs(string2)), bl)) && (n3 = string2.indexOf("http%3A%2F%2F")) >= 0) {
                    n2 = string2.indexOf(38, n3);
                    string2 = n2 > 0 ? string2.substring(n3, n2) : string2.substring(n3);
                    string2 = Utils.urlDecode(string2);
                    uRL = new URL(URLTransferHandler.updateApostrophs(string2));
                    bl2 = pluginsManager.isSupported(uRL, bl);
                }
                if (!bl2 && (n3 = string2.toLowerCase(Locale.ENGLISH).indexOf("//:ptth")) >= 0) {
                    n2 = string2.indexOf("url=", 0);
                    if (n2 != -1) {
                        if (n2 < n3) {
                            string2 = Utils.reverseString(string2.substring(n2 + 4, n3));
                        } else {
                            n2 = -1;
                        }
                    } else {
                        n2 = string2.indexOf(63, 0);
                        if (n2 != -1) {
                            if (n2 < n3) {
                                string2 = Utils.reverseString(string2.substring(n2 + 1, n3));
                            } else {
                                n2 = -1;
                            }
                        } else {
                            n2 = string2.indexOf(61, 0);
                            if (n2 != -1) {
                                if (n2 < n3) {
                                    string2 = Utils.reverseString(string2.substring(n2 + 1, n3));
                                } else {
                                    n2 = -1;
                                }
                            }
                        }
                    }
                    if (n2 != -1) {
                        string2 = Utils.urlDecode("http://" + string2);
                        uRL = new URL(URLTransferHandler.updateApostrophs(string2));
                        bl2 = pluginsManager.isSupported(uRL, bl);
                    }
                }
                if (bl2) {
                    String string3 = uRL.toExternalForm();
                    n2 = string3.indexOf("...");
                    Pattern pattern2 = null;
                    Matcher matcher2 = pattern.matcher(string3);
                    boolean bl3 = matcher2.matches();
                    if (n2 > 0 && !bl3) {
                        String string4 = Pattern.quote(string3.substring(0, n2)) + ".+" + Pattern.quote(string3.substring(n2 + 4));
                        pattern2 = Pattern.compile(string4);
                    }
                    boolean bl4 = false;
                    Object object = hashSet.iterator();
                    while (object.hasNext()) {
                        URI uRI = (URI)object.next();
                        String string5 = uRI.toURL().toExternalForm();
                        if (string5.length() <= string3.length() || !string5.startsWith(string3) && (pattern2 == null || !pattern2.matcher(string5).matches()) && (!bl3 || !string5.startsWith(matcher2.group(1)))) continue;
                        bl4 = true;
                        break;
                    }
                    if (!bl4 && !hashSet.contains(object = Utils.convertToURI(string3))) {
                        hashSet.add(object);
                        linkedList.add(((URI)object).toURL());
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (URIException uRIException) {
                // empty catch block
            }
            n = matcher.end();
        }
        return linkedList;
    }

    private static String updateApostrophs(String string) {
        if (string.endsWith("'") && string.length() > 2) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        return super.importData(jComponent, transferable);
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        return super.canImport(jComponent, dataFlavorArray);
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport transferSupport) {
        if (!transferSupport.isDrop()) {
            return super.canImport(transferSupport);
        }
        for (DataFlavor dataFlavor : transferSupport.getDataFlavors()) {
            if (dataFlavor.isFlavorTextType()) {
                return true;
            }
            if (!dataFlavor.isMimeTypeEqual(URL_LIST_MIME_TYPE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport transferSupport) {
        Transferable transferable = transferSupport.getTransferable();
        logger.info("Trying to import:" + transferable);
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor(URL_LIST_MIME_TYPE);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogUtils.processException(logger, classNotFoundException);
        }
        this.urls = new LinkedList<URL>();
        try {
            block28: {
                if (dataFlavor != null && transferable.isDataFlavorSupported(dataFlavor)) {
                    try {
                        Object object = transferable.getTransferData(dataFlavor);
                        if (!(object instanceof URL)) break block28;
                        URL uRL = (URL)object;
                        if (this.pluginsManager.isSupported(uRL, true)) {
                            this.urls.add(uRL);
                            break block28;
                        }
                        try {
                            String string = uRL.toExternalForm();
                            this.urls.addAll(URLTransferHandler.textURIListToFileList(string, this.pluginsManager, true));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            LogUtils.processException(logger, illegalArgumentException);
                        }
                    }
                    catch (UnsupportedFlavorException unsupportedFlavorException) {
                    }
                    catch (IOException iOException) {
                    }
                    catch (NullPointerException nullPointerException) {
                        LogUtils.processException(logger, nullPointerException);
                    }
                } else {
                    DataFlavor dataFlavor2 = null;
                    try {
                        dataFlavor2 = new DataFlavor("application/xhtml+xml;class=java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        LogUtils.processException(logger, classNotFoundException);
                    }
                    if (dataFlavor2 != null && transferable.isDataFlavorSupported(dataFlavor2)) {
                        String string = (String)transferable.getTransferData(dataFlavor2);
                        this.urls = URLTransferHandler.textURIListToFileList(string, this.pluginsManager, true);
                    } else {
                        DataFlavor dataFlavor3 = null;
                        try {
                            dataFlavor3 = new DataFlavor("text/html;class=java.lang.String");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            LogUtils.processException(logger, classNotFoundException);
                        }
                        if (dataFlavor3 != null && transferable.isDataFlavorSupported(dataFlavor3)) {
                            String string = (String)transferable.getTransferData(dataFlavor3);
                            if (!Pattern.compile("<a\\s", 10).matcher(string).find()) {
                                if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                                    string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                                    this.urls = URLTransferHandler.textURIListToFileList(string, this.pluginsManager, true);
                                } else {
                                    this.urls = URLTransferHandler.textURIListToFileList(string, this.pluginsManager, true);
                                }
                            } else {
                                this.urls = URLTransferHandler.textURIListToFileList(string, this.pluginsManager, true);
                            }
                        } else if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                            this.urls = URLTransferHandler.textURIListToFileList(string, this.pluginsManager, true);
                        }
                    }
                }
            }
            if (this.urls.isEmpty()) {
                logger.info("Importing drag and drop failed or unsupported.");
                this.doDropAction(new LinkedList<URL>());
                return false;
            }
            logger.info("Imported files " + Arrays.toString(this.urls.toArray()));
            this.doDropAction(this.urls);
            return true;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            LogUtils.processException(logger, unsupportedFlavorException);
        }
        catch (IOException iOException) {
            LogUtils.processException(logger, iOException);
        }
        return false;
    }

    public List<URL> getUrls() {
        return this.urls;
    }
}

