/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.plugins.exceptions.FileTransferFailedException;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.logging.Logger;
import org.jdesktop.application.Application;

public class MoveFileTask
extends CoreTask<Void, Void> {
    private static final Logger logger = Logger.getLogger(MoveFileTask.class.getName());
    private final File from;
    private File to;
    private final boolean deleteSource;
    private final boolean overWriteExisting;
    private final DownloadFile downloadFile;
    private static final int BSIZE = 4096;

    public MoveFileTask(Application application, File file, File file2, boolean bl, boolean bl2, DownloadFile downloadFile) {
        super(application);
        this.from = file;
        this.to = file2;
        this.deleteSource = bl;
        this.overWriteExisting = bl2;
        this.downloadFile = downloadFile;
        this.setTaskToForeground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Void doInBackground() throws Exception {
        if (!this.from.exists()) {
            return null;
        }
        if (this.to.exists()) {
            if (!this.overWriteExisting) {
                this.to = this.getNewUniqueFileName(this.to);
            } else {
                this.to.delete();
            }
        }
        this.message("Moving_file", new Object[0]);
        File file = this.to.getParentFile();
        if (!file.exists() && !file.mkdirs()) {
            throw new FileTransferFailedException(this.getResourceMap().getString("creatingOutputFilePathFailed", new Object[0]));
        }
        if (this.from.renameTo(this.to)) {
            this.saveToHistoryList();
            this.saveDescriptionFiles();
            return null;
        }
        this.saveDescriptionFiles();
        FileChannel fileChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        try {
            try {
                int n;
                fileChannel = new FileInputStream(this.from).getChannel();
                abstractInterruptibleChannel = new FileOutputStream(this.to).getChannel();
                long l = this.from.length();
                ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
                int n2 = 0;
                int n3 = 0;
                while ((n = fileChannel.read(byteBuffer)) != -1) {
                    byteBuffer.flip();
                    ((FileChannel)abstractInterruptibleChannel).write(byteBuffer);
                    byteBuffer.clear();
                    n2 += n;
                    if (n3++ % 32 != 0) continue;
                    this.setProgress(n2, 0.0f, l);
                }
            }
            finally {
                try {
                    if (fileChannel != null) {
                        fileChannel.close();
                    }
                }
                catch (IOException iOException) {
                    LogUtils.processException(logger, iOException);
                }
                try {
                    if (abstractInterruptibleChannel != null) {
                        abstractInterruptibleChannel.close();
                    }
                }
                catch (IOException iOException) {
                    LogUtils.processException(logger, iOException);
                }
            }
            this.saveToHistoryList();
        }
        catch (Exception exception) {
            if (this.to.exists()) {
                this.to.delete();
            }
            this.deleteDescriptionFileOnError();
        }
        finally {
            if (this.deleteSource && this.from.exists()) {
                this.from.delete();
            }
        }
        return null;
    }

    private void deleteDescriptionFileOnError() {
        File file;
        String string = this.downloadFile.getDescription();
        if (string == null || string.isEmpty()) {
            return;
        }
        boolean bl = AppPrefs.getProperty("generateDescriptionByFileName", false);
        if (bl && (file = new File(this.to.getParentFile(), this.getNameForFile(Utils.getPureFilenameWithDots(this.to) + ".txt"))).exists()) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDescriptionFiles() {
        boolean bl;
        Object object;
        String string = this.downloadFile.getDescription();
        if (string == null || string.isEmpty()) {
            return;
        }
        boolean bl2 = AppPrefs.getProperty("generateDescript-ionFile", false);
        boolean bl3 = AppPrefs.getProperty("trimDescription", true);
        if (bl3) {
            string = string.trim();
        }
        if (bl2) {
            File file = new File(this.to.getParentFile(), this.getNameForFile("descript.ion"));
            object = null;
            try {
                object = new FileWriter(file, true);
                if (file.length() > 0L) {
                    ((Writer)object).write(Utils.getSystemLineSeparator());
                }
                ((Writer)object).write(this.to.getName() + " " + string.trim());
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
            }
            finally {
                if (object != null) {
                    if (this.generateFileAsHidden() && Utils.isWindows()) {
                        Utils.setFileAsHidden(file);
                    }
                    try {
                        ((OutputStreamWriter)object).close();
                    }
                    catch (IOException iOException) {
                        LogUtils.processException(logger, iOException);
                    }
                }
            }
        }
        if (bl = AppPrefs.getProperty("generateDescriptionByFileName", false)) {
            object = new File(this.to.getParentFile(), this.getNameForFile(Utils.getPureFilenameWithDots(this.to) + ".txt"));
            if (((File)object).exists() && ((File)object).isHidden() && !((File)object).delete()) {
                logger.warning("Deletion of file " + ((File)object).getAbsolutePath() + " failed");
            }
            if (((File)object).exists()) {
                object = new File(this.to.getParentFile(), this.getNameForFile(Utils.getPureFilenameWithDots(this.to) + "-description.txt"));
            }
            if (((File)object).exists()) {
                object = this.getNewUniqueFileName((File)object);
            }
            FileWriter fileWriter = null;
            try {
                fileWriter = new FileWriter((File)object, false);
                fileWriter.write(string);
            }
            catch (IOException iOException) {
                LogUtils.processException(logger, iOException);
            }
            finally {
                if (fileWriter != null) {
                    if (this.generateFileAsHidden() && Utils.isWindows()) {
                        Utils.setFileAsHidden((File)object);
                    }
                    try {
                        fileWriter.close();
                    }
                    catch (IOException iOException) {
                        LogUtils.processException(logger, iOException);
                    }
                }
            }
        }
    }

    private String getNameForFile(String string) {
        if (this.generateFileAsHidden() && !Utils.isWindows() && !string.startsWith(".")) {
            return "." + string;
        }
        return string;
    }

    private boolean generateFileAsHidden() {
        return AppPrefs.getProperty("descriptionFilesHidden", false);
    }

    private void saveToHistoryList() {
        this.downloadFile.setFileName(this.to.getName());
        ((MainApp)this.getApplication()).getManagerDirector().getFileHistoryManager().addHistoryItem(this.downloadFile, this.to);
    }

    @Override
    protected void failed(Throwable throwable) {
        super.failed(throwable);
    }

    private File getNewUniqueFileName(File file) {
        File file2;
        File file3 = file.getParentFile();
        String string = Utils.getPureFilenameWithDots(file);
        String string2 = Utils.getExtension(file);
        string2 = string2 != null ? "." + string2 : "";
        int n = 2;
        while ((file2 = new File(file3, string + "-" + String.valueOf(n) + string2)).exists()) {
            ++n;
        }
        return file2;
    }
}

