/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.core.tasks;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.tasks.ConnectResult;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.core.tasks.ScreenInputBlocker;
import cz.vity.freerapid.core.tasks.exceptions.NoAvailableConnection;
import cz.vity.freerapid.gui.managers.ClientManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.plugins.webclient.ConnectionSettings;
import cz.vity.freerapid.plugins.webclient.DownloadClient;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.Browser;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.xmlimport.XMLBind;
import cz.vity.freerapid.xmlimport.ver1.Plugin;
import cz.vity.freerapid.xmlimport.ver1.Plugins;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import org.apache.commons.httpclient.HttpMethod;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;

public class CheckPluginUpdateTask
extends CoreTask<List<Plugin>, Void> {
    private static final Logger logger = Logger.getLogger(CheckPluginUpdateTask.class.getName());
    private final ManagerDirector director;
    private final boolean quietMode;
    private static final String VERSION__PARAM = "version";
    private static final String PRODUCT_PARAM = "product";
    private static final String APIVERSION_PARAM = "apiversion";
    private static final String PARAM_LANGUAGE = "lang";
    private static final String PARAM_VERSION_ONLY = "versiononly";
    private static final String PARAM_COUNTRY = "country";
    private static int failed = 0;
    private String newVersionURL;
    private ConnectResult result;

    public CheckPluginUpdateTask(ManagerDirector managerDirector, ApplicationContext applicationContext, boolean bl) {
        super(applicationContext.getApplication());
        this.director = managerDirector;
        this.quietMode = bl;
        this.result = ConnectResult.SAME_VERSION;
        logger.info("Starting to check for a new plugins version");
        this.setTaskToForeground();
        if (!bl) {
            this.setInputBlocker(new ScreenInputBlocker(this, Task.BlockingScope.APPLICATION, Swinger.getActiveFrame(), null));
        } else {
            this.setInputBlocker(null);
        }
    }

    protected List<Plugin> doInBackground() throws Exception {
        Object object;
        Object object2;
        Object object3;
        ArrayList<Plugin> arrayList = new ArrayList<Plugin>();
        if (failed > 6) {
            return arrayList;
        }
        AppPrefs.storeProperty("pluginLastUpdateDateTime", System.currentTimeMillis());
        this.message("updatesPluginCheck", new Object[0]);
        ClientManager clientManager = this.director.getClientManager();
        List<ConnectionSettings> list = clientManager.getEnabledConnections();
        if (list.isEmpty()) {
            throw new NoAvailableConnection(this.getResourceMap().getString("noAvailableConnection", new Object[0]));
        }
        DownloadClient downloadClient = new DownloadClient();
        downloadClient.initClient(list.get(0));
        String string = AppPrefs.getProperty("pluginCheckUrlSelected", "http://wordrider.net/freerapid/pluginsCheck.php");
        if (string.toLowerCase().endsWith(".xml")) {
            object3 = downloadClient.getGetMethod(string);
        } else {
            object2 = downloadClient.getPostMethod(string);
            object2.addParameter(PRODUCT_PARAM, "FreeRapid");
            object2.addParameter(VERSION__PARAM, "0.85u1");
            object2.addParameter(APIVERSION_PARAM, "0.851");
            object2.addParameter(PARAM_VERSION_ONLY, "0.85u1");
            object = Locale.getDefault();
            object2.addParameter(PARAM_LANGUAGE, ((Locale)object).getLanguage());
            object2.addParameter(PARAM_COUNTRY, ((Locale)object).getCountry());
            object3 = object2;
        }
        this.message("message.connecting", new Object[0]);
        if (downloadClient.makeRequest((HttpMethod)object3, true) != 200) {
            throw new ConnectException(this.getResourceMap().getString("Connection_failed", new Object[0]));
        }
        this.message("message.checkingData", new Object[0]);
        if (this.isCancelled()) {
            throw new InterruptedException();
        }
        object2 = downloadClient.getContentAsString();
        if (object2 != null && ((String)object2).contains("thisisanupdate")) {
            object = ((String)object2).toLowerCase();
            if (((String)object).contains("required")) {
                int n = ((String)object).indexOf("http://");
                this.newVersionURL = n != -1 ? ((String)object2).substring(n).trim() : "http://wordrider.net/freerapid";
                this.result = ConnectResult.NEW_VERSION_REQUIRED;
            } else {
                this.result = ((String)object).contains("yes") ? ConnectResult.CONNECT_NEW_VERSION : ConnectResult.SAME_VERSION;
            }
        } else {
            this.result = ConnectResult.SAME_VERSION;
        }
        if (this.result == ConnectResult.SAME_VERSION) {
            object = new XMLBind().loadPluginList((String)object2);
            return ((Plugins)object).getPlugin();
        }
        return Collections.emptyList();
    }

    @Override
    protected void failed(Throwable throwable) {
        LogUtils.processException(logger, throwable);
        ++failed;
        if (this.quietMode) {
            AppPrefs.storeProperty("pluginLastUpdateDateTime", -1);
            return;
        }
        if (throwable instanceof UnknownHostException) {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_check_inet_settings", new Object[0]);
        } else {
            Swinger.showErrorMessage(this.getResourceMap(), "errormessage_submit_failed", throwable.getMessage());
        }
    }

    protected void succeeded(List<Plugin> list) {
        switch (this.result) {
            case NEW_VERSION_REQUIRED: {
                Swinger.showInformationDialog(this.getResourceMap().getString("message.connect.newVersionRequired", new Object[0]));
                Browser.openBrowser(this.newVersionURL);
                this.getApplication().exit();
                return;
            }
        }
        assert (false);
        for (Plugin plugin : list) {
            logger.info("plugin update from server: " + plugin.getId());
        }
    }
}

