/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.session;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.file.DefaultFileRegion;
import org.apache.mina.core.file.FilenameFileRegion;
import org.apache.mina.core.filterchain.IoFilterChain;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.DefaultCloseFuture;
import org.apache.mina.core.future.DefaultReadFuture;
import org.apache.mina.core.future.DefaultWriteFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.future.ReadFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.service.AbstractIoService;
import org.apache.mina.core.service.IoAcceptor;
import org.apache.mina.core.service.IoHandler;
import org.apache.mina.core.service.IoProcessor;
import org.apache.mina.core.service.IoService;
import org.apache.mina.core.service.TransportMetadata;
import org.apache.mina.core.session.AttributeKey;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.session.IoSessionAttributeMap;
import org.apache.mina.core.session.IoSessionConfig;
import org.apache.mina.core.write.DefaultWriteRequest;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.core.write.WriteRequestQueue;
import org.apache.mina.core.write.WriteTimeoutException;
import org.apache.mina.core.write.WriteToClosedSessionException;
import org.apache.mina.util.ExceptionMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractIoSession
implements IoSession {
    private final IoHandler handler;
    protected IoSessionConfig config;
    private final IoService service;
    private static final AttributeKey READY_READ_FUTURES_KEY = new AttributeKey(AbstractIoSession.class, "readyReadFutures");
    private static final AttributeKey WAITING_READ_FUTURES_KEY = new AttributeKey(AbstractIoSession.class, "waitingReadFutures");
    private static final IoFutureListener<CloseFuture> SCHEDULED_COUNTER_RESETTER = new IoFutureListener<CloseFuture>(){

        @Override
        public void operationComplete(CloseFuture closeFuture) {
            AbstractIoSession abstractIoSession = (AbstractIoSession)closeFuture.getSession();
            abstractIoSession.scheduledWriteBytes.set(0);
            abstractIoSession.scheduledWriteMessages.set(0);
            abstractIoSession.readBytesThroughput = 0.0;
            abstractIoSession.readMessagesThroughput = 0.0;
            abstractIoSession.writtenBytesThroughput = 0.0;
            abstractIoSession.writtenMessagesThroughput = 0.0;
        }
    };
    private static final WriteRequest CLOSE_REQUEST = new DefaultWriteRequest(new Object());
    private final Object lock = new Object();
    private IoSessionAttributeMap attributes;
    private WriteRequestQueue writeRequestQueue;
    private WriteRequest currentWriteRequest;
    private final long creationTime;
    private static AtomicLong idGenerator = new AtomicLong(0L);
    private long sessionId;
    private final CloseFuture closeFuture = new DefaultCloseFuture(this);
    private volatile boolean closing;
    private boolean readSuspended = false;
    private boolean writeSuspended = false;
    private final AtomicBoolean scheduledForFlush = new AtomicBoolean();
    private final AtomicInteger scheduledWriteBytes = new AtomicInteger();
    private final AtomicInteger scheduledWriteMessages = new AtomicInteger();
    private long readBytes;
    private long writtenBytes;
    private long readMessages;
    private long writtenMessages;
    private long lastReadTime;
    private long lastWriteTime;
    private long lastThroughputCalculationTime;
    private double readBytesThroughput;
    private double writtenBytesThroughput;
    private double readMessagesThroughput;
    private double writtenMessagesThroughput;
    private AtomicInteger idleCountForBoth = new AtomicInteger();
    private AtomicInteger idleCountForRead = new AtomicInteger();
    private AtomicInteger idleCountForWrite = new AtomicInteger();
    private long lastIdleTimeForBoth;
    private long lastIdleTimeForRead;
    private long lastIdleTimeForWrite;
    private boolean deferDecreaseReadBuffer = true;

    protected AbstractIoSession(IoService ioService) {
        long l;
        this.service = ioService;
        this.handler = ioService.getHandler();
        this.creationTime = l = System.currentTimeMillis();
        this.lastThroughputCalculationTime = l;
        this.lastReadTime = l;
        this.lastWriteTime = l;
        this.lastIdleTimeForBoth = l;
        this.lastIdleTimeForRead = l;
        this.lastIdleTimeForWrite = l;
        this.closeFuture.addListener(SCHEDULED_COUNTER_RESETTER);
        this.sessionId = idGenerator.incrementAndGet();
    }

    @Override
    public final long getId() {
        return this.sessionId;
    }

    public abstract IoProcessor getProcessor();

    @Override
    public final boolean isConnected() {
        return !this.closeFuture.isClosed();
    }

    @Override
    public final boolean isClosing() {
        return this.closing || this.closeFuture.isClosed();
    }

    public final CloseFuture getCloseFuture() {
        return this.closeFuture;
    }

    public final boolean isScheduledForFlush() {
        return this.scheduledForFlush.get();
    }

    public final void unscheduledForFlush() {
        this.scheduledForFlush.set(false);
    }

    public final boolean setScheduledForFlush(boolean bl) {
        if (bl) {
            return this.scheduledForFlush.compareAndSet(false, bl);
        }
        this.scheduledForFlush.set(bl);
        return true;
    }

    @Override
    public final CloseFuture close(boolean bl) {
        if (bl) {
            return this.close();
        }
        return this.closeOnFlush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CloseFuture close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isClosing()) {
                return this.closeFuture;
            }
            this.closing = true;
        }
        this.getFilterChain().fireFilterClose();
        return this.closeFuture;
    }

    private final CloseFuture closeOnFlush() {
        this.getWriteRequestQueue().offer(this, CLOSE_REQUEST);
        this.getProcessor().flush(this);
        return this.closeFuture;
    }

    @Override
    public IoHandler getHandler() {
        return this.handler;
    }

    @Override
    public IoSessionConfig getConfig() {
        throw new InternalError("Badly shrinked");
    }

    public final void offerReadFuture(Object object) {
        this.newReadFuture().setRead(object);
    }

    public final void offerFailedReadFuture(Throwable throwable) {
        this.newReadFuture().setException(throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void offerClosedReadFuture() {
        Queue<ReadFuture> queue;
        Queue<ReadFuture> queue2 = queue = this.getReadyReadFutures();
        synchronized (queue2) {
            this.newReadFuture().setClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReadFuture newReadFuture() {
        ReadFuture readFuture;
        Queue<ReadFuture> queue = this.getReadyReadFutures();
        Queue<ReadFuture> queue2 = this.getWaitingReadFutures();
        Queue<ReadFuture> queue3 = queue;
        synchronized (queue3) {
            readFuture = queue2.poll();
            if (readFuture == null) {
                readFuture = new DefaultReadFuture(this);
                queue.offer(readFuture);
            }
        }
        return readFuture;
    }

    private Queue<ReadFuture> getReadyReadFutures() {
        Queue queue;
        Queue queue2 = (ConcurrentLinkedQueue)this.getAttribute(READY_READ_FUTURES_KEY);
        if (queue2 == null && (queue = (Queue)this.setAttributeIfAbsent(READY_READ_FUTURES_KEY, queue2 = new ConcurrentLinkedQueue())) != null) {
            queue2 = queue;
        }
        return queue2;
    }

    private Queue<ReadFuture> getWaitingReadFutures() {
        Queue queue;
        Queue queue2 = (ConcurrentLinkedQueue)this.getAttribute(WAITING_READ_FUTURES_KEY);
        if (queue2 == null && (queue = (Queue)this.setAttributeIfAbsent(WAITING_READ_FUTURES_KEY, queue2 = new ConcurrentLinkedQueue())) != null) {
            queue2 = queue;
        }
        return queue2;
    }

    @Override
    public WriteFuture write(Object object) {
        return this.write(object, null);
    }

    public WriteFuture write(Object object, SocketAddress socketAddress) {
        Object object2;
        if (object == null) {
            throw new IllegalArgumentException("message");
        }
        if (!this.getTransportMetadata().isConnectionless() && socketAddress != null) {
            throw new UnsupportedOperationException();
        }
        if (this.isClosing() || !this.isConnected()) {
            DefaultWriteFuture defaultWriteFuture = new DefaultWriteFuture(this);
            DefaultWriteRequest defaultWriteRequest = new DefaultWriteRequest(object, defaultWriteFuture, socketAddress);
            WriteToClosedSessionException writeToClosedSessionException = new WriteToClosedSessionException(defaultWriteRequest);
            defaultWriteFuture.setException(writeToClosedSessionException);
            return defaultWriteFuture;
        }
        FileChannel fileChannel = null;
        try {
            if (object instanceof IoBuffer && !((IoBuffer)object).hasRemaining()) {
                throw new IllegalArgumentException("message is empty. Forgot to call flip()?");
            }
            if (object instanceof FileChannel) {
                object2 = (FileChannel)object;
                object = new DefaultFileRegion((FileChannel)object2, 0L, ((FileChannel)object2).size());
            } else if (object instanceof File) {
                object2 = (File)object;
                fileChannel = new FileInputStream((File)object2).getChannel();
                object = new FilenameFileRegion((File)object2, fileChannel, 0L, fileChannel.size());
            }
        }
        catch (IOException iOException) {
            ExceptionMonitor.getInstance().exceptionCaught(iOException);
            return DefaultWriteFuture.newNotWrittenFuture(this, iOException);
        }
        object2 = new DefaultWriteFuture(this);
        DefaultWriteRequest defaultWriteRequest = new DefaultWriteRequest(object, (WriteFuture)object2, socketAddress);
        IoFilterChain ioFilterChain = this.getFilterChain();
        ioFilterChain.fireFilterWrite(defaultWriteRequest);
        if (fileChannel != null) {
            final FileChannel fileChannel2 = fileChannel;
            object2.addListener(new IoFutureListener<WriteFuture>(){

                @Override
                public void operationComplete(WriteFuture writeFuture) {
                    try {
                        fileChannel2.close();
                    }
                    catch (IOException iOException) {
                        ExceptionMonitor.getInstance().exceptionCaught(iOException);
                    }
                }
            });
        }
        return object2;
    }

    @Override
    public final Object getAttribute(Object object) {
        return this.getAttribute(object, null);
    }

    public final Object getAttribute(Object object, Object object2) {
        return this.attributes.getAttribute(this, object, object2);
    }

    @Override
    public final Object setAttribute(Object object, Object object2) {
        return this.attributes.setAttribute(this, object, object2);
    }

    public final Object setAttributeIfAbsent(Object object, Object object2) {
        return this.attributes.setAttributeIfAbsent(this, object, object2);
    }

    @Override
    public final Object removeAttribute(Object object) {
        return this.attributes.removeAttribute(this, object);
    }

    public final IoSessionAttributeMap getAttributeMap() {
        return this.attributes;
    }

    public final void setAttributeMap(IoSessionAttributeMap ioSessionAttributeMap) {
        this.attributes = ioSessionAttributeMap;
    }

    public final void setWriteRequestQueue(WriteRequestQueue writeRequestQueue) {
        this.writeRequestQueue = new CloseAwareWriteQueue(writeRequestQueue);
    }

    public boolean isReadSuspended() {
        return this.readSuspended;
    }

    public boolean isWriteSuspended() {
        return this.writeSuspended;
    }

    @Override
    public final long getReadBytes() {
        return this.readBytes;
    }

    public final void increaseReadBytes(long l, long l2) {
        if (l <= 0L) {
            return;
        }
        this.readBytes += l;
        this.lastReadTime = l2;
        this.idleCountForBoth.set(0);
        this.idleCountForRead.set(0);
        if (this.getService() instanceof AbstractIoService) {
            ((AbstractIoService)this.getService()).getStatistics().increaseReadBytes(l, l2);
        }
    }

    public final void increaseReadMessages(long l) {
        ++this.readMessages;
        this.lastReadTime = l;
        this.idleCountForBoth.set(0);
        this.idleCountForRead.set(0);
        if (this.getService() instanceof AbstractIoService) {
            ((AbstractIoService)this.getService()).getStatistics().increaseReadMessages(l);
        }
    }

    public final void increaseWrittenBytes(int n, long l) {
        if (n <= 0) {
            return;
        }
        this.writtenBytes += (long)n;
        this.lastWriteTime = l;
        this.idleCountForBoth.set(0);
        this.idleCountForWrite.set(0);
        if (this.getService() instanceof AbstractIoService) {
            ((AbstractIoService)this.getService()).getStatistics().increaseWrittenBytes(n, l);
        }
        this.increaseScheduledWriteBytes(-n);
    }

    public final void increaseWrittenMessages(WriteRequest writeRequest, long l) {
        IoBuffer ioBuffer;
        Object object = writeRequest.getMessage();
        if (object instanceof IoBuffer && (ioBuffer = (IoBuffer)object).hasRemaining()) {
            return;
        }
        ++this.writtenMessages;
        this.lastWriteTime = l;
        if (this.getService() instanceof AbstractIoService) {
            ((AbstractIoService)this.getService()).getStatistics().increaseWrittenMessages(l);
        }
        this.decreaseScheduledWriteMessages();
    }

    public final void increaseScheduledWriteBytes(int n) {
        this.scheduledWriteBytes.addAndGet(n);
        if (this.getService() instanceof AbstractIoService) {
            ((AbstractIoService)this.getService()).getStatistics().increaseScheduledWriteBytes(n);
        }
    }

    public final void increaseScheduledWriteMessages() {
        this.scheduledWriteMessages.incrementAndGet();
        if (this.getService() instanceof AbstractIoService) {
            ((AbstractIoService)this.getService()).getStatistics().increaseScheduledWriteMessages();
        }
    }

    private void decreaseScheduledWriteMessages() {
        this.scheduledWriteMessages.decrementAndGet();
        if (this.getService() instanceof AbstractIoService) {
            ((AbstractIoService)this.getService()).getStatistics().decreaseScheduledWriteMessages();
        }
    }

    public final void decreaseScheduledBytesAndMessages(WriteRequest writeRequest) {
        Object object = writeRequest.getMessage();
        if (object instanceof IoBuffer) {
            IoBuffer ioBuffer = (IoBuffer)object;
            if (ioBuffer.hasRemaining()) {
                this.increaseScheduledWriteBytes(-((IoBuffer)object).remaining());
            } else {
                this.decreaseScheduledWriteMessages();
            }
        } else {
            this.decreaseScheduledWriteMessages();
        }
    }

    @Override
    public final WriteRequestQueue getWriteRequestQueue() {
        if (this.writeRequestQueue == null) {
            throw new IllegalStateException();
        }
        return this.writeRequestQueue;
    }

    @Override
    public final WriteRequest getCurrentWriteRequest() {
        return this.currentWriteRequest;
    }

    @Override
    public final void setCurrentWriteRequest(WriteRequest writeRequest) {
        this.currentWriteRequest = writeRequest;
    }

    public final void increaseReadBufferSize() {
        int n = this.getConfig().getReadBufferSize() << 1;
        if (n <= this.getConfig().getMaxReadBufferSize()) {
            this.getConfig().setReadBufferSize(n);
        } else {
            this.getConfig().setReadBufferSize(this.getConfig().getMaxReadBufferSize());
        }
        this.deferDecreaseReadBuffer = true;
    }

    public final void decreaseReadBufferSize() {
        if (this.deferDecreaseReadBuffer) {
            this.deferDecreaseReadBuffer = false;
            return;
        }
        if (this.getConfig().getReadBufferSize() > this.getConfig().getMinReadBufferSize()) {
            this.getConfig().setReadBufferSize(this.getConfig().getReadBufferSize() >>> 1);
        }
        this.deferDecreaseReadBuffer = true;
    }

    @Override
    public final long getLastIoTime() {
        return Math.max(this.lastReadTime, this.lastWriteTime);
    }

    @Override
    public final long getLastReadTime() {
        return this.lastReadTime;
    }

    @Override
    public final long getLastWriteTime() {
        return this.lastWriteTime;
    }

    @Override
    public final long getLastIdleTime(IdleStatus idleStatus) {
        if (idleStatus == IdleStatus.BOTH_IDLE) {
            return this.lastIdleTimeForBoth;
        }
        if (idleStatus == IdleStatus.READER_IDLE) {
            return this.lastIdleTimeForRead;
        }
        if (idleStatus == IdleStatus.WRITER_IDLE) {
            return this.lastIdleTimeForWrite;
        }
        throw new IllegalArgumentException("Unknown idle status: " + idleStatus);
    }

    public final void increaseIdleCount(IdleStatus idleStatus, long l) {
        if (idleStatus == IdleStatus.BOTH_IDLE) {
            this.idleCountForBoth.incrementAndGet();
            this.lastIdleTimeForBoth = l;
        } else if (idleStatus == IdleStatus.READER_IDLE) {
            this.idleCountForRead.incrementAndGet();
            this.lastIdleTimeForRead = l;
        } else if (idleStatus == IdleStatus.WRITER_IDLE) {
            this.idleCountForWrite.incrementAndGet();
            this.lastIdleTimeForWrite = l;
        } else {
            throw new IllegalArgumentException("Unknown idle status: " + idleStatus);
        }
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object object) {
        return super.equals(object);
    }

    public String toString() {
        if (this.isConnected() || this.isClosing()) {
            try {
                SocketAddress socketAddress = this.getRemoteAddress();
                SocketAddress socketAddress2 = this.getLocalAddress();
                if (this.getService() instanceof IoAcceptor) {
                    return "(" + this.getIdAsString() + ": " + this.getServiceName() + ", server, " + socketAddress + " => " + socketAddress2 + ')';
                }
                return "(" + this.getIdAsString() + ": " + this.getServiceName() + ", client, " + socketAddress2 + " => " + socketAddress + ')';
            }
            catch (Exception exception) {
                return "Session is disconnecting ...";
            }
        }
        return "Session disconnected ...";
    }

    private String getIdAsString() {
        String string = Long.toHexString(this.getId()).toUpperCase();
        while (string.length() < 8) {
            string = '0' + string;
        }
        string = "0x" + string;
        return string;
    }

    private String getServiceName() {
        TransportMetadata transportMetadata = this.getTransportMetadata();
        if (transportMetadata == null) {
            return "null";
        }
        return transportMetadata.getProviderName() + ' ' + transportMetadata.getName();
    }

    @Override
    public IoService getService() {
        return this.service;
    }

    public static void notifyIdleness(Iterator<? extends IoSession> iterator, long l) {
        IoSession ioSession = null;
        while (iterator.hasNext()) {
            ioSession = iterator.next();
            AbstractIoSession.notifyIdleSession(ioSession, l);
        }
    }

    public static void notifyIdleSession(IoSession ioSession, long l) {
        AbstractIoSession.notifyIdleSession0(ioSession, l, ioSession.getConfig().getIdleTimeInMillis(IdleStatus.BOTH_IDLE), IdleStatus.BOTH_IDLE, Math.max(ioSession.getLastIoTime(), ioSession.getLastIdleTime(IdleStatus.BOTH_IDLE)));
        AbstractIoSession.notifyIdleSession0(ioSession, l, ioSession.getConfig().getIdleTimeInMillis(IdleStatus.READER_IDLE), IdleStatus.READER_IDLE, Math.max(ioSession.getLastReadTime(), ioSession.getLastIdleTime(IdleStatus.READER_IDLE)));
        AbstractIoSession.notifyIdleSession0(ioSession, l, ioSession.getConfig().getIdleTimeInMillis(IdleStatus.WRITER_IDLE), IdleStatus.WRITER_IDLE, Math.max(ioSession.getLastWriteTime(), ioSession.getLastIdleTime(IdleStatus.WRITER_IDLE)));
        AbstractIoSession.notifyWriteTimeout(ioSession, l);
    }

    private static void notifyIdleSession0(IoSession ioSession, long l, long l2, IdleStatus idleStatus, long l3) {
        if (l2 > 0L && l3 != 0L && l - l3 >= l2) {
            ioSession.getFilterChain().fireSessionIdle(idleStatus);
        }
    }

    private static void notifyWriteTimeout(IoSession ioSession, long l) {
        WriteRequest writeRequest;
        long l2 = ioSession.getConfig().getWriteTimeoutInMillis();
        if (l2 > 0L && l - ioSession.getLastWriteTime() >= l2 && !ioSession.getWriteRequestQueue().isEmpty(ioSession) && (writeRequest = ioSession.getCurrentWriteRequest()) != null) {
            ioSession.setCurrentWriteRequest(null);
            WriteTimeoutException writeTimeoutException = new WriteTimeoutException(writeRequest);
            writeRequest.getFuture().setException(writeTimeoutException);
            ioSession.getFilterChain().fireExceptionCaught(writeTimeoutException);
            ioSession.close(true);
        }
    }

    private class CloseAwareWriteQueue
    implements WriteRequestQueue {
        private final WriteRequestQueue queue;

        public CloseAwareWriteQueue(WriteRequestQueue writeRequestQueue) {
            this.queue = writeRequestQueue;
        }

        public synchronized WriteRequest poll(IoSession ioSession) {
            WriteRequest writeRequest = this.queue.poll(ioSession);
            if (writeRequest == CLOSE_REQUEST) {
                AbstractIoSession.this.close();
                this.dispose(ioSession);
                writeRequest = null;
            }
            return writeRequest;
        }

        public void offer(IoSession ioSession, WriteRequest writeRequest) {
            this.queue.offer(ioSession, writeRequest);
        }

        public boolean isEmpty(IoSession ioSession) {
            return this.queue.isEmpty(ioSession);
        }

        public void dispose(IoSession ioSession) {
            this.queue.dispose(ioSession);
        }
    }
}

