/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.core.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.buffer.IoBufferAllocator;
import org.apache.mina.core.buffer.IoBufferHexDumper;

public abstract class AbstractIoBuffer
extends IoBuffer {
    private final boolean derived;
    private boolean autoExpand;
    private boolean autoShrink;
    private boolean recapacityAllowed = true;
    private int minimumCapacity;
    private int mark = -1;

    protected AbstractIoBuffer(IoBufferAllocator ioBufferAllocator, int n) {
        AbstractIoBuffer.setAllocator(ioBufferAllocator);
        this.recapacityAllowed = true;
        this.derived = false;
        this.minimumCapacity = n;
    }

    public final boolean isDirect() {
        return this.buf().isDirect();
    }

    protected abstract void buf(ByteBuffer var1);

    public final int capacity() {
        return this.buf().capacity();
    }

    public final IoBuffer capacity(int n) {
        if (!this.recapacityAllowed) {
            throw new IllegalStateException("Derived buffers and their parent can't be expanded.");
        }
        if (n > this.capacity()) {
            int n2 = this.position();
            int n3 = this.limit();
            ByteOrder byteOrder = this.order();
            ByteBuffer byteBuffer = this.buf();
            ByteBuffer byteBuffer2 = AbstractIoBuffer.getAllocator().allocateNioBuffer(n, this.isDirect());
            byteBuffer.clear();
            byteBuffer2.put(byteBuffer);
            this.buf(byteBuffer2);
            this.buf().limit(n3);
            if (this.mark >= 0) {
                this.buf().position(this.mark);
                this.buf().mark();
            }
            this.buf().position(n2);
            this.buf().order(byteOrder);
        }
        return this;
    }

    public final boolean isAutoExpand() {
        return this.autoExpand && this.recapacityAllowed;
    }

    public final boolean isAutoShrink() {
        return this.autoShrink && this.recapacityAllowed;
    }

    public final IoBuffer setAutoExpand(boolean bl) {
        if (!this.recapacityAllowed) {
            throw new IllegalStateException("Derived buffers and their parent can't be expanded.");
        }
        this.autoExpand = bl;
        return this;
    }

    private IoBuffer expand(int n, boolean bl) {
        return this.expand(this.position(), n, bl);
    }

    private IoBuffer expand(int n, int n2, boolean bl) {
        if (!this.recapacityAllowed) {
            throw new IllegalStateException("Derived buffers and their parent can't be expanded.");
        }
        int n3 = n + n2;
        int n4 = bl ? IoBuffer.normalizeCapacity(n3) : n3;
        if (n4 > this.capacity()) {
            this.capacity(n4);
        }
        if (n3 > this.limit()) {
            this.buf().limit(n3);
        }
        return this;
    }

    public final int position() {
        return this.buf().position();
    }

    public final IoBuffer position(int n) {
        this.autoExpand(n, 0);
        this.buf().position(n);
        if (this.mark > n) {
            this.mark = -1;
        }
        return this;
    }

    public final int limit() {
        return this.buf().limit();
    }

    public final IoBuffer limit(int n) {
        this.autoExpand(n, 0);
        this.buf().limit(n);
        if (this.mark > n) {
            this.mark = -1;
        }
        return this;
    }

    public final IoBuffer mark() {
        this.buf().mark();
        this.mark = this.position();
        return this;
    }

    public final IoBuffer reset() {
        this.buf().reset();
        return this;
    }

    public final IoBuffer clear() {
        this.buf().clear();
        this.mark = -1;
        return this;
    }

    public final IoBuffer flip() {
        this.buf().flip();
        this.mark = -1;
        return this;
    }

    public final IoBuffer rewind() {
        this.buf().rewind();
        this.mark = -1;
        return this;
    }

    public final int remaining() {
        return this.limit() - this.position();
    }

    public final boolean hasRemaining() {
        return this.limit() > this.position();
    }

    public final byte get() {
        return this.buf().get();
    }

    public final IoBuffer put(byte by) {
        this.autoExpand(1);
        this.buf().put(by);
        return this;
    }

    public final byte get(int n) {
        return this.buf().get(n);
    }

    public final IoBuffer get(byte[] byArray, int n, int n2) {
        this.buf().get(byArray, n, n2);
        return this;
    }

    public final IoBuffer put(ByteBuffer byteBuffer) {
        this.autoExpand(byteBuffer.remaining());
        this.buf().put(byteBuffer);
        return this;
    }

    public final IoBuffer put(byte[] byArray, int n, int n2) {
        this.autoExpand(n2);
        this.buf().put(byArray, n, n2);
        return this;
    }

    public final IoBuffer compact() {
        int n = this.remaining();
        int n2 = this.capacity();
        if (n2 == 0) {
            return this;
        }
        if (this.isAutoShrink() && n <= n2 >>> 2 && n2 > this.minimumCapacity) {
            int n3 = n2;
            int n4 = Math.max(this.minimumCapacity, n << 1);
            while (n3 >>> 1 >= n4) {
                n3 >>>= 1;
            }
            n3 = Math.max(n4, n3);
            if (n3 == n2) {
                return this;
            }
            ByteOrder byteOrder = this.order();
            if (n > n3) {
                throw new IllegalStateException("The amount of the remaining bytes is greater than the new capacity.");
            }
            ByteBuffer byteBuffer = this.buf();
            ByteBuffer byteBuffer2 = AbstractIoBuffer.getAllocator().allocateNioBuffer(n3, this.isDirect());
            byteBuffer2.put(byteBuffer);
            this.buf(byteBuffer2);
            this.buf().order(byteOrder);
        } else {
            this.buf().compact();
        }
        this.mark = -1;
        return this;
    }

    public final ByteOrder order() {
        return this.buf().order();
    }

    public final IoBuffer order(ByteOrder byteOrder) {
        this.buf().order(byteOrder);
        return this;
    }

    public final short getShort() {
        return this.buf().getShort();
    }

    public final IoBuffer putShort(short s) {
        this.autoExpand(2);
        this.buf().putShort(s);
        return this;
    }

    public final int getInt() {
        return this.buf().getInt();
    }

    public final IoBuffer putInt(int n) {
        this.autoExpand(4);
        this.buf().putInt(n);
        return this;
    }

    public final double getDouble() {
        return this.buf().getDouble();
    }

    public final IoBuffer putDouble(double d) {
        this.autoExpand(8);
        this.buf().putDouble(d);
        return this;
    }

    public int hashCode() {
        int n = 1;
        int n2 = this.position();
        for (int i = this.limit() - 1; i >= n2; --i) {
            n = 31 * n + this.get(i);
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof IoBuffer)) {
            return false;
        }
        IoBuffer ioBuffer = (IoBuffer)object;
        if (this.remaining() != ioBuffer.remaining()) {
            return false;
        }
        int n = this.position();
        int n2 = this.limit() - 1;
        int n3 = ioBuffer.limit() - 1;
        while (n2 >= n) {
            byte by;
            byte by2 = this.get(n2);
            if (by2 != (by = ioBuffer.get(n3))) {
                return false;
            }
            --n2;
            --n3;
        }
        return true;
    }

    public int compareTo(IoBuffer ioBuffer) {
        int n = this.position() + Math.min(this.remaining(), ioBuffer.remaining());
        int n2 = this.position();
        int n3 = ioBuffer.position();
        while (n2 < n) {
            byte by;
            byte by2 = this.get(n2);
            if (by2 != (by = ioBuffer.get(n3))) {
                if (by2 < by) {
                    return -1;
                }
                return 1;
            }
            ++n2;
            ++n3;
        }
        return this.remaining() - ioBuffer.remaining();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isDirect()) {
            stringBuilder.append("DirectBuffer");
        } else {
            stringBuilder.append("HeapBuffer");
        }
        stringBuilder.append("[pos=");
        stringBuilder.append(this.position());
        stringBuilder.append(" lim=");
        stringBuilder.append(this.limit());
        stringBuilder.append(" cap=");
        stringBuilder.append(this.capacity());
        stringBuilder.append(": ");
        stringBuilder.append(this.getHexDump(16));
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public IoBuffer get(byte[] byArray) {
        return this.get(byArray, 0, byArray.length);
    }

    public IoBuffer put(IoBuffer ioBuffer) {
        return this.put(ioBuffer.buf());
    }

    public IoBuffer put(byte[] byArray) {
        return this.put(byArray, 0, byArray.length);
    }

    public String getHexDump() {
        return this.getHexDump(Integer.MAX_VALUE);
    }

    public String getHexDump(int n) {
        return IoBufferHexDumper.getHexdump(this, n);
    }

    public String getString(CharsetDecoder charsetDecoder) throws CharacterCodingException {
        CoderResult coderResult;
        int n;
        int n2;
        if (!this.hasRemaining()) {
            return "";
        }
        boolean bl = charsetDecoder.charset().name().startsWith("UTF-16");
        int n3 = this.position();
        int n4 = this.limit();
        int n5 = -1;
        if (!bl) {
            n5 = this.indexOf((byte)0);
            n2 = n5 < 0 ? (n5 = n4) : n5 + 1;
        } else {
            block8: {
                n = n3;
                while (true) {
                    boolean bl2;
                    boolean bl3 = bl2 = this.get(n) == 0;
                    if (++n >= n4) break block8;
                    if (this.get(n) != 0) {
                        if (++n < n4) continue;
                        break block8;
                    }
                    if (bl2) break;
                }
                n5 = n - 1;
            }
            n2 = n5 < 0 ? (n5 = n3 + (n4 - n3 & 0xFFFFFFFE)) : (n5 + 2 <= n4 ? n5 + 2 : n5);
        }
        if (n3 == n5) {
            this.position(n2);
            return "";
        }
        this.limit(n5);
        charsetDecoder.reset();
        n = (int)((float)this.remaining() * charsetDecoder.averageCharsPerByte()) + 1;
        CharBuffer charBuffer = CharBuffer.allocate(n);
        while (!(coderResult = this.hasRemaining() ? charsetDecoder.decode(this.buf(), charBuffer, true) : charsetDecoder.flush(charBuffer)).isUnderflow()) {
            if (coderResult.isOverflow()) {
                CharBuffer charBuffer2 = CharBuffer.allocate(charBuffer.capacity() + n);
                charBuffer.flip();
                charBuffer2.put(charBuffer);
                charBuffer = charBuffer2;
                continue;
            }
            if (!coderResult.isError()) continue;
            this.limit(n4);
            this.position(n3);
            coderResult.throwException();
        }
        this.limit(n4);
        this.position(n2);
        return charBuffer.flip().toString();
    }

    public int indexOf(byte by) {
        if (this.hasArray()) {
            int n = this.arrayOffset();
            int n2 = n + this.position();
            int n3 = n + this.limit();
            byte[] byArray = this.array();
            for (int i = n2; i < n3; ++i) {
                if (byArray[i] != by) continue;
                return i - n;
            }
        } else {
            int n = this.position();
            int n4 = this.limit();
            for (int i = n; i < n4; ++i) {
                if (this.get(i) != by) continue;
                return i;
            }
        }
        return -1;
    }

    private IoBuffer autoExpand(int n) {
        if (this.isAutoExpand()) {
            this.expand(n, true);
        }
        return this;
    }

    private IoBuffer autoExpand(int n, int n2) {
        if (this.isAutoExpand()) {
            this.expand(n, n2, true);
        }
        return this;
    }
}

