/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.ui;

import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicPasswordFieldUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.pushingpixels.lafwidget.LafWidget;
import org.pushingpixels.lafwidget.LafWidgetRepository;
import org.pushingpixels.lafwidget.utils.RenderingUtils;
import org.pushingpixels.substance.api.ComponentState;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;
import org.pushingpixels.substance.internal.animation.TransitionAwareUI;
import org.pushingpixels.substance.internal.utils.RolloverTextControlListener;
import org.pushingpixels.substance.internal.utils.SubstanceColorSchemeUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.SubstanceTextUtilities;
import org.pushingpixels.substance.internal.utils.border.SubstanceTextComponentBorder;

public class SubstancePasswordFieldUI
extends BasicPasswordFieldUI
implements TransitionAwareUI {
    protected Set lafWidgets;
    protected StateTransitionTracker stateTransitionTracker;
    protected JPasswordField passwordField;
    protected PropertyChangeListener substancePropertyChangeListener;
    private RolloverTextControlListener substanceRolloverListener;
    private ButtonModel transitionModel;

    public void __org__pushingpixels__substance__internal__ui__SubstancePasswordFieldUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstancePasswordFieldUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void __org__pushingpixels__substance__internal__ui__SubstancePasswordFieldUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.__org__pushingpixels__substance__internal__ui__SubstancePasswordFieldUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    @Override
    protected void installListeners() {
        this.__org__pushingpixels__substance__internal__ui__SubstancePasswordFieldUI__installListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    @Override
    protected void installDefaults() {
        this.__org__pushingpixels__substance__internal__ui__SubstancePasswordFieldUI__installDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    @Override
    protected void uninstallListeners() {
        this.__org__pushingpixels__substance__internal__ui__SubstancePasswordFieldUI__uninstallListeners();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstancePasswordFieldUI__uninstallDefaults() {
        super.uninstallDefaults();
    }

    @Override
    protected void uninstallDefaults() {
        this.__org__pushingpixels__substance__internal__ui__SubstancePasswordFieldUI__uninstallDefaults();
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__pushingpixels__substance__internal__ui__SubstancePasswordFieldUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        RenderingUtils.installDesktopHints(graphics2D, jComponent);
        this.__org__pushingpixels__substance__internal__ui__SubstancePasswordFieldUI__update(graphics2D, jComponent);
        graphics2D.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        SubstanceCoreUtilities.testComponentCreationThreadingViolation(jComponent);
        return new SubstancePasswordFieldUI(jComponent);
    }

    public SubstancePasswordFieldUI(JComponent jComponent) {
        this.passwordField = (JPasswordField)jComponent;
        this.transitionModel = new DefaultButtonModel();
        this.transitionModel.setArmed(false);
        this.transitionModel.setSelected(false);
        this.transitionModel.setPressed(false);
        this.transitionModel.setRollover(false);
        this.transitionModel.setEnabled(this.passwordField.isEnabled());
        this.stateTransitionTracker = new StateTransitionTracker(this.passwordField, this.transitionModel);
    }

    @Override
    public View create(Element element) {
        return new SubstancePasswordView(this.passwordField, element);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstancePasswordFieldUI__installListeners() {
        super.installListeners();
        this.substanceRolloverListener = new RolloverTextControlListener(this.passwordField, this, this.transitionModel);
        this.substanceRolloverListener.registerListeners();
        this.stateTransitionTracker.registerModelListeners();
        this.stateTransitionTracker.registerFocusListeners();
        this.substancePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("font".equals(propertyChangeEvent.getPropertyName())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int n = SubstancePasswordFieldUI.this.passwordField.getCaretPosition();
                            SubstancePasswordFieldUI.this.passwordField.updateUI();
                            SubstancePasswordFieldUI.this.passwordField.setCaretPosition(n);
                            Container container = SubstancePasswordFieldUI.this.passwordField.getParent();
                            if (container != null) {
                                container.invalidate();
                                container.validate();
                            }
                        }
                    });
                }
                if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                    SubstancePasswordFieldUI.this.transitionModel.setEnabled(SubstancePasswordFieldUI.this.passwordField.isEnabled());
                }
            }
        };
        this.passwordField.addPropertyChangeListener(this.substancePropertyChangeListener);
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstancePasswordFieldUI__uninstallListeners() {
        this.stateTransitionTracker.unregisterModelListeners();
        this.stateTransitionTracker.unregisterFocusListeners();
        this.passwordField.removePropertyChangeListener(this.substancePropertyChangeListener);
        this.substancePropertyChangeListener = null;
        this.passwordField.removeMouseListener(this.substanceRolloverListener);
        this.passwordField.removeMouseMotionListener(this.substanceRolloverListener);
        this.substanceRolloverListener = null;
        super.uninstallListeners();
    }

    protected void __org__pushingpixels__substance__internal__ui__SubstancePasswordFieldUI__installDefaults() {
        super.installDefaults();
        Border border = this.passwordField.getBorder();
        if (border == null || border instanceof UIResource) {
            BorderUIResource.CompoundBorderUIResource compoundBorderUIResource = new BorderUIResource.CompoundBorderUIResource(new SubstanceTextComponentBorder(SubstanceSizeUtils.getTextBorderInsets(SubstanceSizeUtils.getComponentFontSize(this.passwordField))), new BasicBorders.MarginBorder());
            this.passwordField.setBorder(compoundBorderUIResource);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (SubstancePasswordFieldUI.this.passwordField == null) {
                    return;
                }
                Color color = SubstancePasswordFieldUI.this.passwordField.getForeground();
                if (color == null || color instanceof UIResource) {
                    SubstancePasswordFieldUI.this.passwordField.setForeground(SubstanceColorUtilities.getForegroundColor(SubstanceLookAndFeel.getCurrentSkin(SubstancePasswordFieldUI.this.passwordField).getEnabledColorScheme(SubstanceLookAndFeel.getDecorationType(SubstancePasswordFieldUI.this.passwordField))));
                }
            }
        });
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        SubstanceTextUtilities.paintTextCompBackground(graphics, this.passwordField);
    }

    @Override
    public boolean isInside(MouseEvent mouseEvent) {
        if (!SubstanceLookAndFeel.isCurrentLookAndFeel()) {
            return false;
        }
        GeneralPath generalPath = SubstanceOutlineUtilities.getBaseOutline(this.passwordField, 2.0f * SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(this.passwordField)), null);
        return generalPath.contains(mouseEvent.getPoint());
    }

    @Override
    public StateTransitionTracker getTransitionTracker() {
        return this.stateTransitionTracker;
    }

    private static class SubstancePasswordView
    extends FieldView {
        private JPasswordField field;

        public SubstancePasswordView(JPasswordField jPasswordField, Element element) {
            super(element);
            this.field = jPasswordField;
        }

        protected int drawEchoCharacter(Graphics graphics, int n, int n2, char c, boolean bl) {
            Container container = this.getContainer();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            JPasswordField jPasswordField = (JPasswordField)container;
            int n3 = SubstanceSizeUtils.getComponentFontSize(this.field);
            int n4 = SubstanceSizeUtils.getPasswordDotDiameter(n3);
            int n5 = SubstanceSizeUtils.getPasswordDotGap(n3);
            ComponentState componentState = jPasswordField.isEnabled() ? ComponentState.ENABLED : ComponentState.DISABLED_UNSELECTED;
            SubstanceColorScheme substanceColorScheme = SubstanceColorSchemeUtilities.getColorScheme(jPasswordField, componentState);
            Color color = bl ? substanceColorScheme.getSelectionForegroundColor() : SubstanceColorUtilities.getForegroundColor(substanceColorScheme);
            Color color2 = color.brighter();
            graphics2D.setPaint(new GradientPaint(n, n2 - n4, color, n, n2, color2));
            int n6 = SubstanceCoreUtilities.getEchoPerChar(jPasswordField);
            for (int i = 0; i < n6; ++i) {
                graphics2D.fillOval(n + n5 / 2, n2 - n4, n4, n4);
                n += n4 + n5;
            }
            return n;
        }

        protected int getEchoCharAdvance() {
            int n = SubstanceSizeUtils.getComponentFontSize(this.field);
            int n2 = SubstanceSizeUtils.getPasswordDotDiameter(n);
            int n3 = SubstanceSizeUtils.getPasswordDotGap(n);
            int n4 = SubstanceCoreUtilities.getEchoPerChar(this.field);
            return n4 * (n2 + n3);
        }

        @Override
        protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            Container container = this.getContainer();
            if (container instanceof JPasswordField) {
                JPasswordField jPasswordField = (JPasswordField)container;
                if (!jPasswordField.echoCharIsSet()) {
                    return super.drawSelectedText(graphics, n, n2, n3, n4);
                }
                int n5 = n4 - n3;
                char c = jPasswordField.getEchoChar();
                int n6 = n;
                for (int i = 0; i < n5; ++i) {
                    n6 = this.drawEchoCharacter(graphics, n6, n2, c, true);
                }
                return n + n5 * this.getEchoCharAdvance();
            }
            return n;
        }

        @Override
        protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
            Container container = this.getContainer();
            if (container instanceof JPasswordField) {
                JPasswordField jPasswordField = (JPasswordField)container;
                if (!jPasswordField.echoCharIsSet()) {
                    return super.drawUnselectedText(graphics, n, n2, n3, n4);
                }
                int n5 = n4 - n3;
                char c = jPasswordField.getEchoChar();
                int n6 = n;
                for (int i = 0; i < n5; ++i) {
                    n6 = this.drawEchoCharacter(graphics, n6, n2, c, false);
                }
                return n + n5 * this.getEchoCharAdvance();
            }
            return n;
        }

        @Override
        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            Container container = this.getContainer();
            if (container instanceof JPasswordField) {
                JPasswordField jPasswordField = (JPasswordField)container;
                if (!jPasswordField.echoCharIsSet()) {
                    return super.modelToView(n, shape, bias);
                }
                Rectangle rectangle = this.adjustAllocation(shape).getBounds();
                int n2 = SubstanceCoreUtilities.getEchoPerChar(jPasswordField);
                int n3 = SubstanceSizeUtils.getComponentFontSize(this.field);
                int n4 = SubstanceSizeUtils.getPasswordDotDiameter(n3) + SubstanceSizeUtils.getPasswordDotGap(n3);
                int n5 = (n - this.getStartOffset()) * n2 * n4;
                rectangle.x += n5;
                rectangle.width = 1;
                return rectangle;
            }
            return null;
        }

        @Override
        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            biasArray[0] = Position.Bias.Forward;
            int n = 0;
            Container container = this.getContainer();
            if (container instanceof JPasswordField) {
                int n2;
                int n3;
                JPasswordField jPasswordField = (JPasswordField)container;
                if (!jPasswordField.echoCharIsSet()) {
                    return super.viewToModel(f, f2, shape, biasArray);
                }
                Rectangle rectangle = (shape = this.adjustAllocation(shape)) instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
                int n4 = SubstanceCoreUtilities.getEchoPerChar(jPasswordField);
                n = ((int)f - rectangle.x) / (n4 * (n3 = SubstanceSizeUtils.getPasswordDotDiameter(n2 = SubstanceSizeUtils.getComponentFontSize(this.field)) + SubstanceSizeUtils.getPasswordDotGap(n2)));
                if (n < 0) {
                    n = 0;
                } else if (n > this.getStartOffset() + this.getDocument().getLength()) {
                    n = this.getDocument().getLength() - this.getStartOffset();
                }
            }
            return this.getStartOffset() + n;
        }

        @Override
        public float getPreferredSpan(int n) {
            switch (n) {
                case 0: {
                    JPasswordField jPasswordField;
                    Container container = this.getContainer();
                    if (!(container instanceof JPasswordField) || !(jPasswordField = (JPasswordField)container).echoCharIsSet()) break;
                    int n2 = SubstanceCoreUtilities.getEchoPerChar(jPasswordField);
                    int n3 = SubstanceSizeUtils.getComponentFontSize(this.field);
                    int n4 = SubstanceSizeUtils.getPasswordDotDiameter(n3) + SubstanceSizeUtils.getPasswordDotGap(n3);
                    return n2 * n4 * this.getDocument().getLength();
                }
            }
            return super.getPreferredSpan(n);
        }
    }
}

