/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.internal.animation;

import java.util.HashMap;
import java.util.Map;
import org.pushingpixels.substance.internal.animation.StateTransitionEvent;
import org.pushingpixels.substance.internal.animation.StateTransitionListener;
import org.pushingpixels.substance.internal.animation.StateTransitionTracker;

public final class StateTransitionMultiTracker<T> {
    private Map<Comparable<T>, StateTransitionTracker> trackerMap = new HashMap<Comparable<T>, StateTransitionTracker>();
    private boolean isInCleaning;

    public synchronized void clear() {
        this.isInCleaning = true;
        for (StateTransitionTracker stateTransitionTracker : this.trackerMap.values()) {
            stateTransitionTracker.endTransition();
        }
        this.trackerMap.clear();
        this.isInCleaning = false;
    }

    public synchronized int size() {
        return this.trackerMap.size();
    }

    public synchronized StateTransitionTracker getTracker(Comparable<T> comparable) {
        return this.trackerMap.get(comparable);
    }

    public synchronized void addTracker(final Comparable<T> comparable, final StateTransitionTracker stateTransitionTracker) {
        this.trackerMap.put(comparable, stateTransitionTracker);
        StateTransitionListener stateTransitionListener = new StateTransitionListener(){

            @Override
            public void onModelStateTransition(StateTransitionEvent stateTransitionEvent) {
                if (StateTransitionMultiTracker.this.isInCleaning) {
                    return;
                }
                if (!stateTransitionTracker.hasRunningTimelines()) {
                    StateTransitionMultiTracker.this.trackerMap.remove(comparable);
                    stateTransitionTracker.unregisterModelListeners();
                    stateTransitionTracker.removeStateTransitionListener(this);
                }
            }

            @Override
            public void onFocusStateTransition(StateTransitionEvent stateTransitionEvent) {
                if (StateTransitionMultiTracker.this.isInCleaning) {
                    return;
                }
                if (!stateTransitionTracker.hasRunningTimelines()) {
                    StateTransitionMultiTracker.this.trackerMap.remove(comparable);
                    stateTransitionTracker.unregisterModelListeners();
                    stateTransitionTracker.removeStateTransitionListener(this);
                }
            }
        };
        stateTransitionTracker.addStateTransitionListener(stateTransitionListener);
    }
}

