/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.watermark;

import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.SubstanceLookAndFeel;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.watermark.SubstanceWatermark;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;

public class SubstanceImageWatermark
implements SubstanceWatermark {
    protected Image watermarkImage = null;
    private SubstanceConstants.ImageWatermarkKind kind = SubstanceConstants.ImageWatermarkKind.SCREEN_CENTER_SCALE;
    private float opacity = 0.2f;
    protected BufferedImage origImage;
    protected String origImageLocation;

    public SubstanceImageWatermark(String string) {
        if (string != null) {
            try {
                if (string.startsWith("http")) {
                    URL uRL = new URL(string);
                    BufferedImage bufferedImage = ImageIO.read(uRL);
                    this.origImage = SubstanceCoreUtilities.createCompatibleImage(bufferedImage);
                } else {
                    try {
                        this.origImage = SubstanceCoreUtilities.createCompatibleImage(ImageIO.read(new File(string)));
                    }
                    catch (IIOException iIOException) {
                        this.origImage = SubstanceCoreUtilities.createCompatibleImage(ImageIO.read(SubstanceImageWatermark.class.getClassLoader().getResource(string)));
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.origImageLocation = string;
    }

    public SubstanceImageWatermark(InputStream inputStream) {
        if (inputStream != null) {
            try {
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                this.origImage = SubstanceCoreUtilities.createCompatibleImage(bufferedImage);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.origImageLocation = null;
    }

    @Override
    public void drawWatermarkImage(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        if (!component.isShowing()) {
            return;
        }
        int n5 = 0;
        int n6 = 0;
        Component component2 = null;
        switch (this.getKind()) {
            case SCREEN_CENTER_SCALE: 
            case SCREEN_TILE: {
                n5 = component.getLocationOnScreen().x;
                n6 = component.getLocationOnScreen().y;
                break;
            }
            case APP_ANCHOR: 
            case APP_TILE: {
                if (component instanceof JComponent) {
                    component2 = ((JComponent)component).getTopLevelAncestor();
                } else {
                    Component component3 = component;
                    while (component3.getParent() != null) {
                        component3 = component3.getParent();
                    }
                    component2 = component3;
                }
                n5 = component.getLocationOnScreen().x - component2.getLocationOnScreen().x;
                n6 = component.getLocationOnScreen().y - component2.getLocationOnScreen().y;
                break;
            }
            case APP_CENTER: {
                if (component instanceof JComponent) {
                    component2 = ((JComponent)component).getTopLevelAncestor();
                } else {
                    Component component4 = component;
                    while (component4.getParent() != null) {
                        component4 = component4.getParent();
                    }
                    component2 = component4;
                }
                n5 = component.getLocationOnScreen().x - component2.getLocationOnScreen().x;
                n6 = component.getLocationOnScreen().y - component2.getLocationOnScreen().y;
                n5 -= component2.getWidth() / 2 - this.origImage.getWidth() / 2;
                n6 -= component2.getHeight() / 2 - this.origImage.getHeight() / 2;
            }
        }
        graphics.drawImage(this.watermarkImage, n, n2, n + n3, n2 + n4, n + n5, n2 + n6, n + n5 + n3, n2 + n6 + n4, null);
    }

    @Override
    public void previewWatermark(Graphics graphics, SubstanceSkin substanceSkin, int n, int n2, int n3, int n4) {
    }

    @Override
    public boolean updateWatermarkImage(SubstanceSkin substanceSkin) {
        Object object;
        GraphicsDevice[] graphicsDeviceArray;
        if (this.origImage == null) {
            return false;
        }
        Rectangle rectangle = new Rectangle();
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray = graphicsEnvironment.getScreenDevices()) {
            object = graphicsDevice.getDefaultConfiguration();
            rectangle = rectangle.union(((GraphicsConfiguration)object).getBounds());
        }
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = this.origImage.getWidth();
        int n4 = this.origImage.getHeight();
        if (this.getKind() == SubstanceConstants.ImageWatermarkKind.SCREEN_CENTER_SCALE) {
            boolean bl;
            this.watermarkImage = SubstanceCoreUtilities.getBlankImage(n, n2);
            object = (Graphics2D)this.watermarkImage.getGraphics().create();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.opacity);
            ((Graphics2D)object).setComposite(alphaComposite);
            boolean bl2 = n3 <= n;
            boolean bl3 = bl = n4 <= n2;
            if (bl2 && bl) {
                ((Graphics)object).drawImage(this.origImage, (n - n3) / 2, (n2 - n4) / 2, null);
                ((Graphics)object).dispose();
                return true;
            }
            if (bl2) {
                double d = (double)n2 / (double)n4;
                int n5 = (int)((double)n - d * (double)n3) / 2;
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                ((Graphics)object).drawImage(this.origImage, n5, 0, n - n5, n2, 0, 0, n3, n4, null);
                ((Graphics)object).dispose();
                return true;
            }
            if (bl) {
                double d = (double)n / (double)n3;
                int n6 = (int)((double)n2 - d * (double)n4) / 2;
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
                ((Graphics)object).drawImage(this.origImage, 0, n6, n, n2 - n6, 0, 0, n3, n4, null);
                ((Graphics)object).dispose();
                return true;
            }
            double d = (double)n2 / (double)n4;
            double d2 = (double)n / (double)n3;
            double d3 = Math.min(d2, d);
            int n7 = Math.max(0, (int)((double)n - d3 * (double)n3) / 2);
            int n8 = Math.max(0, (int)((double)n2 - d3 * (double)n4) / 2);
            ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            ((Graphics)object).drawImage(this.origImage, n7, n8, n - n7, n2 - n8, 0, 0, n3, n4, null);
            ((Graphics)object).dispose();
            return true;
        }
        if (this.getKind() == SubstanceConstants.ImageWatermarkKind.SCREEN_TILE || this.getKind() == SubstanceConstants.ImageWatermarkKind.APP_TILE) {
            this.watermarkImage = SubstanceCoreUtilities.getBlankImage(n, n2);
            object = (Graphics2D)this.watermarkImage.getGraphics().create();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.opacity);
            ((Graphics2D)object).setComposite(alphaComposite);
            int n9 = 1 + n / n3;
            int n10 = 1 + n2 / n4;
            for (int i = 0; i < n9; ++i) {
                for (int j = 0; j < n10; ++j) {
                    ((Graphics)object).drawImage(this.origImage, i * n3, j * n4, null);
                }
            }
            ((Graphics)object).dispose();
            return true;
        }
        if (this.getKind() == SubstanceConstants.ImageWatermarkKind.APP_ANCHOR || this.getKind() == SubstanceConstants.ImageWatermarkKind.APP_CENTER) {
            this.watermarkImage = SubstanceCoreUtilities.getBlankImage(n3, n4);
            object = (Graphics2D)this.watermarkImage.getGraphics().create();
            AlphaComposite alphaComposite = AlphaComposite.getInstance(3, this.opacity);
            ((Graphics2D)object).setComposite(alphaComposite);
            ((Graphics)object).drawImage(this.origImage, 0, 0, null);
            ((Graphics)object).dispose();
            return true;
        }
        return false;
    }

    @Override
    public String getDisplayName() {
        return "Image";
    }

    @Override
    public void dispose() {
        this.watermarkImage = null;
    }

    public String getOrigImageLocation() {
        return this.origImageLocation;
    }

    public void setKind(SubstanceConstants.ImageWatermarkKind imageWatermarkKind) {
        if (imageWatermarkKind == null) {
            throw new IllegalArgumentException("Can't pass null to SubstanceImageWatermark.setKind()");
        }
        this.kind = imageWatermarkKind;
        this.updateWatermarkImage(SubstanceLookAndFeel.getCurrentSkin(null));
    }

    public SubstanceConstants.ImageWatermarkKind getKind() {
        return this.kind;
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float f) {
        if (f < 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("SubstanceImageWatermark.setOpacity() can get value in 0.0-1.0 range, was passed value " + f);
        }
        this.opacity = f;
        this.updateWatermarkImage(SubstanceLookAndFeel.getCurrentSkin(null));
    }
}

