/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.shaper;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.pushingpixels.substance.api.SubstanceConstants;
import org.pushingpixels.substance.api.shaper.RectangularButtonShaper;
import org.pushingpixels.substance.api.shaper.SubstanceButtonShaper;
import org.pushingpixels.substance.internal.utils.HashMapKey;
import org.pushingpixels.substance.internal.utils.LazyResettableHashMap;
import org.pushingpixels.substance.internal.utils.SubstanceCoreUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceInternalArrowButton;
import org.pushingpixels.substance.internal.utils.SubstanceOutlineUtilities;
import org.pushingpixels.substance.internal.utils.SubstanceSizeUtils;
import org.pushingpixels.substance.internal.utils.border.SubstanceBorder;
import org.pushingpixels.substance.internal.utils.border.SubstanceButtonBorder;

public class ClassicButtonShaper
implements SubstanceButtonShaper,
RectangularButtonShaper {
    private static final LazyResettableHashMap<GeneralPath> contours = new LazyResettableHashMap("ClassicButtonShaper");
    public static final ClassicButtonShaper INSTANCE = new ClassicButtonShaper();

    @Override
    public String getDisplayName() {
        return "Classic";
    }

    @Override
    public GeneralPath getButtonOutline(AbstractButton abstractButton, Insets insets, int n, int n2, boolean bl) {
        HashMapKey hashMapKey;
        GeneralPath generalPath;
        Set<SubstanceConstants.Side> set = SubstanceCoreUtilities.getSides(abstractButton, "substancelaf.buttonside");
        float f = this.getCornerRadius(abstractButton, insets);
        if (bl && (f -= (float)((int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(abstractButton)))) < 0.0f) {
            f = 0.0f;
        }
        if ((generalPath = contours.get(hashMapKey = SubstanceCoreUtilities.getHashKey(n, n2, set, Float.valueOf(f), insets))) != null) {
            return generalPath;
        }
        generalPath = SubstanceOutlineUtilities.getBaseOutline(n, n2, f, set, insets);
        contours.put(hashMapKey, generalPath);
        return generalPath;
    }

    @Override
    public Border getButtonBorder(final AbstractButton abstractButton) {
        return new SubstanceButtonBorder(ClassicButtonShaper.class){

            @Override
            public Insets getBorderInsets(Component component) {
                int n = SubstanceSizeUtils.getComponentFontSize(abstractButton);
                Insets insets = SubstanceSizeUtils.getButtonInsets(n);
                int n2 = SubstanceSizeUtils.getFocusRingPadding(n);
                int n3 = SubstanceCoreUtilities.hasText(abstractButton) ? SubstanceSizeUtils.getTextButtonLRPadding(n) : 0;
                Set<SubstanceConstants.Side> set = SubstanceCoreUtilities.getSides(abstractButton, "substancelaf.buttonopenSide");
                int n4 = n3 + insets.left + n2 + (set != null && set.contains((Object)SubstanceConstants.Side.LEFT) ? -1 : 0);
                int n5 = n3 + insets.right + n2 + (set != null && set.contains((Object)SubstanceConstants.Side.RIGHT) ? -1 : 0);
                int n6 = insets.top + (set != null && set.contains((Object)SubstanceConstants.Side.TOP) ? -1 : 0);
                int n7 = insets.bottom + (set != null && set.contains((Object)SubstanceConstants.Side.BOTTOM) ? -1 : 0);
                return new Insets(n6, n4, n7, n5);
            }
        };
    }

    @Override
    public Dimension getPreferredSize(AbstractButton abstractButton, Dimension dimension) {
        int n;
        int n2;
        boolean bl = false;
        boolean bl2 = false;
        Icon icon = abstractButton.getIcon();
        boolean bl3 = SubstanceCoreUtilities.hasIcon(abstractButton);
        boolean bl4 = SubstanceCoreUtilities.hasText(abstractButton);
        Insets insets = abstractButton.getMargin();
        Dimension dimension2 = dimension;
        boolean bl5 = SubstanceCoreUtilities.hasNoMinSizeProperty(abstractButton);
        if (!bl5 && bl4) {
            n2 = dimension.width;
            n2 = Math.max(n2, SubstanceSizeUtils.getMinButtonWidth(SubstanceSizeUtils.getComponentFontSize(abstractButton)));
            dimension2 = new Dimension(n2, dimension.height);
            n = dimension2.height;
            dimension2 = new Dimension(dimension2.width, n);
        } else if (bl5 && insets != null) {
            dimension2 = new Dimension(dimension2.width + insets.left + insets.right, dimension2.height + insets.top + insets.bottom);
        }
        n2 = SubstanceSizeUtils.getComponentFontSize(abstractButton);
        n = SubstanceSizeUtils.getExtraPadding(n2);
        int n3 = SubstanceSizeUtils.getFocusRingPadding(n2);
        int n4 = 6 + 2 * n + 2 * n3;
        int n5 = 6 + 2 * n;
        if (insets != null) {
            n4 = Math.max(n4, insets.left + insets.right);
            n5 = Math.max(n5, insets.top + insets.bottom);
        }
        if (bl3) {
            int n6;
            int n7 = icon.getIconHeight();
            if ((double)n7 > dimension2.getHeight() - (double)n5) {
                dimension2 = new Dimension(dimension2.width, n7);
                bl2 = true;
            }
            if ((double)(n6 = icon.getIconWidth()) > dimension2.getWidth() - (double)n4) {
                dimension2 = new Dimension(n6, dimension2.height);
                bl = true;
            }
        }
        if (SubstanceCoreUtilities.isScrollBarButton(abstractButton)) {
            bl = false;
            bl2 = false;
        }
        if (bl) {
            dimension2 = new Dimension(dimension2.width + n4, dimension2.height);
        }
        if (bl2) {
            dimension2 = new Dimension(dimension2.width, dimension2.height + n5);
        }
        return dimension2;
    }

    @Override
    public boolean isProportionate() {
        return true;
    }

    @Override
    public float getCornerRadius(AbstractButton abstractButton, Insets insets) {
        Border border;
        float f = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(abstractButton));
        if (abstractButton instanceof SubstanceInternalArrowButton && (border = ((JComponent)abstractButton.getParent()).getBorder()) instanceof SubstanceBorder) {
            f *= ((SubstanceBorder)border).getRadiusScaleFactor();
        }
        if (SubstanceCoreUtilities.isToolBarButton(abstractButton)) {
            f = SubstanceCoreUtilities.getToolbarButtonCornerRadius(abstractButton, insets);
        }
        return f;
    }
}

