/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.overlay;

import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.SwingUtilities;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.SubstancePainterUtils;
import org.pushingpixels.substance.api.painter.overlay.SubstanceOverlayPainter;
import org.pushingpixels.substance.internal.utils.SubstanceColorUtilities;

public final class TopShadowOverlayPainter
implements SubstanceOverlayPainter {
    private static TopShadowOverlayPainter INSTANCE;

    public static synchronized TopShadowOverlayPainter getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TopShadowOverlayPainter();
        }
        return INSTANCE;
    }

    private TopShadowOverlayPainter() {
    }

    @Override
    public void paintOverlay(Graphics2D graphics2D, Component component, DecorationAreaType decorationAreaType, int n, int n2, SubstanceSkin substanceSkin) {
        Color color = SubstanceColorUtilities.getBackgroundFillColor(component).darker();
        Component component2 = SubstancePainterUtils.getTopMostParentWithDecorationAreaType(component, decorationAreaType);
        Point point = SwingUtilities.convertPoint(component, new Point(0, 0), component2);
        int n3 = point.y;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        graphics2D2.translate(0, -n3);
        graphics2D2.setPaint(new GradientPaint(0.0f, 0.0f, SubstanceColorUtilities.getAlphaColor(color, 160), 0.0f, 4.0f, SubstanceColorUtilities.getAlphaColor(color, 16)));
        graphics2D2.fillRect(0, 0, component.getWidth(), 4);
        graphics2D2.dispose();
    }

    @Override
    public String getDisplayName() {
        return "Top Shadow";
    }
}

