/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.substance.api.painter.decoration;

import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Point;
import org.pushingpixels.substance.api.DecorationAreaType;
import org.pushingpixels.substance.api.SubstanceColorScheme;
import org.pushingpixels.substance.api.SubstanceSkin;
import org.pushingpixels.substance.api.painter.SubstancePainterUtils;
import org.pushingpixels.substance.api.painter.decoration.SubstanceDecorationPainter;

public class MatteDecorationPainter
implements SubstanceDecorationPainter {
    public static final String DISPLAY_NAME = "Matte";

    @Override
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public void paintDecorationArea(Graphics2D graphics2D, Component component, DecorationAreaType decorationAreaType, int n, int n2, SubstanceSkin substanceSkin) {
        if (decorationAreaType == DecorationAreaType.PRIMARY_TITLE_PANE || decorationAreaType == DecorationAreaType.SECONDARY_TITLE_PANE) {
            this.paintTitleBackground(graphics2D, component, n, n2, substanceSkin.getBackgroundColorScheme(decorationAreaType));
        } else {
            this.paintExtraBackground(graphics2D, component, n, n2, substanceSkin.getBackgroundColorScheme(decorationAreaType));
        }
    }

    private void paintTitleBackground(Graphics2D graphics2D, Component component, int n, int n2, SubstanceColorScheme substanceColorScheme) {
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        this.fill(graphics2D2, component, substanceColorScheme, 0, 0, 0, n, n2);
        graphics2D2.dispose();
    }

    private void paintExtraBackground(Graphics2D graphics2D, Component component, int n, int n2, SubstanceColorScheme substanceColorScheme) {
        Point point = SubstancePainterUtils.getOffsetInRootPaneCoords(component);
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        this.fill(graphics2D2, component, substanceColorScheme, point.y, 0, 0, n, n2);
        graphics2D2.dispose();
    }

    protected void fill(Graphics2D graphics2D, Component component, SubstanceColorScheme substanceColorScheme, int n, int n2, int n3, int n4, int n5) {
        int n6 = 50;
        int n7 = n3 + n;
        if (n7 < 0) {
            n7 = 0;
        }
        int n8 = n7 + n5;
        int n9 = 0;
        if (n6 >= n7) {
            graphics2D.setPaint(new GradientPaint(n2, n9 - n, substanceColorScheme.getLightColor(), n2, n6 - n, substanceColorScheme.getMidColor()));
            graphics2D.fillRect(n2, n9 - n, n4, n6);
        }
        if ((n9 += n6) > n8) {
            return;
        }
        graphics2D.setColor(substanceColorScheme.getMidColor());
        graphics2D.fillRect(n2, n9 - n, n4, n8 - n9 + n);
    }
}

