/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.delegate;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;
import net.beeger.squareness.util.SquarenessButtonPainter;
import net.beeger.squareness.util.SquarenessListenerFactory;

public class SquarenessToggleButtonUI
extends BasicToggleButtonUI {
    private static SquarenessToggleButtonUI _buttonUI = new SquarenessToggleButtonUI();

    public static ComponentUI createUI(JComponent component) {
        return _buttonUI;
    }

    public void installUI(JComponent component) {
        component.putClientProperty("SquarenessRollover", Boolean.FALSE);
        component.addMouseListener(SquarenessListenerFactory.getButtonRolloverMouseListener());
        super.installUI(component);
    }

    public void uninstallUI(JComponent component) {
        component.removeMouseListener(SquarenessListenerFactory.getButtonRolloverMouseListener());
        super.uninstallUI(component);
    }

    public void paint(Graphics graphics, JComponent component) {
        Color oldColor = graphics.getColor();
        SquarenessButtonPainter.paintButton(graphics, (AbstractButton)component);
        AbstractButton b = (AbstractButton)component;
        ButtonModel model = b.getModel();
        Dimension size = b.getSize();
        FontMetrics fm = graphics.getFontMetrics();
        Insets i = component.getInsets();
        Rectangle viewRect = new Rectangle(size);
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Font f = component.getFont();
        graphics.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(component, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        graphics.setColor(b.getBackground());
        if (model.isArmed() && model.isPressed() || model.isSelected()) {
            this.paintButtonPressed(graphics, b);
        }
        if (b.getIcon() != null) {
            this.paintIcon(graphics, b, iconRect);
        }
        if (text != null && !text.equals("")) {
            View v = (View)component.getClientProperty("html");
            if (v != null) {
                v.paint(graphics, textRect);
            } else {
                this.paintText(graphics, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(graphics, b, viewRect, textRect, iconRect);
        }
        graphics.setColor(oldColor);
    }
}

