/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.application;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;
import org.jdesktop.application.session.PropertySupport;
import org.jdesktop.application.session.SplitPaneProperty;
import org.jdesktop.application.session.TabbedPaneProperty;
import org.jdesktop.application.session.TableProperty;
import org.jdesktop.application.session.WindowProperty;

public class SessionStorage {
    private static Logger logger = Logger.getLogger(SessionStorage.class.getName());
    private final Map<Class, PropertySupport> propertyMap;
    private final ApplicationContext context;

    protected SessionStorage(ApplicationContext applicationContext) {
        if (applicationContext == null) {
            throw new IllegalArgumentException("null context");
        }
        this.context = applicationContext;
        this.propertyMap = new HashMap<Class, PropertySupport>();
        this.propertyMap.put(Window.class, new WindowProperty());
        this.propertyMap.put(JTabbedPane.class, new TabbedPaneProperty());
        this.propertyMap.put(JSplitPane.class, new SplitPaneProperty());
        this.propertyMap.put(JTable.class, new TableProperty());
    }

    protected final ApplicationContext getContext() {
        return this.context;
    }

    public void registerPropertySupport(Class<? extends Component> clazz, PropertySupport propertySupport) {
        if (clazz == null) {
            throw new IllegalArgumentException("Class argument must not ne null.");
        }
        if (propertySupport == null) {
            this.propertyMap.remove(clazz);
            return;
        }
        this.propertyMap.put(clazz, propertySupport);
    }

    private void checkSaveRestoreArgs(Component component, String string) {
        if (component == null) {
            throw new IllegalArgumentException("null root");
        }
        if (string == null) {
            throw new IllegalArgumentException("null fileName");
        }
    }

    private String getComponentName(Component component) {
        return component.getName();
    }

    private String getComponentPathname(Component component) {
        String string = this.getComponentName(component);
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        while (component.getParent() != null && !(component instanceof Window) && !(component instanceof Applet)) {
            string = this.getComponentName(component = component.getParent());
            if (string == null) {
                int n = component.getParent().getComponentZOrder(component);
                if (n >= 0) {
                    Class<?> clazz = component.getClass();
                    string = clazz.getSimpleName();
                    if (string.length() == 0) {
                        string = "Anonymous" + clazz.getSuperclass().getSimpleName();
                    }
                    string = string + n;
                } else {
                    logger.warning("Couldn't compute pathname for " + component);
                    return null;
                }
            }
            stringBuilder.append("/").append(string);
        }
        return stringBuilder.toString();
    }

    private void saveTree(List<Component> list, Map<String, Object> map) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : list) {
            Object object;
            String string;
            Component[] componentArray;
            if (component != null && (componentArray = this.getProperty(component)) != null && (string = this.getComponentPathname(component)) != null && (object = componentArray.getSessionState(component)) != null) {
                map.put(string, object);
            }
            if (!(component instanceof Container) || (componentArray = ((Container)component).getComponents()) == null || componentArray.length <= 0) continue;
            Collections.addAll(arrayList, componentArray);
        }
        if (arrayList.size() > 0) {
            this.saveTree(arrayList, map);
        }
    }

    public void save(Component component, String string) throws IOException {
        this.checkSaveRestoreArgs(component, string);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        this.saveTree(Collections.singletonList(component), hashMap);
        LocalStorage localStorage = this.getContext().getLocalStorage();
        localStorage.save(hashMap, string);
    }

    private void restoreTree(List<Component> list, Map<String, Object> map) {
        ArrayList<Component> arrayList = new ArrayList<Component>();
        for (Component component : list) {
            String string;
            Component[] componentArray;
            if (component != null && (componentArray = this.getProperty(component)) != null && (string = this.getComponentPathname(component)) != null) {
                Object object = map.get(string);
                if (object != null) {
                    componentArray.setSessionState(component, object);
                } else {
                    logger.warning("No saved state for " + component);
                }
            }
            if (!(component instanceof Container) || (componentArray = ((Container)component).getComponents()) == null || componentArray.length <= 0) continue;
            Collections.addAll(arrayList, componentArray);
        }
        if (arrayList.size() > 0) {
            this.restoreTree(arrayList, map);
        }
    }

    public void restore(Component component, String string) throws IOException {
        this.checkSaveRestoreArgs(component, string);
        LocalStorage localStorage = this.getContext().getLocalStorage();
        Map map = (Map)localStorage.load(string);
        if (map != null) {
            this.restoreTree(Collections.singletonList(component), map);
        }
    }

    private void checkClassArg(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("null class");
        }
    }

    public PropertySupport getProperty(Class clazz) {
        this.checkClassArg(clazz);
        while (clazz != null) {
            PropertySupport propertySupport = this.propertyMap.get(clazz);
            if (propertySupport != null) {
                return propertySupport;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    public void putProperty(Class clazz, PropertySupport propertySupport) {
        this.checkClassArg(clazz);
        this.propertyMap.put(clazz, propertySupport);
    }

    public final PropertySupport getProperty(Component component) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (component instanceof PropertySupport) {
            return (PropertySupport)((Object)component);
        }
        PropertySupport propertySupport = null;
        if (component instanceof JComponent) {
            Object object = ((JComponent)component).getClientProperty(PropertySupport.class);
            propertySupport = object instanceof PropertySupport ? (PropertySupport)object : null;
        }
        return propertySupport != null ? propertySupport : this.getProperty(component.getClass());
    }
}

