/*
 * Decompiled with CFR 0.152.
 */
package nl.ikarus.nxt.priv.imageio.icoreader.lib;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import nl.ikarus.nxt.priv.imageio.icoreader.lib.ICOMetaData;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.Bitmap;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.ICOFile;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.IconEntry;

public class ICOReader
extends ImageReader {
    private final boolean DEBUG = Boolean.valueOf(System.getProperty("nl.ikarus.nxt.priv.imageio.icoreader.debug", Boolean.toString(false)));
    public static final String PROPERTY_NAME_PREFIX = "nl.ikarus.nxt.priv.imageio.icoreader.";
    private ICOFile _cachedIcoFile = null;

    protected ICOReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    public int getHeight(int imageIndex) throws IOException {
        return this.getIcoFile().getEntry(imageIndex).getHeight();
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        try {
            ICOFile file = this.getIcoFile();
            IconEntry e = file.getEntry(imageIndex);
            ICOMetaData meta = new ICOMetaData();
            meta.put("width", Integer.toString(e.getWidth()));
            meta.put("height", Integer.toString(e.getHeight()));
            meta.put("colorCount", Integer.toString(e.getColorCount()));
            meta.put("bitCount", Integer.toString(e.getBitCount()));
            meta.put("bpp", Integer.toString(e.getBitCount()));
            meta.put("reserved", Integer.toString(e.getReserved()));
            meta.put("planes", Integer.toString(e.getPlanes()));
            return meta;
        }
        catch (Exception ex) {
            throw new IIOException("Exception reading metadata", ex);
        }
    }

    public Iterator getImageTypes(int imageIndex) throws IOException {
        return new Iterator(){
            boolean hasN = true;

            public boolean hasNext() {
                return this.hasN;
            }

            public Object next() {
                if (!this.hasN) {
                    throw new NoSuchElementException();
                }
                this.hasN = false;
                return ImageTypeSpecifier.createFromBufferedImageType(2);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int getNumImages(boolean allowSearch) throws IOException {
        if (this._cachedIcoFile == null && !allowSearch) {
            return -1;
        }
        return this.getIcoFile().getEntryCount();
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        return null;
    }

    public int getWidth(int imageIndex) throws IOException {
        return this.getIcoFile().getEntry(imageIndex).getWidth();
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
        ICOFile file = this.getIcoFile();
        boolean autoSelect = Boolean.valueOf(System.getProperty("nl.ikarus.nxt.priv.imageio.icoreader.autoselect.icon", Boolean.toString(false)));
        if (autoSelect || imageIndex < 0) {
            return this.selectBestImage();
        }
        IconEntry e = file.getEntry(imageIndex);
        return this.getImageFromEntry(e);
    }

    private BufferedImage selectBestImage() throws IOException {
        ICOFile file = this.getIcoFile();
        if (file.getEntryCount() == 0) {
            return null;
        }
        int h = Integer.MAX_VALUE;
        int w = Integer.MAX_VALUE;
        try {
            int ww = Integer.parseInt(System.getProperty("nl.ikarus.nxt.priv.imageio.icoreader.autoselect.width", Integer.toString(w)));
            int hh = Integer.parseInt(System.getProperty("nl.ikarus.nxt.priv.imageio.icoreader.autoselect.height", Integer.toString(h)));
            w = ww;
            h = hh;
        }
        catch (Exception ex) {
            // empty catch block
        }
        IconEntry best = file.getEntry(0);
        int best_w = best.getWidth();
        int best_h = best.getHeight();
        int bpp = best.getBitCount();
        for (int i = 1; i < file.getEntryCount(); ++i) {
            IconEntry cur = file.getEntry(i);
            if (cur.getBitCount() > bpp) {
                best = cur;
                bpp = best.getBitCount();
                best_w = best.getWidth();
                best_h = best.getHeight();
                continue;
            }
            if (cur.getBitCount() != bpp) continue;
            int d1 = Math.abs(w - best_w) + Math.abs(h - best_h);
            int d2 = Math.abs(w - cur.getWidth()) + Math.abs(h - cur.getHeight());
            if (d2 >= d1) continue;
            best = cur;
            bpp = best.getBitCount();
            best_w = best.getWidth();
            best_h = best.getHeight();
        }
        if (this.DEBUG) {
            System.out.println("selected best fitting image: " + best.getWidth() + "x" + best.getHeight() + "x" + best.getBitCount());
        }
        return this.getImageFromEntry(best);
    }

    private BufferedImage getImageFromEntry(IconEntry e) throws IOException {
        Bitmap b;
        BufferedImage im = null;
        try {
            b = e.getBitmap();
            if (b == null) {
                return null;
            }
            im = b.getImage();
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage() + " -- I'll try to convert the icon to BMP and read it with the BMP reader");
            im = null;
        }
        if (im == null) {
            b = e.getImageIoBitmap();
            im = b.getImage();
        }
        return im;
    }

    private ImageInputStream getMyReader() throws IOException {
        Object input = this.getInput();
        if (input instanceof ImageInputStream) {
            return (ImageInputStream)input;
        }
        return ImageIO.createImageInputStream(input);
    }

    private ICOFile getIcoFile() throws IOException {
        if (this._cachedIcoFile != null) {
            return this._cachedIcoFile;
        }
        ImageInputStream input = this.getMyReader();
        if (input instanceof ImageInputStream) {
            ICOFile file;
            boolean res;
            ImageInputStream in = input;
            byte[] buff = new byte[4];
            in.mark();
            in.readFully(buff);
            in.reset();
            boolean bl = res = buff[0] == 0 && buff[1] == 0 && buff[2] == 1 && buff[3] == 0;
            if (!res) {
                System.err.println("ICOReader: Incorrect header -- this should have been detected by the ICOReaderSpi -- did anyone tamper with the inputstream (for example the WBMPImageReader sometimes does that)? make sure you have a fresh imageinputstream before calling the read method!.....");
            }
            this._cachedIcoFile = file = new ICOFile(in);
            return file;
        }
        if (input == null) {
            throw new IOException("This class supports only an ImageInputStream as input, found: null");
        }
        throw new IOException("This class supports only an ImageInputStream as input, found: " + input.getClass().getName());
    }
}

