/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swinghelper.buttonpanel;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;

public class JXButtonPanel
extends JPanel {
    private boolean isCyclic;
    private boolean isGroupSelectionFollowFocus;

    public JXButtonPanel() {
        this.init();
    }

    public JXButtonPanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.init();
    }

    public JXButtonPanel(boolean bl) {
        super(bl);
        this.init();
    }

    public JXButtonPanel(LayoutManager layoutManager, boolean bl) {
        super(layoutManager, bl);
        this.init();
    }

    private void init() {
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(new JXButtonPanelFocusTraversalPolicy());
        ActionHandler actionHandler = new ActionHandler();
        this.registerKeyboardAction(actionHandler, "moveSelectionForward", KeyStroke.getKeyStroke(39, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionForward", KeyStroke.getKeyStroke(40, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionBackward", KeyStroke.getKeyStroke(37, 0), 1);
        this.registerKeyboardAction(actionHandler, "moveSelectionBackward", KeyStroke.getKeyStroke(38, 0), 1);
        this.setGroupSelectionFollowFocus(true);
    }

    public boolean isCyclic() {
        return this.isCyclic;
    }

    public void setCyclic(boolean bl) {
        this.isCyclic = bl;
    }

    public boolean isGroupSelectionFollowFocus() {
        return this.isGroupSelectionFollowFocus;
    }

    public void setGroupSelectionFollowFocus(boolean bl) {
        this.isGroupSelectionFollowFocus = bl;
    }

    private static ButtonGroup getButtonGroup(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        if (buttonModel instanceof DefaultButtonModel) {
            return ((DefaultButtonModel)buttonModel).getGroup();
        }
        return null;
    }

    private class JXButtonPanelFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        private boolean isAlternativeFocusMode;

        private JXButtonPanelFocusTraversalPolicy() {
        }

        public boolean isAlternativeFocusMode() {
            return this.isAlternativeFocusMode;
        }

        public void setAlternativeFocusMode(boolean bl) {
            this.isAlternativeFocusMode = bl;
        }

        protected boolean accept(Component component) {
            AbstractButton abstractButton;
            ButtonGroup buttonGroup;
            if (!this.isAlternativeFocusMode() && component instanceof AbstractButton && (buttonGroup = JXButtonPanel.getButtonGroup(abstractButton = (AbstractButton)component)) != null && buttonGroup.getSelection() != null && !abstractButton.isSelected()) {
                return false;
            }
            return super.accept(component);
        }

        public Component getComponentAfter(Container container, Component component) {
            Component component2 = super.getComponentAfter(container, component);
            if (!this.isAlternativeFocusMode()) {
                return component2;
            }
            if (JXButtonPanel.this.isCyclic()) {
                return component2 == null ? this.getFirstComponent(container) : component2;
            }
            if (component == this.getLastComponent(container)) {
                return component;
            }
            return component2;
        }

        public Component getComponentBefore(Container container, Component component) {
            Component component2 = super.getComponentBefore(container, component);
            if (!this.isAlternativeFocusMode()) {
                return component2;
            }
            if (JXButtonPanel.this.isCyclic()) {
                return component2 == null ? this.getLastComponent(container) : component2;
            }
            if (component == this.getFirstComponent(container)) {
                return component;
            }
            return component2;
        }
    }

    private class ActionHandler
    implements ActionListener {
        private static final String FORWARD = "moveSelectionForward";
        private static final String BACKWARD = "moveSelectionBackward";

        private ActionHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FocusTraversalPolicy focusTraversalPolicy = JXButtonPanel.this.getFocusTraversalPolicy();
            if (focusTraversalPolicy instanceof JXButtonPanelFocusTraversalPolicy) {
                Serializable serializable;
                Component component;
                JXButtonPanelFocusTraversalPolicy jXButtonPanelFocusTraversalPolicy = (JXButtonPanelFocusTraversalPolicy)focusTraversalPolicy;
                String string = actionEvent.getActionCommand();
                Component component2 = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                jXButtonPanelFocusTraversalPolicy.setAlternativeFocusMode(true);
                if (FORWARD.equals(string)) {
                    component = jXButtonPanelFocusTraversalPolicy.getComponentAfter(JXButtonPanel.this, component2);
                } else if (BACKWARD.equals(string)) {
                    component = jXButtonPanelFocusTraversalPolicy.getComponentBefore(JXButtonPanel.this, component2);
                } else {
                    throw new AssertionError((Object)("Unexpected action command: " + string));
                }
                jXButtonPanelFocusTraversalPolicy.setAlternativeFocusMode(false);
                if (component2 instanceof AbstractButton) {
                    serializable = (AbstractButton)component2;
                    ((AbstractButton)serializable).getModel().setPressed(false);
                }
                if (component != null && component2 instanceof AbstractButton && component instanceof AbstractButton) {
                    AbstractButton abstractButton;
                    serializable = JXButtonPanel.getButtonGroup((AbstractButton)component2);
                    if (serializable != JXButtonPanel.getButtonGroup(abstractButton = (AbstractButton)component)) {
                        return;
                    }
                    if (JXButtonPanel.this.isGroupSelectionFollowFocus() && serializable != null && ((ButtonGroup)serializable).getSelection() != null && !abstractButton.isSelected()) {
                        abstractButton.setSelected(true);
                    }
                    component.requestFocusInWindow();
                }
            }
        }
    }
}

