/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua;

import ch.randelshofer.quaqua.color.PaintableColor;
import ch.randelshofer.quaqua.util.Methods;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.plaf.basic.BasicOptionPaneUI;
import javax.swing.text.Document;
import javax.swing.text.View;

public class QuaquaOptionPaneUI
extends BasicOptionPaneUI {
    private static final int MIN_BUTTON_WIDTH = 74;
    private static final int HORIZONTAL_BUTTON_PADDING = 8;
    private QuaquaButtonAreaLayout buttonAreaLayout;
    private static String newline;
    private Handler handler;

    public static ComponentUI createUI(JComponent x) {
        return new QuaquaOptionPaneUI();
    }

    public void paint(Graphics gr, JComponent c) {
        if (c.isOpaque()) {
            Graphics2D g = (Graphics2D)gr;
            g.setPaint(PaintableColor.getPaint(c.getBackground(), c));
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
    }

    protected LayoutManager createLayoutManager() {
        return new GridBagLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void installComponents() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        this.optionPane.add((Component)this.createMessageArea(), c);
        Container separator = this.createSeparator();
        if (separator != null) {
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 1;
            c.fill = 2;
            this.optionPane.add((Component)separator, c);
        }
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 2;
        c.fill = 2;
        this.optionPane.add((Component)this.createButtonArea(), c);
        Methods.invokeIfExists(this.optionPane, "applyComponentOrientation", ComponentOrientation.class, this.optionPane.getComponentOrientation());
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        this.handler = null;
    }

    protected Container createMessageArea() {
        JPanel top = new JPanel();
        top.setBorder(UIManager.getBorder("OptionPane.messageAreaBorder"));
        top.setLayout(new BorderLayout());
        JPanel body = new JPanel();
        JPanel realBody = new JPanel();
        realBody.setLayout(new BorderLayout());
        realBody.add((Component)body, "Center");
        body.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 0;
        cons.gridheight = 1;
        cons.anchor = 17;
        cons.insets = new Insets(0, 0, 0, 0);
        this.addMessageComponents(body, cons, this.getMessage(), this.getMaxCharactersPerLineCount(), false);
        top.add((Component)realBody, "Center");
        this.addIcon(this.optionPane);
        return top;
    }

    protected int getMaxCharactersPerLineCount() {
        return Math.min(this.optionPane.getMaxCharactersPerLineCount(), UIManager.getInt("OptionPane.maxCharactersPerLineCount"));
    }

    protected void addIcon(Container top) {
        Icon sideIcon = this.getIcon();
        if (sideIcon != null) {
            JLabel iconLabel = new JLabel(sideIcon);
            iconLabel.setVerticalAlignment(1);
            GridBagConstraints cons = new GridBagConstraints();
            cons.gridx = 0;
            cons.gridy = 0;
            cons.anchor = 11;
            cons.gridheight = 0;
            cons.insets = new Insets(0, 0, 0, 10);
            top.add((Component)iconLabel, cons);
        }
    }

    protected void addButtonComponents(Container container, Object[] buttons, int initialIndex) {
        if (!(container.getLayout() instanceof QuaquaButtonAreaLayout)) {
            return;
        }
        if (buttons != null && buttons.length > 0) {
            boolean sizeButtonsToSame = this.getSizeButtonsToSameWidth();
            boolean createdAll = true;
            int numButtons = buttons.length;
            JButton[] createdButtons = null;
            int maxWidth = 0;
            Object mnemonics = null;
            if (mnemonics != null && (mnemonics).length != buttons.length) {
                mnemonics = null;
            }
            if (sizeButtonsToSame) {
                createdButtons = new JButton[numButtons];
            }
            for (int counter = 0; counter < numButtons; ++counter) {
                Component newComponent;
                Object button = buttons[counter];
                if (button instanceof Component) {
                    createdAll = false;
                    newComponent = (Component)button;
                    container.add(newComponent);
                    this.hasCustomComponents = true;
                } else {
                    JButton aButton = button instanceof ButtonFactory ? ((ButtonFactory)button).createButton() : (button instanceof Icon ? new JButton((Icon)button) : new JButton(button.toString()));
                    Methods.invokeIfExists((Object)aButton, "setMultiClickThreshhold", UIManager.getInt("OptionPane.buttonClickThreshhold"));
                    this.configureButton(aButton);
                    container.add(aButton);
                    ActionListener buttonListener = this.createButtonActionListener(counter);
                    if (buttonListener != null) {
                        aButton.addActionListener(buttonListener);
                    }
                    newComponent = aButton;
                    if (mnemonics != null) {
                        aButton.setMnemonic((int)mnemonics[counter]);
                    }
                }
                if (sizeButtonsToSame && createdAll && newComponent instanceof JButton) {
                    createdButtons[counter] = (JButton)newComponent;
                    maxWidth = Math.max(maxWidth, newComponent.getMinimumSize().width);
                }
                if (counter != initialIndex) continue;
                this.initialFocusComponent = newComponent;
                if (!(this.initialFocusComponent instanceof JButton)) continue;
                JButton defaultB = (JButton)this.initialFocusComponent;
                defaultB.setFocusable(true);
                defaultB.addAncestorListener(new AncestorListener(){

                    public void ancestorAdded(AncestorEvent e) {
                        JButton defaultButton = (JButton)e.getComponent();
                        JRootPane root = SwingUtilities.getRootPane(defaultButton);
                        if (root != null) {
                            root.setDefaultButton(defaultButton);
                        }
                    }

                    public void ancestorRemoved(AncestorEvent event) {
                    }

                    public void ancestorMoved(AncestorEvent event) {
                    }
                });
            }
            ((BasicOptionPaneUI.ButtonAreaLayout)container.getLayout()).setSyncAllWidths(sizeButtonsToSame && createdAll);
            if (sizeButtonsToSame && createdAll) {
                int padSize = numButtons <= 2 ? 8 : 4;
                for (int counter = 0; counter < numButtons; ++counter) {
                    JButton aButton = createdButtons[counter];
                    aButton.setMargin(new Insets(2, padSize, 2, padSize));
                }
            }
        }
    }

    private void configureButton(JButton button) {
        Font buttonFont = UIManager.getFont("OptionPane.buttonFont");
        if (buttonFont != null) {
            button.setFont(buttonFont);
        }
        if (button.getText() == null || button.getText().length() == 0) {
            new Throwable().printStackTrace();
            button.setText("QuaquaOptionPaneUI.hal");
        }
    }

    protected void addMessageComponents(Container container, GridBagConstraints cons, Object msg, int maxll, boolean internallyCreated) {
        if (msg == null) {
            return;
        }
        if (msg instanceof Component) {
            cons.weightx = 1.0;
            cons.weighty = 1.0;
            cons.fill = 1;
            container.add((Component)msg, cons);
            ++cons.gridy;
            if (!internallyCreated) {
                this.hasCustomComponents = true;
            }
        } else if (msg instanceof Object[]) {
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            cons.fill = 0;
            Object[] msgs = (Object[])msg;
            for (int i = 0; i < msgs.length; ++i) {
                this.addMessageComponents(container, cons, msgs[i], maxll, false);
            }
        } else if (msg instanceof Icon) {
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            cons.fill = 0;
            JLabel label = new JLabel((Icon)msg, 0);
            this.configureMessageLabel(label);
            this.addMessageComponents(container, cons, label, maxll, true);
        } else {
            cons.weightx = 0.0;
            cons.weighty = 0.0;
            cons.fill = 0;
            String s = msg.toString();
            int len = s.length();
            if (len <= 0) {
                return;
            }
            int nl = -1;
            int nll = 0;
            nl = s.indexOf(newline);
            if (nl >= 0) {
                nll = newline.length();
            } else {
                nl = s.indexOf("\r\n");
                if (nl >= 0) {
                    nll = 2;
                } else {
                    nl = s.indexOf(10);
                    if (nl >= 0) {
                        nll = 1;
                    }
                }
            }
            boolean isHTML = BasicHTML.isHTMLString(s);
            if (nl >= 0 && !isHTML) {
                if (nl == 0) {
                    this.addMessageComponents(container, cons, new Component(){

                        public Dimension getPreferredSize() {
                            Font f = this.getFont();
                            if (f != null) {
                                return new Dimension(1, f.getSize() + 2);
                            }
                            return new Dimension(0, 0);
                        }
                    }, maxll, true);
                } else {
                    this.addMessageComponents(container, cons, s.substring(0, nl), maxll, false);
                }
                this.addMessageComponents(container, cons, s.substring(nl + nll), maxll, false);
            } else if (len > maxll && !isHTML) {
                Box c = Box.createVerticalBox();
                this.burstStringInto(c, s, maxll);
                this.addMessageComponents(container, cons, c, maxll, true);
            } else {
                JLabel label = new JLabel(s, 10);
                this.configureMessageLabel(label);
                this.addMessageComponents(container, cons, label, maxll, true);
            }
        }
    }

    private void configureMessageLabel(JLabel label) {
        View htmlView;
        Font messageFont;
        label.setForeground(UIManager.getColor("OptionPane.messageForeground"));
        boolean isHTML = BasicHTML.isHTMLString(label.getText());
        Font font = messageFont = isHTML ? UIManager.getFont("OptionPane.htmlMessageFont") : UIManager.getFont("OptionPane.messageFont");
        if (isHTML && (htmlView = (View)label.getClientProperty("html")) != null && UIManager.getInt("OptionPane.messageLabelWidth") != 0) {
            htmlView.setSize(UIManager.getInt("OptionPane.messageLabelWidth"), 0.0f);
        }
        if (messageFont != null) {
            label.setFont(messageFont);
        }
    }

    protected Object[] getButtons() {
        if (this.optionPane != null) {
            Object[] suppliedOptions = this.optionPane.getOptions();
            if (suppliedOptions == null) {
                Locale l;
                int type = this.optionPane.getOptionType();
                try {
                    l = this.optionPane.getLocale();
                }
                catch (IllegalComponentStateException e) {
                    l = Locale.getDefault();
                }
                Object[] defaultOptions = type == 0 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString("OptionPane.yesButtonText"), this.getMnemonic("OptionPane.yesButtonMnemonic", l), (Icon)UIManager.get("OptionPane.yesIcon")), new ButtonFactory(UIManager.getString("OptionPane.noButtonText"), this.getMnemonic("OptionPane.noButtonMnemonic", l), (Icon)UIManager.get("OptionPane.noIcon"))} : (type == 1 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString("OptionPane.yesButtonText"), this.getMnemonic("OptionPane.yesButtonMnemonic", l), (Icon)UIManager.get("OptionPane.yesIcon")), new ButtonFactory(UIManager.getString("OptionPane.noButtonText"), this.getMnemonic("OptionPane.noButtonMnemonic", l), (Icon)UIManager.get("OptionPane.noIcon")), new ButtonFactory(UIManager.getString("OptionPane.cancelButtonText"), this.getMnemonic("OptionPane.cancelButtonMnemonic", l), (Icon)UIManager.get("OptionPane.cancelIcon"))} : (type == 2 ? new ButtonFactory[]{new ButtonFactory(UIManager.getString("OptionPane.okButtonText"), this.getMnemonic("OptionPane.okButtonMnemonic", l), (Icon)UIManager.get("OptionPane.okIcon")), new ButtonFactory(UIManager.getString("OptionPane.cancelButtonText"), this.getMnemonic("OptionPane.cancelButtonMnemonic", l), (Icon)UIManager.get("OptionPane.cancelIcon"))} : new ButtonFactory[]{new ButtonFactory(UIManager.getString("OptionPane.okButtonText"), this.getMnemonic("OptionPane.okButtonMnemonic", l), (Icon)UIManager.get("OptionPane.okIcon"))}));
                return defaultOptions;
            }
            return suppliedOptions;
        }
        return null;
    }

    protected Object getMessage() {
        this.inputComponent = null;
        if (this.optionPane != null) {
            if (this.optionPane.getWantsInput()) {
                JComponent toAdd;
                Object message = this.optionPane.getMessage();
                Object[] sValues = this.optionPane.getSelectionValues();
                Object inputValue = this.optionPane.getInitialSelectionValue();
                if (sValues != null) {
                    if (sValues.length < 20) {
                        JComboBox<Object> cBox = new JComboBox<Object>();
                        cBox.setName("OptionPane.comboBox");
                        int maxCounter = sValues.length;
                        for (int counter = 0; counter < maxCounter; ++counter) {
                            cBox.addItem(sValues[counter]);
                        }
                        if (inputValue != null) {
                            cBox.setSelectedItem(inputValue);
                        }
                        this.inputComponent = cBox;
                        toAdd = cBox;
                    } else {
                        JList<Object> list = new JList<Object>(sValues);
                        JScrollPane sp = new JScrollPane(list);
                        sp.setName("OptionPane.scrollPane");
                        list.setName("OptionPane.list");
                        list.setVisibleRowCount(10);
                        list.setSelectionMode(0);
                        if (inputValue != null) {
                            list.setSelectedValue(inputValue, true);
                        }
                        list.addMouseListener(this.getHandler());
                        toAdd = sp;
                        this.inputComponent = list;
                    }
                } else {
                    MultiplexingTextField tf = new MultiplexingTextField(20);
                    tf.setName("OptionPane.textField");
                    tf.setKeyStrokes(new KeyStroke[]{KeyStroke.getKeyStroke("ENTER")});
                    if (this.optionPane.getClientProperty("PrivateQuaqua.OptionPane.InputFieldDocument") instanceof Document) {
                        tf.setDocument((Document)this.optionPane.getClientProperty("PrivateQuaqua.OptionPane.InputFieldDocument"));
                    }
                    if (inputValue != null) {
                        String inputString = inputValue.toString();
                        tf.setText(inputString);
                        tf.setSelectionStart(0);
                        tf.setSelectionEnd(inputString.length());
                    }
                    tf.addActionListener(this.getHandler());
                    this.inputComponent = tf;
                    toAdd = this.inputComponent;
                }
                Object[] newMessage = message == null ? new Object[]{toAdd} : new Object[]{message, toAdd};
                return newMessage;
            }
            return this.optionPane.getMessage();
        }
        return null;
    }

    private int getMnemonic(String key, Locale l) {
        String value = (String)UIManager.get(key);
        if (value == null) {
            return 0;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    protected boolean getSizeButtonsToSameWidth() {
        return false;
    }

    protected Container createButtonArea() {
        super.createButtonArea();
        JPanel bottom = new JPanel();
        bottom.setBorder(UIManager.getBorder("OptionPane.buttonAreaBorder"));
        Object[] buttons = this.getButtons();
        this.buttonAreaLayout = new QuaquaButtonAreaLayout(false, 6);
        Integer destructiveOption = (Integer)this.optionPane.getClientProperty("Quaqua.OptionPane.destructiveOption");
        if (destructiveOption != null) {
            this.buttonAreaLayout.setDestructiveOption(destructiveOption);
        }
        bottom.setLayout(this.buttonAreaLayout);
        this.addButtonComponents(bottom, buttons, this.getInitialValueIndex());
        return bottom;
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                newline = System.getProperty("line.separator");
                if (newline == null) {
                    newline = "\n";
                }
                return null;
            }
        });
    }

    private static class MultiplexingTextField
    extends JTextField {
        private KeyStroke[] strokes;

        public MultiplexingTextField(Document doc, String text, int columns) {
            super(doc, text, columns);
        }

        public MultiplexingTextField(int cols) {
            super(cols);
        }

        public void setKeyStrokes(KeyStroke[] strokes) {
            this.strokes = strokes;
        }

        protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            boolean processed = super.processKeyBinding(ks, e, condition, pressed);
            if (processed && condition != 2) {
                for (int counter = this.strokes.length - 1; counter >= 0; --counter) {
                    if (!this.strokes[counter].equals(ks)) continue;
                    return false;
                }
            }
            return processed;
        }
    }

    private class Handler
    implements ActionListener,
    MouseListener,
    PropertyChangeListener {
        private Handler() {
        }

        public void actionPerformed(ActionEvent e) {
            QuaquaOptionPaneUI.this.optionPane.setInputValue(((JTextField)e.getSource()).getText());
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getClickCount() == 2) {
                JList list = (JList)e.getSource();
                int index = list.locationToIndex(e.getPoint());
                QuaquaOptionPaneUI.this.optionPane.setInputValue(list.getModel().getElementAt(index));
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == QuaquaOptionPaneUI.this.optionPane) {
                String changeName;
                if ("ancestor" == e.getPropertyName()) {
                    JOptionPane op = (JOptionPane)e.getSource();
                    boolean isComingUp = e.getOldValue() == null;
                }
                if ((changeName = e.getPropertyName()) == "options" || changeName == "initialValue" || changeName == "icon" || changeName == "messageType" || changeName == "optionType" || changeName == "message" || changeName == "selectionValues" || changeName == "initialSelectionValue" || changeName == "wantsInput") {
                    QuaquaOptionPaneUI.this.uninstallComponents();
                    QuaquaOptionPaneUI.this.installComponents();
                    QuaquaOptionPaneUI.this.optionPane.validate();
                } else if (changeName == "componentOrientation") {
                    ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                    JOptionPane op = (JOptionPane)e.getSource();
                    if (o != (ComponentOrientation)e.getOldValue()) {
                        op.applyComponentOrientation(o);
                    }
                } else if ("Quaqua.OptionPane.destructiveOption" == changeName) {
                    Integer value = (Integer)e.getNewValue();
                    if (QuaquaOptionPaneUI.this.buttonAreaLayout != null) {
                        QuaquaOptionPaneUI.this.buttonAreaLayout.setDestructiveOption(value == null ? -1 : value);
                    }
                }
            }
        }
    }

    private static class ButtonFactory {
        private String text;
        private int mnemonic;
        private Icon icon;

        ButtonFactory(String text, int mnemonic, Icon icon) {
            this.text = text;
            this.mnemonic = mnemonic;
            this.icon = icon;
        }

        JButton createButton() {
            JButton button = new JButton(this.text);
            if (this.icon != null) {
                button.setIcon(this.icon);
            }
            if (this.mnemonic != 0) {
                button.setMnemonic(this.mnemonic);
            }
            return button;
        }
    }

    public static class QuaquaButtonAreaLayout
    extends BasicOptionPaneUI.ButtonAreaLayout {
        protected int destructiveOption = -1;

        public QuaquaButtonAreaLayout(boolean syncAllWidths, int padding) {
            super(syncAllWidths, padding);
            this.centersChildren = false;
        }

        public void setDestructiveOption(int newValue) {
            this.destructiveOption = newValue;
        }

        public int getDestructiveOption() {
            return this.destructiveOption;
        }

        public void setSyncAllWidths(boolean newValue) {
            this.syncAllWidths = newValue;
        }

        public boolean getSyncAllWidths() {
            return this.syncAllWidths;
        }

        public void setPadding(int newPadding) {
            this.padding = newPadding;
        }

        public int getPadding() {
            return this.padding;
        }

        public void setCentersChildren(boolean newValue) {
            this.centersChildren = newValue;
        }

        public boolean getCentersChildren() {
            return this.centersChildren;
        }

        public void addLayoutComponent(String string, Component comp) {
        }

        public void layoutContainer(Container container) {
            block14: {
                Component[] children = container.getComponents();
                if (children == null || children.length <= 0) break block14;
                int numChildren = children.length;
                Dimension[] sizes = new Dimension[numChildren];
                Insets insets = container.getInsets();
                int yLocation = insets.top;
                boolean ltr = container.getComponentOrientation().isLeftToRight();
                if (this.syncAllWidths) {
                    int counter;
                    int maxWidth = 74;
                    for (counter = 0; counter < numChildren; ++counter) {
                        sizes[counter] = children[counter].getPreferredSize();
                        maxWidth = Math.max(maxWidth, sizes[counter].width + 8);
                    }
                    int xOffset = this.padding + maxWidth;
                    int xLocation = this.getCentersChildren() ? (container.getSize().width - insets.left - insets.right - (maxWidth * numChildren + (numChildren - 1) * this.padding)) / 2 : (ltr ? container.getSize().width - insets.right - (maxWidth * numChildren + (numChildren - 1) * this.padding) : insets.left);
                    if (ltr) {
                        if (numChildren > 1) {
                            xLocation += maxWidth * (numChildren - 1) + (numChildren - 1) * this.padding;
                        }
                        xOffset = -xOffset;
                    }
                    for (counter = 0; counter < numChildren; ++counter) {
                        children[counter].setBounds(xLocation, yLocation, maxWidth, sizes[counter].height);
                        xLocation += xOffset;
                        if (counter != this.destructiveOption - 1) continue;
                        if (xOffset > 0) {
                            xLocation += 14;
                            continue;
                        }
                        xLocation -= 14;
                    }
                } else {
                    int counter;
                    int totalWidth = 0;
                    for (counter = 0; counter < numChildren; ++counter) {
                        sizes[counter] = children[counter].getPreferredSize();
                        sizes[counter].width = Math.max(74, sizes[counter].width + 8);
                        totalWidth += sizes[counter].width;
                    }
                    boolean cc = this.getCentersChildren();
                    int xLocation = cc ? insets.left + (container.getSize().width - insets.left - insets.right - (totalWidth += (numChildren - 1) * this.padding)) / 2 : (ltr ? container.getSize().width - insets.right - sizes[0].width : insets.left);
                    if (ltr) {
                        for (counter = 0; counter < numChildren; ++counter) {
                            children[counter].setBounds(xLocation, yLocation, sizes[counter].width, sizes[counter].height);
                            if (counter < numChildren - 1) {
                                xLocation -= this.padding + sizes[counter + 1].width;
                            }
                            if (counter != this.destructiveOption - 1) continue;
                            if (this.destructiveOption == numChildren - 1) {
                                xLocation = insets.left;
                                continue;
                            }
                            xLocation -= 14;
                        }
                    } else {
                        for (counter = 0; counter < numChildren; ++counter) {
                            children[counter].setBounds(xLocation, yLocation, sizes[counter].width, sizes[counter].height);
                            xLocation += this.padding + sizes[counter].width;
                            if (counter != this.destructiveOption - 1) continue;
                            xLocation += 14;
                        }
                    }
                }
            }
        }

        public Dimension minimumLayoutSize(Container c) {
            Component[] children;
            if (c != null && (children = c.getComponents()) != null && children.length > 0) {
                int numChildren = children.length;
                int height = 0;
                Insets cInsets = c.getInsets();
                int extraHeight = cInsets.top + cInsets.bottom;
                int extraWidth = cInsets.left + cInsets.right;
                if (this.syncAllWidths) {
                    int maxWidth = 74;
                    for (int counter = 0; counter < numChildren; ++counter) {
                        Dimension aSize = children[counter].getPreferredSize();
                        height = Math.max(height, aSize.height);
                        maxWidth = Math.max(maxWidth, aSize.width + 8);
                    }
                    return new Dimension(extraWidth + maxWidth * numChildren + (numChildren - 1) * this.padding + (this.destructiveOption != -1 ? 14 : 0), extraHeight + height);
                }
                int totalWidth = 0;
                for (int counter = 0; counter < numChildren; ++counter) {
                    Dimension aSize = children[counter].getPreferredSize();
                    height = Math.max(height, aSize.height);
                    totalWidth += Math.max(74, aSize.width + 8);
                }
                return new Dimension(extraWidth + (totalWidth += (numChildren - 1) * this.padding) + (this.destructiveOption != -1 ? 14 : 0), extraHeight + height);
            }
            return new Dimension(0, 0);
        }

        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        public void removeLayoutComponent(Component c) {
        }
    }
}

