/*
    ataridev.h

*/

#ifndef _ATARIDEV_H
#define _ATARIDEV_H

#define ATARI_5200	0
#define ATARI_400	1
#define ATARI_800	2
#define ATARI_600XL 3
#define ATARI_800XL 4

/*----------- defined in machine/ataricrt.c -----------*/

MACHINE_START( a400 );
MACHINE_START( a800 );
MACHINE_START( a800xl );
MACHINE_START( a5200 );

DEVICE_IMAGE_LOAD( a800_cart );
DEVICE_IMAGE_UNLOAD( a800_cart );

DEVICE_IMAGE_LOAD( a800xl_cart );
DEVICE_IMAGE_UNLOAD( a800xl_cart );

DEVICE_IMAGE_LOAD( a5200_cart );
DEVICE_IMAGE_UNLOAD( a5200_cart );


/*----------- defined in machine/atarifdc.c -----------*/
/***************************************************************************
    MACROS
***************************************************************************/

#define ATARI_FDC		DEVICE_GET_INFO_NAME(atari_fdc)

#define MDRV_ATARI_FDC_ADD(_tag)	\
	MDRV_DEVICE_ADD((_tag),  ATARI_FDC, 0)


/***************************************************************************
    FUNCTION PROTOTYPES
***************************************************************************/

DEVICE_GET_INFO(atari_fdc);

READ8_DEVICE_HANDLER( atari_serin_r );
WRITE8_DEVICE_HANDLER( atari_serout_w );
WRITE_LINE_DEVICE_HANDLER( atarifdc_pia_cb2_w );

#endif /* _ATARIDEV_H */

