/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariantSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.ComponentState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.builder.NodeState;
import org.gradle.api.internal.artifacts.transform.TransformedVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributesSchemaInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.AbstractVariantSelectionException;
import org.gradle.internal.component.model.AttributeMatcher;
import org.gradle.internal.component.model.ComponentGraphResolveMetadata;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.gradle.internal.component.resolution.failure.ResolutionCandidateAssessor;
import org.gradle.internal.component.resolution.failure.ResolutionFailureDescriberRegistry;
import org.gradle.internal.component.resolution.failure.describer.ResolutionFailureDescriber;
import org.gradle.internal.component.resolution.failure.type.AmbiguousArtifactTransformFailure;
import org.gradle.internal.component.resolution.failure.type.AmbiguousResolutionFailure;
import org.gradle.internal.component.resolution.failure.type.ConfigurationNotConsumableFailure;
import org.gradle.internal.component.resolution.failure.type.ExternalRequestedConfigurationNotFoundFailure;
import org.gradle.internal.component.resolution.failure.type.IncompatibleGraphVariantFailure;
import org.gradle.internal.component.resolution.failure.type.IncompatibleMultipleNodeSelectionFailure;
import org.gradle.internal.component.resolution.failure.type.IncompatibleRequestedConfigurationFailure;
import org.gradle.internal.component.resolution.failure.type.IncompatibleResolutionFailure;
import org.gradle.internal.component.resolution.failure.type.NoMatchingCapabilitiesFailure;
import org.gradle.internal.component.resolution.failure.type.RequestedConfigurationNotFoundFailure;
import org.gradle.internal.component.resolution.failure.type.ResolutionFailure;
import org.gradle.internal.component.resolution.failure.type.UnknownArtifactSelectionFailure;
import org.gradle.internal.component.resolution.failure.type.VariantAwareAmbiguousResolutionFailure;

public class ResolutionFailureHandler {
    public static final String DEFAULT_MESSAGE_PREFIX = "Review the variant matching algorithm at ";
    private final ResolutionFailureDescriberRegistry defaultFailureDescribers;

    public ResolutionFailureHandler(ResolutionFailureDescriberRegistry failureDescriberRegistry) {
        this.defaultFailureDescribers = failureDescriberRegistry;
    }

    public AbstractVariantSelectionException noMatchingArtifactVariantFailure(AttributesSchemaInternal schema, AttributeMatcher matcher, String variantSetName, ImmutableAttributes requestedAttributes, List<? extends ResolvedVariant> candidateVariants) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor((AttributeContainerInternal)requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessResolvedVariants(candidateVariants);
        IncompatibleResolutionFailure failure = new IncompatibleResolutionFailure(schema, variantSetName, (AttributeContainerInternal)requestedAttributes, assessedCandidates);
        return this.describeFailure(schema, failure);
    }

    public AbstractVariantSelectionException ambiguousArtifactVariantsFailure(AttributesSchemaInternal schema, AttributeMatcher matcher, String selectedComponentName, ImmutableAttributes requestedAttributes, List<? extends ResolvedVariant> matchingVariants) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor((AttributeContainerInternal)requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessResolvedVariants(matchingVariants);
        AmbiguousResolutionFailure failure = new AmbiguousResolutionFailure(schema, selectedComponentName, (AttributeContainerInternal)requestedAttributes, assessedCandidates);
        return this.describeFailure(schema, failure);
    }

    public AbstractVariantSelectionException ambiguousArtifactTransformationFailure(AttributesSchemaInternal schema, String selectedComponentName, ImmutableAttributes requestedAttributes, List<TransformedVariant> transformedVariants) {
        AmbiguousArtifactTransformFailure failure = new AmbiguousArtifactTransformFailure(schema, selectedComponentName, (AttributeContainerInternal)requestedAttributes, transformedVariants);
        return this.describeFailure(schema, failure);
    }

    public AbstractVariantSelectionException unknownArtifactVariantSelectionFailure(AttributesSchemaInternal schema, ResolvedVariantSet producer, Exception cause) {
        UnknownArtifactSelectionFailure failure = new UnknownArtifactSelectionFailure(schema, producer.asDescribable().getDisplayName(), cause);
        return this.describeFailure(schema, failure);
    }

    public AbstractVariantSelectionException incompatibleArtifactVariantsFailure(AttributesSchemaInternal schema, ComponentState selectedComponent, Set<NodeState> incompatibleNodes) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor((AttributeContainerInternal)ImmutableAttributes.EMPTY, schema.matcher());
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessNodeStates(incompatibleNodes);
        IncompatibleMultipleNodeSelectionFailure failure = new IncompatibleMultipleNodeSelectionFailure(schema, selectedComponent.toString(), assessedCandidates);
        return this.describeFailure(schema, failure);
    }

    public AbstractVariantSelectionException ambiguousGraphVariantsFailure(AttributesSchemaInternal schema, AttributeMatcher matcher, AttributeContainerInternal requestedAttributes, List<? extends VariantGraphResolveState> matchingVariants, ComponentGraphResolveMetadata targetComponent) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor(requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessResolvedVariantStates(matchingVariants);
        VariantAwareAmbiguousResolutionFailure failure = new VariantAwareAmbiguousResolutionFailure(schema, targetComponent.getId().getDisplayName(), requestedAttributes, assessedCandidates, targetComponent);
        return this.describeFailure(schema, failure);
    }

    public AbstractVariantSelectionException noMatchingGraphVariantFailure(AttributesSchemaInternal schema, AttributeMatcher matcher, AttributeContainerInternal requestedAttributes, ComponentGraphResolveMetadata targetComponent, GraphSelectionCandidates candidates) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor(requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessGraphSelectionCandidates(candidates);
        IncompatibleGraphVariantFailure failure = new IncompatibleGraphVariantFailure(schema, targetComponent.getId().getDisplayName(), requestedAttributes, assessedCandidates, targetComponent);
        return this.describeFailure(schema, failure);
    }

    public AbstractVariantSelectionException noMatchingCapabilitiesFailure(AttributesSchemaInternal schema, AttributeMatcher matcher, ImmutableAttributes requestedAttributes, ComponentGraphResolveMetadata targetComponent, Collection<? extends Capability> requestedCapabilities, List<? extends VariantGraphResolveState> candidates) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor((AttributeContainerInternal)requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = resolutionCandidateAssessor.assessResolvedVariantStates(candidates);
        NoMatchingCapabilitiesFailure failure = new NoMatchingCapabilitiesFailure(schema, targetComponent.getId().getDisplayName(), targetComponent, requestedCapabilities, assessedCandidates);
        return this.describeFailure(schema, failure);
    }

    public AbstractVariantSelectionException incompatibleRequestedConfigurationFailure(AttributesSchemaInternal schema, AttributeMatcher matcher, AttributeContainerInternal requestedAttributes, ComponentGraphResolveMetadata targetComponent, ConfigurationGraphResolveState targetConfiguration) {
        ResolutionCandidateAssessor resolutionCandidateAssessor = new ResolutionCandidateAssessor(requestedAttributes, matcher);
        List<ResolutionCandidateAssessor.AssessedCandidate> assessedCandidates = Collections.singletonList(resolutionCandidateAssessor.assessCandidate(targetConfiguration.getName(), targetConfiguration.asVariant().getCapabilities(), targetConfiguration.asVariant().getMetadata().getAttributes()));
        IncompatibleRequestedConfigurationFailure failure = new IncompatibleRequestedConfigurationFailure(schema, targetComponent.getId().getDisplayName(), requestedAttributes, assessedCandidates);
        return this.describeFailure(schema, failure);
    }

    public AbstractVariantSelectionException configurationNotFoundFailure(ComponentIdentifier toComponent, String toConfigurationName) {
        RequestedConfigurationNotFoundFailure failure = new RequestedConfigurationNotFoundFailure(toConfigurationName, toComponent);
        return this.describeFailure(failure);
    }

    public AbstractVariantSelectionException externalConfigurationNotFoundFailure(ComponentIdentifier fromComponent, String fromConfigurationName, ComponentIdentifier toComponent, String toConfigurationName) {
        ExternalRequestedConfigurationNotFoundFailure failure = new ExternalRequestedConfigurationNotFoundFailure(toConfigurationName, toComponent, fromComponent, fromConfigurationName);
        return this.describeFailure(failure);
    }

    public AbstractVariantSelectionException configurationNotConsumableFailure(ComponentIdentifier targetComponent, String targetConfigurationName) {
        ConfigurationNotConsumableFailure failure = new ConfigurationNotConsumableFailure(targetConfigurationName, targetComponent);
        return this.describeFailure(failure);
    }

    private <FAILURE extends ResolutionFailure> AbstractVariantSelectionException describeFailure(FAILURE failure) {
        Class<?> failureType = failure.getClass();
        List<ResolutionFailureDescriber<?, FAILURE>> describers = this.defaultFailureDescribers.getDescribers(failureType);
        return this.describeFailure(describers, failure);
    }

    private <FAILURE extends ResolutionFailure> AbstractVariantSelectionException describeFailure(AttributesSchemaInternal schema, FAILURE failure) {
        Class<?> failureType = failure.getClass();
        ArrayList describers = new ArrayList();
        describers.addAll(schema.getFailureDescribers(failureType));
        describers.addAll(this.defaultFailureDescribers.getDescribers(failureType));
        return this.describeFailure(describers, failure);
    }

    private <FAILURE extends ResolutionFailure> AbstractVariantSelectionException describeFailure(List<ResolutionFailureDescriber<?, FAILURE>> describers, FAILURE failure) {
        return describers.stream().filter(describer -> describer.canDescribeFailure(failure)).findFirst().map(describer -> describer.describeFailure(failure)).orElseThrow(() -> new IllegalStateException("No describer found for failure: " + failure));
    }
}

