/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.audionotes;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.ui.internal.audionotes.AudioNotesPlugin;
import org.xmind.ui.internal.audionotes.AudioNotesViewer2;
import org.xmind.ui.internal.audionotes.Messages;
import org.xmind.ui.viewers.ImageButton;

public class AudioNotesViewerPage
implements ICoreEventListener {
    public static final int SELECTION_EVENT = 1;
    public static final int START_EVENT = 2;
    public static final int STOP_EVENT = 4;
    public static final int VALUE_EVENT = 8;
    public static final int ALL = 15;
    public static final int PLAY = 1;
    public static final int RECORD = 2;
    public static final int DISPLAY = 4;
    public static final int INVALID = 8;
    public static final String PATH = "/icons/";
    public static final String START_RECORD = "start_record.png";
    public static final String STOP_RECORD = "stop_record.png";
    public static final String START_PLAY = "start_play.png";
    public static final String STOP_PLAY = "stop_playing.png";
    public static final String PLAY_DISABLE = "play.png";
    public static final String INVALID_SELECTED = "invalid_select.png";
    protected AudioNotesViewer2 viewer;
    ICoreEventRegister coreEventRegister;
    protected int type;
    protected ITopic sourceTopic;
    private Control control;
    protected Label mainLabel;
    protected Label secondaryLabel;
    protected Label leftLabel;
    protected Label rightLabel;
    protected ContentComposite content;
    protected ImageButton imageButton;
    protected Label imageLabel;

    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)data);
        this.createLabelComposte(composite);
        this.createMeterLevelComposite(composite);
        this.createButtonImageComposite(composite);
        this.control = composite;
        this.coreEventRegister = new CoreEventRegister((ICoreEventListener)this);
        return composite;
    }

    private void createLabelComposte(Composite parent) {
        GridData mainLabelData = new GridData(0x1000000, 4, true, false);
        mainLabelData.widthHint = 200;
        mainLabelData.heightHint = 35;
        GridData secondaryLabelData = new GridData(0x1000000, 4, true, false);
        secondaryLabelData.widthHint = 300;
        secondaryLabelData.heightHint = 20;
        Composite labelComposite = new Composite(parent, 0);
        GridLayout labelLayout = new GridLayout(1, true);
        labelLayout.marginLeft = 0;
        labelLayout.marginRight = 0;
        labelLayout.marginTop = 0;
        labelLayout.marginBottom = 0;
        labelLayout.marginHeight = 2;
        labelLayout.verticalSpacing = 0;
        labelComposite.setLayout((Layout)labelLayout);
        GridData labelLayoutData = new GridData(4, 4, true, true);
        labelLayoutData.heightHint = 60;
        labelComposite.setLayoutData((Object)labelLayoutData);
        this.mainLabel = new Label(labelComposite, 0x1000000);
        this.mainLabel.setText(Messages.AudioNotesViewerPage_Main_Label);
        this.mainLabel.setLayoutData((Object)mainLabelData);
        this.mainLabel.setFont(JFaceResources.getHeaderFont());
        this.secondaryLabel = new Label(labelComposite, 0x1000000);
        this.secondaryLabel.setText(Messages.AudioNotesViewerPage_Secondary_Label);
        this.secondaryLabel.setLayoutData((Object)secondaryLabelData);
    }

    private void createMeterLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginTop = 0;
        layout.marginBottom = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = 42;
        composite.setLayoutData((Object)gridData);
        this.leftLabel = new Label(composite, 0x1000000);
        this.leftLabel.setText(Messages.AudioNotesViewerPage_Duration_Label);
        GridData timeData = new GridData(4, 0x1000000, true, true);
        timeData.widthHint = 80;
        timeData.heightHint = 20;
        this.leftLabel.setLayoutData((Object)timeData);
        this.content = this.createContentComposite(composite);
        this.rightLabel = new Label(composite, 0x1000000);
        this.rightLabel.setText(Messages.AudioNotesViewerPage_Size_Label);
        GridData sizeData = new GridData(4, 0x1000000, true, true);
        sizeData.widthHint = 80;
        sizeData.heightHint = 20;
        this.rightLabel.setLayoutData((Object)sizeData);
    }

    protected ContentComposite createContentComposite(Composite parent) {
        return null;
    }

    protected void configImageButton() {
    }

    private void createButtonImageComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 0;
        layout.marginRight = 0;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(0x1000000, 0x1000000, true, true);
        layoutData.heightHint = 120;
        layoutData.widthHint = 120;
        composite.setLayoutData((Object)layoutData);
        Composite imageComposite = new Composite(composite, 0);
        GridLayout imageCompositeLayout = new GridLayout(1, false);
        imageCompositeLayout.marginWidth = 0;
        imageCompositeLayout.marginHeight = 0;
        imageCompositeLayout.marginLeft = 0;
        imageCompositeLayout.verticalSpacing = 0;
        imageCompositeLayout.horizontalSpacing = 0;
        imageComposite.setLayout((Layout)imageCompositeLayout);
        GridData imageCompositeLayoutData = new GridData(0x1000000, 0x1000000, true, true);
        imageCompositeLayoutData.widthHint = 100;
        imageComposite.setLayoutData((Object)imageCompositeLayoutData);
        this.imageButton = new ImageButton(imageComposite, 8);
        this.configImageButton();
        Control control = this.imageButton.getControl();
        control.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        control.setEnabled(true);
        control.setBackground(composite.getBackground());
        Composite labelComposite = new Composite(composite, 0);
        GridLayout labelCompositeLayout = new GridLayout(1, false);
        labelCompositeLayout.marginWidth = 0;
        labelCompositeLayout.marginHeight = 0;
        labelCompositeLayout.marginLeft = 0;
        labelCompositeLayout.verticalSpacing = 0;
        labelCompositeLayout.horizontalSpacing = 0;
        labelComposite.setLayout((Layout)labelCompositeLayout);
        GridData labelCompositeLayoutData = new GridData(0x1000000, 0x1000000, true, true);
        labelCompositeLayoutData.widthHint = 60;
        labelComposite.setLayoutData((Object)labelCompositeLayoutData);
        this.imageLabel = new Label(labelComposite, 0x1000000);
        this.imageLabel.setText(Messages.AudioNotesViewerPage_Image_Label);
        GridData imageLabelLayoutData = new GridData(4, 4, true, true);
        imageLabelLayoutData.widthHint = 50;
        imageLabelLayoutData.heightHint = 30;
        this.imageLabel.setLayoutData((Object)imageLabelLayoutData);
    }

    private void hookTopic(ITopic topic) {
        this.coreEventRegister.unregisterAll();
        this.coreEventRegister.setNextSourceFrom((Object)topic);
        this.coreEventRegister.register("titleText");
        this.coreEventRegister.register("topicRemove");
    }

    private void unhookTopic(ITopic topic) {
        if (this.coreEventRegister != null) {
            this.coreEventRegister.unregisterAll();
        }
    }

    public void dispose() {
        this.unhookTopic(this.sourceTopic);
        this.coreEventRegister = null;
    }

    public void update(int type, Object source) {
    }

    public Control getControl() {
        return this.control;
    }

    protected static boolean isRecording() {
        return AudioNotesPlugin.getDefault().getAgent().isRecording();
    }

    protected static boolean isPlaying() {
        return AudioNotesPlugin.getDefault().getAgent().isPlaying();
    }

    public void setSourceTopic(ITopic sourceTopic) {
        this.unhookTopic(this.sourceTopic);
        this.sourceTopic = sourceTopic;
        this.hookTopic(sourceTopic);
        this.update(1, sourceTopic);
    }

    public void handleCoreEvent(CoreEvent event) {
        if (event.getSource() != null && event.getSource().equals(this.sourceTopic) && "titleText".equals(event.getType())) {
            this.update(1, event.getSource());
        }
    }

    protected static interface ContentComposite {
        public Object getSelection();

        public void setSelection(Object var1);

        public Control getControl();
    }
}

