/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.Page;
import org.xmind.core.IRevision;
import org.xmind.core.IRevisionManager;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.CoreEventRegister;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.ui.editor.IGraphicalEditorPage;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.dialogs.RevisionPreviewDialog;
import org.xmind.ui.util.TextFormatter;
import org.xmind.ui.viewers.SWTUtils;

public class RevisionsPage
extends Page
implements ICoreEventListener,
IAdaptable {
    private ISheet sheet;
    private Control control;
    private TableViewer viewer;
    private RotatableWrapLabel titleLabel;
    private IRevisionManager revisionManager;
    private ICoreEventRegister coreEventRegister = new CoreEventRegister((ICoreEventListener)this);
    private ICoreEventRegister topicEventRegister = new CoreEventRegister((ICoreEventListener)this);
    private MenuManager popupMenuManager;

    public RevisionsPage(IGraphicalEditorPage source) {
        this.sheet = (ISheet)source.getInput();
        this.revisionManager = this.sheet.getOwnedWorkbook().getRevisionRepository().getRevisionManager(this.sheet.getId(), "application/vnd.xmind.sheet");
    }

    public void createControl(Composite parent) {
        final Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        this.createTitleLabel(composite);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(4, 4, true, false));
        Control viewerControl = this.createViewer(composite);
        viewerControl.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)composite);
        this.registerCoreEvents();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.popupMenuManager = new MenuManager("#popup");
        this.popupMenuManager.add((IContributionItem)new GroupMarker("start"));
        this.popupMenuManager.add((IContributionItem)new Separator("additions"));
        this.popupMenuManager.add((IContributionItem)new GroupMarker("end"));
        this.getSite().registerContextMenu("org.xmind.ui.RevisionsView", this.popupMenuManager, (ISelectionProvider)this.viewer);
        Menu popupMenu = this.popupMenuManager.createContextMenu(viewerControl);
        viewerControl.setMenu(popupMenu);
        composite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                RevisionsPage.this.titleLabel.setPrefWidth(composite.getSize().x);
            }
        });
    }

    private void setControl(Control control) {
        this.control = control;
    }

    private void createTitleLabel(Composite parent) {
        FigureCanvas canvas = new FigureCanvas(parent);
        canvas.setLayoutData((Object)new GridData(4, 4, true, false));
        canvas.setVisible(true);
        canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.titleLabel = new RotatableWrapLabel(0);
        this.titleLabel.setSingleLine(true);
        this.titleLabel.setAbbreviated(true);
        canvas.setContents((IFigure)this.titleLabel);
        this.titleLabel.setText(this.getTitleText());
    }

    private Control createViewer(Composite parent) {
        this.viewer = new TableViewer(parent, 66306);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.setContentProvider((IContentProvider)new RevisionContentProvider());
        TableViewerColumn col0 = new TableViewerColumn(this.viewer, 131072);
        col0.getColumn().setText("#");
        col0.getColumn().setWidth(36);
        col0.setLabelProvider((CellLabelProvider)new RevisionNumberLabelProvider());
        TableViewerColumn col1 = new TableViewerColumn(this.viewer, 16384);
        col1.getColumn().setText(MindMapMessages.RevisionsView_DateColumn_text);
        col1.getColumn().setWidth(120);
        col1.setLabelProvider((CellLabelProvider)new RevisionDateLabelProvider());
        TableViewerColumn col2 = new TableViewerColumn(this.viewer, 16384);
        col2.getColumn().setText(MindMapMessages.RevisionsView_TimeColumn_text);
        col2.getColumn().setWidth(120);
        col2.setLabelProvider((CellLabelProvider)new RevisionTimeLabelProvider());
        this.viewer.setInput((Object)this.revisionManager);
        this.viewer.addOpenListener((IOpenListener)new RevisionOpenListener());
        this.viewer.getTable().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (SWTUtils.matchKey((int)e.stateMask, (int)e.keyCode, (int)0, (int)32)) {
                    RevisionsPage.this.handleOpen(RevisionsPage.this.viewer.getSelection());
                }
            }
        });
        this.viewer.getControl().setToolTipText(MindMapMessages.RevisionPage_ShowDetails_message);
        return this.viewer.getControl();
    }

    private void registerCoreEvents() {
        this.coreEventRegister.setNextSourceFrom((Object)this.revisionManager);
        this.coreEventRegister.register("revisionAdd");
        this.coreEventRegister.register("revisionRemove");
        this.coreEventRegister.setNextSourceFrom((Object)this.sheet);
        this.coreEventRegister.register("titleText");
        this.coreEventRegister.register("rootTopic");
        ITopic rootTopic = this.sheet.getRootTopic();
        this.topicEventRegister.setNextSourceFrom((Object)rootTopic);
        this.topicEventRegister.register("titleText");
    }

    public void dispose() {
        if (this.viewer != null) {
            if (this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
                this.viewer.getControl().setMenu(null);
            }
            this.viewer = null;
        }
        if (this.popupMenuManager != null) {
            this.popupMenuManager.dispose();
            this.popupMenuManager = null;
        }
        this.topicEventRegister.unregisterAll();
        this.coreEventRegister.unregisterAll();
        super.dispose();
    }

    public Control getControl() {
        return this.control;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void viewRevision(IRevision revision) {
        List revisions = this.revisionManager.getRevisions();
        int index = revisions.indexOf(revision);
        RevisionPreviewDialog dialog = new RevisionPreviewDialog(this.getSite().getShell(), this.sheet, revisions, index);
        dialog.open();
    }

    public void handleCoreEvent(CoreEvent event) {
        String type = event.getType();
        if ("revisionAdd".equals(type) || "revisionRemove".equals(type)) {
            this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (RevisionsPage.this.viewer != null) {
                        RevisionsPage.this.viewer.refresh();
                    }
                }
            });
        } else if ("titleText".equals(type)) {
            this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (RevisionsPage.this.titleLabel != null) {
                        RevisionsPage.this.titleLabel.setText(RevisionsPage.this.getTitleText());
                    }
                }
            });
        } else if ("rootTopic".equals(type)) {
            this.topicEventRegister.unregisterAll();
            ITopic rootTopic = this.sheet.getRootTopic();
            this.topicEventRegister.setNextSourceFrom((Object)rootTopic);
            this.topicEventRegister.register("titleText");
        }
    }

    private void asyncExec(Runnable runnable) {
        this.getSite().getWorkbenchWindow().getWorkbench().getDisplay().asyncExec(runnable);
    }

    public Object getAdapter(Class adapter) {
        if (adapter == ISelectionProvider.class) {
            return this.viewer;
        }
        return null;
    }

    private void handleOpen(ISelection selection) {
        if (selection.isEmpty()) {
            return;
        }
        IRevision revision = (IRevision)((IStructuredSelection)selection).getFirstElement();
        this.viewRevision(revision);
    }

    private String getTitleText() {
        String text = String.format("%s (%s)", this.sheet.getTitleText(), this.sheet.getRootTopic().getTitleText());
        return TextFormatter.removeNewLineCharacter((String)text);
    }

    public static class RevisionContentProvider
    implements IStructuredContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ((IRevisionManager)inputElement).getRevisions().toArray();
        }
    }

    private static class RevisionDateLabelProvider
    extends ColumnLabelProvider {
        private RevisionDateLabelProvider() {
        }

        public String getText(Object element) {
            IRevision revision = (IRevision)element;
            return String.format("%tF", revision.getTimestamp());
        }
    }

    private static class RevisionNumberLabelProvider
    extends ColumnLabelProvider {
        private RevisionNumberLabelProvider() {
        }

        public String getText(Object element) {
            IRevision revision = (IRevision)element;
            return String.valueOf(revision.getRevisionNumber());
        }
    }

    private class RevisionOpenListener
    implements IOpenListener {
        private RevisionOpenListener() {
        }

        public void open(OpenEvent event) {
            RevisionsPage.this.handleOpen(event.getSelection());
        }
    }

    private static class RevisionTimeLabelProvider
    extends ColumnLabelProvider {
        private RevisionTimeLabelProvider() {
        }

        public String getText(Object element) {
            IRevision revision = (IRevision)element;
            return String.format("%tT", revision.getTimestamp());
        }
    }
}

