/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.views;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.xmind.core.IMeta;
import org.xmind.ui.internal.views.AuthorInfoViewer;
import org.xmind.ui.internal.views.InspectorSection;
import org.xmind.ui.internal.views.Messages;

public class AuthorInfoInspectorSection
extends InspectorSection {
    private AuthorInfoNameViewer nameViewer;
    private AuthorInfoEmailViewer emailViewer;
    private AuthorInfoOrganizationViewer organizationViewer;
    private Color invalidColor;
    private Color validColor;

    public AuthorInfoInspectorSection() {
        this.setTitle(Messages.AuthorInfoInspectorSection_title);
    }

    @Override
    protected Composite createContent(Composite parent) {
        this.invalidColor = parent.getDisplay().getSystemColor(16);
        this.validColor = parent.getDisplay().getSystemColor(2);
        Composite composite = super.createContent(parent);
        this.createNameItem(composite);
        this.createEmailItem(composite);
        this.createOrganizationItem(composite);
        return composite;
    }

    private void createNameItem(Composite parent) {
        Composite item = this.getItemComposite(parent);
        Label label = new Label(item, 0);
        label.setText(Messages.AuthorInfoInspectorSection_Name);
        this.nameViewer = new AuthorInfoNameViewer(item);
        this.nameViewer.setEnabled(true);
        this.fillViewerContent(this.nameViewer, this.getCurrentWorkbook().getMeta(), "Author/Name", Messages.AuthorInfoInspectorSection_Enter_Name);
    }

    private void createEmailItem(Composite parent) {
        Composite item = this.getItemComposite(parent);
        Label label = new Label(item, 0);
        label.setText(Messages.AuthorInfoInspectorSection_Email);
        this.emailViewer = new AuthorInfoEmailViewer(item);
        this.emailViewer.setEnabled(true);
        this.fillViewerContent(this.emailViewer, this.getCurrentWorkbook().getMeta(), "Author/Email", Messages.AuthorInfoInspectorSection_Enter_Email);
    }

    private void createOrganizationItem(Composite parent) {
        Composite item = this.getItemComposite(parent);
        Label label = new Label(item, 0);
        label.setText(Messages.AuthorInfoInspectorSection_Organization);
        this.organizationViewer = new AuthorInfoOrganizationViewer(item);
        this.organizationViewer.setEnabled(true);
        this.fillViewerContent(this.organizationViewer, this.getCurrentWorkbook().getMeta(), "Author/Org", Messages.AuthorInfoInspectorSection_Enter_Organization);
    }

    private void fillViewerContent(AuthorInfoViewer viewer, IMeta meta, String key, String enterLabel) {
        String value = meta.getValue(key);
        viewer.getEditor().getButton().setTextForeground(this.isContentEmpty(value) ? this.invalidColor : this.validColor);
        String text = null;
        if (!this.isContentEmpty(value)) {
            viewer.getEditor().getInput().setText(value);
            text = value;
        } else {
            viewer.getEditor().getInput().setText("");
            text = enterLabel;
        }
        viewer.getEditor().getButton().setText(text);
        viewer.getDisplay().setText(text);
    }

    private Composite getItemComposite(Composite parent) {
        Composite item = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        item.setLayout((Layout)layout);
        item.setLayoutData((Object)new GridData(4, 4, true, false));
        return item;
    }

    private boolean isContentEmpty(String content) {
        return content == null || "".equals(content);
    }

    public void refreshAuthorInfoName() {
        if (this.nameViewer != null && this.getCurrentWorkbook() != null) {
            this.fillViewerContent(this.nameViewer, this.getCurrentWorkbook().getMeta(), "Author/Name", Messages.AuthorInfoInspectorSection_Enter_Name);
        }
    }

    public void refreshAuthorInfoEmail() {
        if (this.emailViewer != null && this.getCurrentWorkbook() != null) {
            this.fillViewerContent(this.emailViewer, this.getCurrentWorkbook().getMeta(), "Author/Email", Messages.AuthorInfoInspectorSection_Enter_Email);
        }
    }

    public void refreshAuthorInfoOrg() {
        if (this.organizationViewer != null && this.getCurrentWorkbook() != null) {
            this.fillViewerContent(this.organizationViewer, this.getCurrentWorkbook().getMeta(), "Author/Org", Messages.AuthorInfoInspectorSection_Enter_Organization);
        }
    }

    public Color getInvalidColor() {
        return this.invalidColor;
    }

    public void setInvalidColor(Color invalidColor) {
        this.invalidColor = invalidColor;
    }

    public Color getValidColor() {
        return this.validColor;
    }

    public void setValidColor(Color validColor) {
        this.validColor = validColor;
    }

    @Override
    protected void handleDispose() {
        if (this.invalidColor != null && !this.invalidColor.isDisposed()) {
            this.invalidColor.dispose();
            this.invalidColor = null;
        }
        if (this.validColor != null && !this.validColor.isDisposed()) {
            this.validColor.dispose();
            this.validColor = null;
        }
    }

    @Override
    protected void refreshAuthorInfo() {
        if (this.getCurrentWorkbook() != null) {
            this.refreshAuthorInfoName();
            this.refreshAuthorInfoEmail();
            this.refreshAuthorInfoOrg();
        }
    }

    private class AuthorInfoEmailViewer
    extends AuthorInfoViewer {
        public AuthorInfoEmailViewer(Composite parent) {
            super(parent);
        }

        @Override
        protected void refresh() {
            AuthorInfoInspectorSection.this.refreshAuthorInfoEmail();
        }

        @Override
        protected void changeContent() {
            String value = this.getEditor().getInput().getText();
            if (value != null && AuthorInfoInspectorSection.this.getCurrentWorkbook() != null) {
                AuthorInfoInspectorSection.this.getCurrentWorkbook().getMeta().setValue("Author/Email", value);
            }
            AuthorInfoInspectorSection.this.refreshAuthorInfoEmail();
        }
    }

    private class AuthorInfoNameViewer
    extends AuthorInfoViewer {
        public AuthorInfoNameViewer(Composite parent) {
            super(parent);
        }

        @Override
        protected void refresh() {
            AuthorInfoInspectorSection.this.refreshAuthorInfoName();
        }

        @Override
        protected void changeContent() {
            String value = this.getEditor().getInput().getText();
            if (value != null && !"".equals(value) && AuthorInfoInspectorSection.this.getCurrentWorkbook() != null) {
                AuthorInfoInspectorSection.this.getCurrentWorkbook().getMeta().setValue("Author/Name", value);
            }
            AuthorInfoInspectorSection.this.refreshAuthorInfoName();
        }
    }

    private class AuthorInfoOrganizationViewer
    extends AuthorInfoViewer {
        public AuthorInfoOrganizationViewer(Composite parent) {
            super(parent);
        }

        @Override
        protected void refresh() {
            AuthorInfoInspectorSection.this.refreshAuthorInfoOrg();
            AuthorInfoInspectorSection.this.reflow();
        }

        @Override
        protected void changeContent() {
            String value = this.getEditor().getInput().getText();
            if (value != null && AuthorInfoInspectorSection.this.getCurrentWorkbook() != null) {
                AuthorInfoInspectorSection.this.getCurrentWorkbook().getMeta().setValue("Author/Org", value);
            }
            AuthorInfoInspectorSection.this.refreshAuthorInfoOrg();
            AuthorInfoInspectorSection.this.reflow();
        }
    }
}

