/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.handlers.MindMapHandlerUtil;

public class SortHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.sort(MindMapHandlerUtil.findContributingEditor(event), event.getParameter("org.xmind.ui.sortParameter"));
        return null;
    }

    private void sort(IEditorPart editor, String param) {
        if (param == null || editor == null) {
            return;
        }
        String value = this.getSortId(param);
        if (value == null) {
            return;
        }
        IViewer viewer = MindMapUIPlugin.getAdapter(editor, IViewer.class);
        if (viewer == null) {
            return;
        }
        EditDomain domain = viewer.getEditDomain();
        if (domain == null) {
            return;
        }
        domain.handleRequest(new Request("sort").setViewer(viewer).setParameter("comparand", (Object)value));
    }

    private String getSortId(String param) {
        if ("title".equals(param)) {
            return "org.xmind.ui.sort_title";
        }
        if ("priority".equals(param)) {
            return "org.xmind.ui.sort_priority";
        }
        if ("modified".equals(param)) {
            return "org.xmind.ui.sort_modified";
        }
        return null;
    }
}

