/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gallery;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Cursor;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IDecorator;
import org.xmind.gef.part.GraphicalEditPart;
import org.xmind.gef.part.IPart;
import org.xmind.gef.part.IPartSite;
import org.xmind.gef.part.IRequestHandler;
import org.xmind.gef.policy.IEditPolicy;
import org.xmind.gef.policy.NullEditPolicy;
import org.xmind.gef.status.StatusEvent;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gallery.FrameDecorator;
import org.xmind.ui.gallery.FrameFigure;

public class FramePart
extends GraphicalEditPart
implements PropertyChangeListener {
    public FramePart(Object model) {
        this.setModel(model);
        this.setDecorator((IDecorator)FrameDecorator.DEFAULT);
    }

    protected LayoutManager createLayoutManager() {
        return new FrameContentLayout(this.getSite());
    }

    protected IFigure createFigure() {
        FrameFigure figure = new FrameFigure();
        Properties properties = this.getSite().getViewer().getProperties();
        boolean useAdvancedRenderer = properties.getBoolean("renderTextAsPath", false);
        figure.setTitleRenderStyle(useAdvancedRenderer ? 1 : 0);
        return figure;
    }

    public FrameFigure getFigure() {
        return (FrameFigure)super.getFigure();
    }

    public IFigure getContentPane() {
        return ((FrameFigure)super.getFigure()).getContentPane();
    }

    protected Object[] getModelChildren(Object model) {
        Object[] objectArray;
        boolean isLeastElement = this.getSite().getViewer().getProperties().getBoolean("org.xmind.ui.gallery.customDecorateContentPane", false);
        if (isLeastElement) {
            objectArray = new Object[]{};
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = model;
        }
        return objectArray;
    }

    protected void declareEditPolicies(IRequestHandler reqHandler) {
        super.declareEditPolicies(reqHandler);
        reqHandler.installEditPolicy("selectable role", (IEditPolicy)NullEditPolicy.getInstance());
        reqHandler.installEditPolicy("navigable role", "org.xmind.ui.gallery.editPolicy.navigable");
        reqHandler.installEditPolicy("movable role", "org.xmind.ui.gallery.editPolicy.movable");
    }

    protected void register() {
        this.registerModel(this.getModel());
        super.register();
    }

    protected void unregister() {
        super.unregister();
        this.unregisterModel(this.getModel());
    }

    protected void handleStatusChanged(StatusEvent event) {
        if ((event.key & 2) != 0) {
            this.setSelected(event.newValue);
        } else if ((event.key & 4) != 0) {
            this.setPreselected(event.newValue);
        } else if ((event.key & 8) != 0) {
            this.getFigure().repaint();
        } else {
            super.handleStatusChanged(event);
        }
    }

    protected void setSelected(boolean selected) {
        this.getFigure().setSelected(selected);
    }

    protected void setPreselected(boolean preselected) {
        this.getFigure().setPreselected(preselected);
    }

    protected IPart findChildAt(IPart child, Point position) {
        if (!child.hasRole("selectable role")) {
            return null;
        }
        return super.findChildAt(child, position);
    }

    public Cursor getCursor(Point pos) {
        EditDomain domain;
        if (this.getContentPane().containsPoint(pos) && (!this.getSite().getProperties().getBoolean("org.xmind.ui.gallery.solidFrames", false) || this.getSite().getProperties().getBoolean("org.xmind.ui.gallery.singleClickToOpen", false))) {
            return Cursors.HAND;
        }
        if (this.getFigure().getTitle().containsPoint(pos) && (domain = this.getSite().getDomain()) != null && domain.hasTool("edit tool")) {
            return Cursors.HAND;
        }
        return null;
    }

    protected void updateChildren() {
        super.updateChildren();
        for (IPart child : this.getChildren()) {
            child.update();
        }
    }

    protected void onActivated() {
        super.onActivated();
        this.getSite().getViewer().getProperties().addPropertyChangeListener("renderTextAsPath", (PropertyChangeListener)this);
    }

    protected void onDeactivated() {
        this.getSite().getViewer().getProperties().removePropertyChangeListener("renderTextAsPath", (PropertyChangeListener)this);
        super.onDeactivated();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        boolean useAdvancedRenderer = this.getSite().getViewer().getProperties().getBoolean("renderTextAsPath", false);
        this.getFigure().setTitleRenderStyle(useAdvancedRenderer ? 1 : 0);
    }

    private static class FrameContentLayout
    extends AbstractLayout {
        private static Rectangle BOUNDS = new Rectangle();
        private static Rectangle CHILD_BOUNDS = new Rectangle();
        private IPartSite site;

        public FrameContentLayout(IPartSite site) {
            this.site = site;
        }

        public void layout(IFigure container) {
            Rectangle area = container.getClientArea(BOUNDS);
            for (Object child : container.getChildren()) {
                IFigure figure = (IFigure)child;
                Dimension childSize = figure.getPreferredSize(area.width, area.height);
                int childWidth = Math.min(childSize.width, area.width);
                int childHeight = Math.min(childSize.height, area.height);
                int childX = area.x + (area.width - childWidth) / 2;
                int childY = area.y + (area.height - childHeight) / 2;
                CHILD_BOUNDS.setBounds(childX, childY, childWidth, childHeight);
                figure.setBounds(CHILD_BOUNDS);
            }
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            int childWHint;
            Insets insets = container.getInsets();
            Properties properties = this.site.getProperties();
            Dimension contentSize = (Dimension)properties.get("org.xmind.ui.gallery.frameContentSize");
            boolean pack = properties.getBoolean("org.xmind.ui.gallery.packFrameContent", false);
            if (contentSize != null && !pack) {
                return new Dimension(contentSize.width + insets.getWidth(), contentSize.height + insets.getHeight());
            }
            int n = contentSize != null ? contentSize.width : (childWHint = wHint < 0 ? wHint : Math.max(0, wHint - insets.getWidth()));
            int childHHint = contentSize != null ? contentSize.height : (hHint < 0 ? hHint : Math.max(0, hHint - insets.getHeight()));
            int childWidth = 0;
            int childHeight = 0;
            for (Object child : container.getChildren()) {
                Dimension childSize = ((IFigure)child).getPreferredSize(childWHint, childHHint);
                childWidth = Math.max(childWidth, childSize.width);
                childHeight = Math.max(childHeight, childSize.height);
            }
            if (contentSize != null) {
                childWidth = Math.min(childWidth, contentSize.width);
                childHeight = Math.min(childHeight, contentSize.height);
            }
            return new Dimension(childWidth + insets.getWidth(), childHeight + insets.getHeight());
        }
    }
}

