/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.ComparableSubject;
import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import java.math.BigDecimal;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class BigDecimalSubject
extends ComparableSubject<BigDecimal> {
    private final BigDecimal actual;

    BigDecimalSubject(FailureMetadata metadata, @Nullable BigDecimal actual) {
        super(metadata, actual);
        this.actual = actual;
    }

    public void isEqualToIgnoringScale(BigDecimal expected) {
        this.compareValues(expected);
    }

    public void isEqualToIgnoringScale(String expected) {
        this.compareValues(new BigDecimal(expected));
    }

    public void isEqualToIgnoringScale(long expected) {
        this.compareValues(new BigDecimal(expected));
    }

    @Override
    public void isEqualTo(@Nullable Object expected) {
        super.isEqualTo(expected);
    }

    @Override
    public void isEquivalentAccordingToCompareTo(BigDecimal expected) {
        this.compareValues(expected);
    }

    private void compareValues(BigDecimal expected) {
        if (this.actual.compareTo(expected) != 0) {
            this.failWithoutActual(Fact.fact("expected", expected), this.butWas(), Fact.simpleFact("(scale is ignored)"));
        }
    }
}

