/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.entry;

import java.util.Locale;
import java.util.Objects;
import org.jabref.model.entry.IdGenerator;

public class BibtexString
implements Cloneable {
    private String name;
    private String content;
    private String id = IdGenerator.next();
    private Type type;
    private String parsedSerialization;
    private boolean hasChanged;

    public BibtexString(String name, String content) {
        this.name = name;
        this.content = content;
        this.hasChanged = true;
        this.type = Type.get(name);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
        this.hasChanged = true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.hasChanged = true;
        this.type = Type.get(name);
    }

    public String getContent() {
        return this.content == null ? "" : this.content;
    }

    public void setContent(String content) {
        this.content = content;
        this.hasChanged = true;
    }

    public Type getType() {
        return this.type;
    }

    public void setParsedSerialization(String parsedSerialization) {
        this.parsedSerialization = parsedSerialization;
        this.hasChanged = false;
    }

    public String getParsedSerialization() {
        return this.parsedSerialization;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public String getUserComments() {
        if (this.parsedSerialization != null) {
            try {
                String prolog = this.parsedSerialization.substring(0, this.parsedSerialization.indexOf(64));
                prolog = prolog.replaceFirst("\\s+$", "");
                if (prolog.length() > 0) {
                    return prolog;
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return "";
    }

    public Object clone() {
        BibtexString clone = new BibtexString(this.name, this.content);
        clone.setId(this.id);
        return clone;
    }

    public String toString() {
        return this.name + "=" + this.content;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BibtexString that = (BibtexString)o;
        return this.hasChanged == that.hasChanged && Objects.equals(this.name, that.name) && Objects.equals(this.content, that.content) && Objects.equals(this.id, that.id) && this.type == that.type && Objects.equals(this.parsedSerialization, that.parsedSerialization);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.content, this.id, this.type, this.parsedSerialization, this.hasChanged});
    }

    public static enum Type {
        AUTHOR("a"),
        INSTITUTION("i"),
        PUBLISHER("p"),
        OTHER("");

        private final String prefix;

        private Type(String prefix) {
            this.prefix = prefix;
        }

        public static Type get(String key) {
            if (key.length() <= 1) {
                return OTHER;
            }
            if (!String.valueOf(key.charAt(1)).toUpperCase(Locale.ROOT).equals(String.valueOf(key.charAt(1)))) {
                return OTHER;
            }
            for (Type t : Type.values()) {
                if (!t.prefix.equals(String.valueOf(key.charAt(0)))) continue;
                return t;
            }
            return OTHER;
        }
    }
}

