/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.exporter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.jabref.logic.exporter.SaveException;
import org.jabref.logic.exporter.SaveSession;
import org.jabref.logic.exporter.VerifyingWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringSaveSession
extends SaveSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringSaveSession.class);
    private final ByteArrayOutputStream outputStream;

    public StringSaveSession(Charset encoding, boolean backup) {
        this(encoding, backup, new ByteArrayOutputStream());
    }

    private StringSaveSession(Charset encoding, boolean backup, ByteArrayOutputStream outputStream) {
        super(encoding, backup, new VerifyingWriter((OutputStream)outputStream, encoding));
        this.outputStream = outputStream;
    }

    public String getStringValue() {
        try {
            return this.outputStream.toString(this.encoding.name());
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.warn("Encoding problem", e);
            return "";
        }
    }

    @Override
    public void commit(Path file) throws SaveException {
        try {
            Files.write(file, this.outputStream.toByteArray(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new SaveException(e);
        }
    }

    @Override
    public void cancel() {
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            LOGGER.warn("Error while cancel", e);
        }
    }
}

