/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.cleanup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jabref.logic.formatter.bibtexfields.ClearFormatter;
import org.jabref.model.FieldChange;
import org.jabref.model.cleanup.CleanupJob;
import org.jabref.model.cleanup.FieldFormatterCleanup;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.identifier.DOI;

public class DoiCleanup
implements CleanupJob {
    private static final List<String> FIELDS = Arrays.asList("note", "url", "ee");

    @Override
    public List<FieldChange> cleanup(BibEntry entry) {
        ArrayList<FieldChange> changes;
        block4: {
            block3: {
                changes = new ArrayList<FieldChange>();
                if (!entry.hasField("doi")) break block3;
                String doiFieldValue = entry.getField("doi").orElse(null);
                Optional<DOI> doi = DOI.parse(doiFieldValue);
                if (!doi.isPresent()) break block4;
                String newValue = doi.get().getDOI();
                if (!doiFieldValue.equals(newValue)) {
                    entry.setField("doi", newValue);
                    FieldChange change = new FieldChange(entry, "doi", doiFieldValue, newValue);
                    changes.add(change);
                }
                for (String field2 : FIELDS) {
                    entry.getField(field2).flatMap(DOI::parse).ifPresent(unused -> this.removeFieldValue(entry, field2, changes));
                }
                break block4;
            }
            for (String field3 : FIELDS) {
                Optional doi = entry.getField(field3).flatMap(DOI::parse);
                if (!doi.isPresent()) continue;
                String oldValue = entry.getField("doi").orElse(null);
                String newValue = ((DOI)doi.get()).getDOI();
                entry.setField("doi", newValue);
                FieldChange change = new FieldChange(entry, "doi", oldValue, newValue);
                changes.add(change);
                this.removeFieldValue(entry, field3, changes);
            }
        }
        return changes;
    }

    private void removeFieldValue(BibEntry entry, String field2, List<FieldChange> changes) {
        FieldFormatterCleanup eraser = new FieldFormatterCleanup(field2, new ClearFormatter());
        changes.addAll(eraser.cleanup(entry));
    }
}

