/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.sun.javafx.scene.control.behavior.TextAreaBehavior;
import com.sun.javafx.scene.control.skin.TextAreaSkin;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javafx.fxml.Initializable;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Skin;
import javafx.scene.control.TextArea;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class EditorTextArea
extends TextArea
implements Initializable {
    public EditorTextArea() {
        this("");
    }

    public EditorTextArea(String text) {
        super(text);
        this.setMinHeight(1.0);
        this.setMinWidth(200.0);
        this.setWrapText(true);
        this.addEventFilter(KeyEvent.KEY_PRESSED, event -> {
            if (event.getCode() == KeyCode.TAB) {
                TextAreaSkin skin = (TextAreaSkin)this.getSkin();
                if (event.isShiftDown()) {
                    ((TextAreaBehavior)skin.getBehavior()).traversePrevious();
                } else if (event.isControlDown()) {
                    ((TextAreaBehavior)skin.getBehavior()).callAction("InsertTab");
                } else {
                    ((TextAreaBehavior)skin.getBehavior()).traverseNext();
                }
                event.consume();
            }
        });
    }

    public void addToContextMenu(final Supplier<List<MenuItem>> items) {
        TextAreaSkin customContextSkin = new TextAreaSkin(this){

            public void populateContextMenu(ContextMenu contextMenu) {
                super.populateContextMenu(contextMenu);
                contextMenu.getItems().addAll(0, (Collection)items.get());
            }
        };
        this.setSkin((Skin)customContextSkin);
    }

    public void initialize(URL location, ResourceBundle resources) {
    }
}

