/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.actions;

import java.awt.event.ActionEvent;
import java.util.HashMap;
import javax.swing.KeyStroke;
import org.jabref.Globals;
import org.jabref.gui.EntryTypeDialog;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.actions.MnemonicAwareAction;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.EntryTypes;
import org.jabref.model.entry.EntryType;
import org.jabref.model.strings.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewEntryAction
extends MnemonicAwareAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(NewEntryAction.class);
    private final JabRefFrame jabRefFrame;
    private String type;

    public NewEntryAction(JabRefFrame jabRefFrame, KeyStroke key) {
        super(IconTheme.JabRefIcon.ADD_ENTRY.getIcon());
        this.jabRefFrame = jabRefFrame;
        this.putValue("Name", Localization.menuTitle("New entry", new String[0]) + "...");
        this.putValue("AcceleratorKey", key);
        this.putValue("ShortDescription", Localization.lang("New BibTeX entry", new String[0]));
    }

    public NewEntryAction(JabRefFrame jabRefFrame, String type) {
        this.jabRefFrame = jabRefFrame;
        this.putValue("Name", StringUtil.capitalizeFirst(type));
        this.type = type;
    }

    public NewEntryAction(JabRefFrame jabRefFrame, String type, KeyStroke key) {
        this.jabRefFrame = jabRefFrame;
        this.putValue("Name", StringUtil.capitalizeFirst(type));
        this.putValue("AcceleratorKey", key);
        this.type = type;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String thisType = this.type;
        if (thisType == null) {
            EntryTypeDialog etd = new EntryTypeDialog(this.jabRefFrame);
            etd.setLocationRelativeTo(this.jabRefFrame);
            etd.setVisible(true);
            EntryType tp = etd.getChoice();
            if (tp == null) {
                return;
            }
            thisType = tp.getName();
            this.trackNewEntry(tp);
        }
        if (this.jabRefFrame.getBasePanelCount() > 0) {
            this.jabRefFrame.getCurrentBasePanel().newEntry(EntryTypes.getType(thisType, this.jabRefFrame.getCurrentBasePanel().getBibDatabaseContext().getMode()).get());
        } else {
            LOGGER.info("Action 'New entry' must be disabled when no database is open.");
        }
    }

    private void trackNewEntry(EntryType type) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("EntryType", type.getName());
        HashMap measurements = new HashMap();
        Globals.getTelemetryClient().ifPresent(client -> client.trackEvent("NewEntry", properties, measurements));
    }
}

