/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.citeproc.helper.json;

import de.undercouch.citeproc.helper.json.JsonLexer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonParser {
    private final JsonLexer lexer;

    public JsonParser(JsonLexer lexer) {
        this.lexer = lexer;
    }

    public Map<String, Object> parseObject() throws IOException {
        JsonLexer.Type t = this.lexer.readNextToken();
        if (t != JsonLexer.Type.START_OBJECT) {
            throw new IOException("Unexpected token: " + (Object)((Object)t));
        }
        return this.parseObjectInternal();
    }

    private Map<String, Object> parseObjectInternal() throws IOException {
        JsonLexer.Type t;
        HashMap<String, Object> result = new HashMap<String, Object>();
        while ((t = this.lexer.readNextToken()) != JsonLexer.Type.END_OBJECT) {
            if (!result.isEmpty()) {
                if (t != JsonLexer.Type.COMMA) {
                    throw new IOException("Unexpected token: " + (Object)((Object)t));
                }
                t = this.lexer.readNextToken();
            }
            if (t != JsonLexer.Type.STRING) {
                throw new IOException("Unexpected token: " + (Object)((Object)t));
            }
            String name = this.lexer.readString();
            t = this.lexer.readNextToken();
            if (t != JsonLexer.Type.COLON) {
                throw new IOException("Unexpected token: " + (Object)((Object)t));
            }
            t = this.lexer.readNextToken();
            Object value = this.readValue(t);
            result.put(name, value);
        }
        return result;
    }

    public List<Object> parseArray() throws IOException {
        JsonLexer.Type t = this.lexer.readNextToken();
        if (t != JsonLexer.Type.START_ARRAY) {
            throw new IOException("Unexpected token: " + (Object)((Object)t));
        }
        return this.parseArrayInternal();
    }

    private List<Object> parseArrayInternal() throws IOException {
        JsonLexer.Type t;
        ArrayList<Object> result = new ArrayList<Object>();
        while ((t = this.lexer.readNextToken()) != JsonLexer.Type.END_ARRAY) {
            if (!result.isEmpty()) {
                if (t != JsonLexer.Type.COMMA) {
                    throw new IOException("Unexpected token: " + (Object)((Object)t));
                }
                t = this.lexer.readNextToken();
            }
            Object value = this.readValue(t);
            result.add(value);
        }
        return result;
    }

    private Object readValue(JsonLexer.Type t) throws IOException {
        switch (t) {
            case START_OBJECT: {
                return this.parseObjectInternal();
            }
            case START_ARRAY: {
                return this.parseArrayInternal();
            }
            case STRING: {
                return this.lexer.readString();
            }
            case NUMBER: {
                return this.lexer.readNumber();
            }
            case TRUE: {
                return true;
            }
            case FALSE: {
                return false;
            }
            case NULL: {
                return null;
            }
        }
        throw new IOException("Unexpected token: " + (Object)((Object)t));
    }
}

