/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.konan.serialization;

import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0006R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/backend/konan/serialization/InlineFunctionFilesTracker;", "", "<init>", "()V", "inlineFunctionFiles", "", "Lorg/jetbrains/kotlin/ir/declarations/IrExternalPackageFragment;", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "add", "", "packageFragment", "file", "getOrNull", "ir.serialization.native"})
public final class InlineFunctionFilesTracker {
    @NotNull
    private final Map<IrExternalPackageFragment, IrFile> inlineFunctionFiles = new LinkedHashMap();

    public final void add(@NotNull IrExternalPackageFragment packageFragment, @NotNull IrFile file) {
        Intrinsics.checkNotNullParameter(packageFragment, "packageFragment");
        Intrinsics.checkNotNullParameter(file, "file");
        IrFile irFile = this.inlineFunctionFiles.get(packageFragment);
        if (irFile != null) {
            IrFile it = irFile;
            boolean bl = false;
            if (!Intrinsics.areEqual(it, file)) {
                boolean bl2 = false;
                String string = "Different files " + it.getFileEntry().getName() + " and " + file.getFileEntry().getName() + " have the same " + packageFragment;
                throw new IllegalArgumentException(string.toString());
            }
        }
        this.inlineFunctionFiles.put(packageFragment, file);
    }

    @Nullable
    public final IrFile getOrNull(@NotNull IrExternalPackageFragment packageFragment) {
        Intrinsics.checkNotNullParameter(packageFragment, "packageFragment");
        return this.inlineFunctionFiles.get(packageFragment);
    }
}

