/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Vector;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.ScrollPane;

public class PageView
extends ScrollPane {
    private Vector model;
    private int currentViewIdx;
    private boolean animating;
    private int spacing = 10;
    private boolean prevLayoutDone;
    private boolean nextLayoutDone;

    public PageView(Vector panels) {
        this.model = panels;
        this.setMode(-1);
        this.currentViewIdx = 0;
        Component currView = this.getCurrentView();
        if (currView != null) {
            this.add(currView);
        }
        this.resetDragMode();
    }

    public PageView() {
        this((Vector)null);
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void paintChildren(Graphics2D g) {
        Component currView = this.getCurrentView();
        if (currView != this.getView()) {
            this.setCurrentView(currView);
        }
        if (!currView.consumesMotionEvents() && currView.getWidth() >= this.getViewPortWidth() && currView.getHeight() >= this.getViewPortHeight()) {
            Component nextView;
            int nextViewPosX;
            Component prevView;
            int currViewPosX = currView.posX;
            if (currViewPosX - this.spacing > 0 && this.hasPreviousView() && (prevView = this.getPreviousView()) != null) {
                if (!this.prevLayoutDone) {
                    this.prevLayoutDone = true;
                    this.resetViewSize(prevView);
                }
                int prevViewPosX = currViewPosX - prevView.getWidth() - this.spacing;
                g.translate(prevViewPosX, 0);
                prevView.paint(g);
                g.translate(-prevViewPosX, 0);
            }
            if ((nextViewPosX = currViewPosX + currView.getWidth() + this.spacing) < this.getWidth() && this.hasNextView() && (nextView = this.getNextView()) != null) {
                if (!this.nextLayoutDone) {
                    this.nextLayoutDone = true;
                    this.resetViewSize(nextView);
                }
                g.translate(nextViewPosX, 0);
                nextView.paint(g);
                g.translate(-nextViewPosX, 0);
            }
        }
        super.paintChildren(g);
    }

    public void processMouseEvent(int type, int pointX, int pointY, KeyEvent keys) {
        boolean bl = this.animating = type == 2;
        if (this.animating) {
            this.checkViewChange();
        }
        super.processMouseEvent(type, pointX, pointY, keys);
    }

    protected void setViewLocation(int viewX, int viewY) {
        super.setViewLocation(viewX, viewY);
        if (this.animating) {
            this.checkViewChange();
        }
    }

    protected Component getNextView() {
        return this.currentViewIdx + 1 < this.model.size() ? (Component)this.model.elementAt(this.currentViewIdx + 1) : null;
    }

    protected Component getCurrentView() {
        return (Component)this.model.elementAt(this.currentViewIdx);
    }

    protected Component getPreviousView() {
        return this.currentViewIdx > 0 ? (Component)this.model.elementAt(this.currentViewIdx - 1) : null;
    }

    protected void setCurrentView(Component view) {
        this.resetDragSpeed();
        this.animating = false;
        this.prevLayoutDone = false;
        this.nextLayoutDone = false;
        Component oldView = null;
        try {
            oldView = this.getView();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.resetViewSize(view);
        if (view != oldView) {
            if (oldView != null) {
                view.setLocation(oldView.getX(), oldView.getY());
            }
            this.add(view);
            if (oldView != null) {
                view.setLocation(oldView.getX(), oldView.getY());
            }
        }
        this.resetDragMode();
    }

    protected boolean hasNextView() {
        return this.getNextView() != null;
    }

    protected boolean hasPreviousView() {
        return this.getPreviousView() != null;
    }

    protected void changeView(int delta) {
        if (delta < 0 && this.hasPreviousView()) {
            --this.currentViewIdx;
        } else if (delta > 0 && this.hasNextView()) {
            ++this.currentViewIdx;
        }
        this.setCurrentView(this.getCurrentView());
    }

    public void resetViewSize(Component view) {
        if (view != null) {
            int vpW = this.getViewPortWidth();
            int vpH = this.getViewPortHeight();
            if (vpW != view.getWidth() || vpH != view.getHeight()) {
                view.validate();
                view.setSize(vpW, vpH);
            }
        }
    }

    private void checkViewChange() {
        int viewPortW = this.getWidth();
        int viewX = this.getView().getX();
        if (this.hasPreviousView() && viewX > viewPortW / 2) {
            this.goPrev();
        }
        if (this.hasNextView() && viewX + this.getView().getWidth() < viewPortW / 2) {
            this.goNext();
        }
    }

    private void goNext() {
        this.resetDragSpeed();
        Component currView = this.getView();
        int newViewX = Math.min(currView.getX() + currView.getWidth(), this.getWidth());
        int newViewY = this.getViewPortY();
        currView.setLocation(newViewX, newViewY);
        currView = null;
        this.changeView(1);
        this.getView().setLocation(newViewX, newViewY);
    }

    private void goPrev() {
        this.resetDragSpeed();
        Component currView = this.getView();
        int newViewX = Math.max(currView.getX(), 0) - this.getWidth();
        int newViewY = this.getViewPortY();
        currView.setLocation(newViewX, newViewY);
        currView = null;
        this.changeView(-1);
        this.getView().setLocation(newViewX, newViewY);
    }

    private void resetDragMode() {
        int bounceMode = 0;
        if (this.hasPreviousView()) {
            bounceMode |= 1;
        }
        if (this.hasNextView()) {
            bounceMode |= 2;
        }
        this.setBounceMode(bounceMode);
    }

    public void nextPage() {
        this.changeView(1);
    }

    public void previousPage() {
        this.changeView(-1);
    }
}

