/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.mapstore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import javax.microedition.lcdui.Image;
import net.yura.cache.Cache;
import net.yura.domination.ImageManager;
import net.yura.domination.engine.RiskUtil;
import net.yura.domination.engine.core.RiskGame;
import net.yura.domination.engine.translation.TranslationBundle;
import net.yura.domination.mapstore.BadgeButton;
import net.yura.domination.mapstore.Category;
import net.yura.domination.mapstore.Map;
import net.yura.domination.mapstore.MapRenderer;
import net.yura.domination.mapstore.MapServerClient;
import net.yura.domination.mapstore.MapServerListener;
import net.yura.domination.mapstore.MapUpdateService;
import net.yura.mobile.gui.ActionListener;
import net.yura.mobile.gui.ButtonGroup;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.Midlet;
import net.yura.mobile.gui.cellrenderer.ListCellRenderer;
import net.yura.mobile.gui.components.Button;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.OptionPane;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.RadioButton;
import net.yura.mobile.gui.components.TextComponent;
import net.yura.mobile.gui.layout.XULLoader;
import net.yura.mobile.gui.plaf.LookAndFeel;
import net.yura.mobile.gui.plaf.SynthLookAndFeel;
import net.yura.mobile.io.FileUtil;
import net.yura.mobile.logging.Logger;
import net.yura.mobile.util.ImageUtil;
import net.yura.mobile.util.Properties;
import net.yura.mobile.util.Url;
import net.yura.swingme.core.CoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapChooser
implements ActionListener,
MapServerListener {
    public static final String SERVER_URL = "http://maps.yura.net/";
    public static final String MAP_PAGE = "http://maps.yura.net/maps?format=xml&version=" + Url.encode((String)RiskUtil.RISK_VERSION);
    public static final String CATEGORIES_PAGE = "http://maps.yura.net/categories?format=xml&version=" + Url.encode((String)RiskUtil.RISK_VERSION);
    private static ImageManager iconCache = new ImageManager(XULLoader.adjustSizeToDensity((int)150), XULLoader.adjustSizeToDensity((int)94));
    private static java.util.Map mapCache = new WeakHashMap();
    private static Cache repo;
    private Properties resBundle = CoreUtil.wrap(TranslationBundle.getBundle());
    private XULLoader loader;
    private ActionListener al;
    protected MapServerClient client;
    private List<String> localMaps;
    private Set<String> allowedMaps;
    private net.yura.mobile.gui.components.List list;
    private String selectedMap;

    public static void loadThemeExtension() {
        try {
            LookAndFeel laf = DesktopPane.getDesktopPane().getLookAndFeel();
            if (laf instanceof SynthLookAndFeel) {
                ((SynthLookAndFeel)laf).load(Midlet.getResourceAsStream((String)"/ms_tabbar.xml"));
            } else {
                System.err.println("LookAndFeel not SynthLookAndFeel " + laf);
            }
        }
        catch (Exception ex) {
            RiskUtil.printStackTrace(ex);
        }
    }

    public MapChooser(ActionListener al, List<String> localMaps, Set<String> allowedMaps) {
        this.al = al;
        this.localMaps = localMaps;
        this.allowedMaps = allowedMaps;
        try {
            this.loader = XULLoader.load((InputStream)Midlet.getResourceAsStream((String)"/ms_maps.xml"), (ActionListener)this, (Properties)this.resBundle);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        Panel TabBar = (Panel)this.loader.find("TabBar");
        if (TabBar != null) {
            int count = 0;
            if (allowedMaps != null) {
                for (String localMap : localMaps) {
                    if (!allowedMaps.contains(localMap)) continue;
                    ++count;
                }
            }
            if (allowedMaps != null && count == allowedMaps.size()) {
                TabBar.setVisible(false);
            } else {
                Vector buttons = TabBar.getComponents();
                Icon on = new Icon("/ms_bar_on.png");
                Icon off = new Icon("/ms_bar_off.png");
                int w = off.getIconWidth() / buttons.size();
                for (int c = 0; c < buttons.size(); ++c) {
                    RadioButton b = (RadioButton)buttons.get(c);
                    Icon oni = on.getSubimage(c * w, 0, w, off.getIconHeight());
                    Icon offi = off.getSubimage(c * w, 0, w, off.getIconHeight());
                    b.setIcon(offi);
                    b.setSelectedIcon(oni);
                    b.setRolloverIcon(offi);
                    b.setRolloverSelectedIcon(oni);
                    b.setToolTipText(b.getText());
                    b.setText("");
                    b.setMargin(0);
                }
            }
        }
        this.list = (net.yura.mobile.gui.components.List)this.loader.find("ResultList");
        if (Midlet.getPlatform() == 8) {
            this.list.setDoubleClick(true);
        }
        MapRenderer r = new MapRenderer(this);
        this.list.setCellRenderer((ListCellRenderer)r);
        this.list.setFixedCellHeight(Math.max(XULLoader.adjustSizeToDensity((int)100), r.getFixedCellHeight()));
        this.list.setFixedCellWidth(10);
        this.client = new MapServerClient(this);
        this.client.start();
        this.activateGroup("MapView");
        MapUpdateService.getInstance().addObserver((BadgeButton)this.loader.find("updateButton"));
    }

    public void destroy() {
        MapUpdateService.getInstance().deleteObserver((BadgeButton)this.loader.find("updateButton"));
        this.client.kill();
        this.client = null;
    }

    public static Icon getLocalIconForMap(Map map) {
        return MapChooser.getIconForMapOrCategory(map, null, map.getPreviewUrl(), null);
    }

    public static Icon getRemoteIconForMap(String mapUID, MapServerClient mapServerClient) {
        ImageManager.LazyIcon aicon = iconCache.get(mapUID);
        if (aicon == null) {
            aicon = iconCache.newIcon(mapUID);
            mapServerClient.makeRequestXML(MAP_PAGE, "mapfile", mapUID);
        }
        return aicon;
    }

    public static boolean getRemoteImage(Object key, String url, MapServerClient c) {
        InputStream in;
        InputStream inputStream = in = repo != null ? repo.get(url) : null;
        if (in != null) {
            MapChooser.gotImg(key, in);
            return true;
        }
        if (c != null) {
            c.getImage(url, key);
        }
        return false;
    }

    public static Icon getIconForMapOrCategory(Object key, String context, String iconUrl, MapServerClient c) {
        ImageManager.LazyIcon aicon = iconCache.get(key);
        if (aicon == null) {
            aicon = iconCache.newIcon(key);
            String url = MapChooser.getURL(context, iconUrl);
            if (url.indexOf(58) > 0) {
                MapChooser.getRemoteImage(key, url, c);
            } else {
                InputStream in = null;
                if (url.startsWith("preview/")) {
                    try {
                        in = RiskUtil.openMapStream(url);
                    }
                    catch (Exception ex) {
                        Logger.warn((String)("cant open " + url), (Throwable)ex);
                    }
                } else {
                    InputStream inputStream = in = repo != null ? repo.get(url) : null;
                    if (in == null) {
                        try {
                            System.out.println("[MapChooser] ### Going to re-encode img: " + url);
                            InputStream min = RiskUtil.openMapStream(url);
                            Image img = MapChooser.createImage(min);
                            img = ImageUtil.scaleImage((Image)img, (int)150, (int)94);
                            ByteArrayOutputStream out = new ByteArrayOutputStream();
                            ImageUtil.saveImage((Image)img, (OutputStream)out);
                            img = null;
                            byte[] bytes = out.toByteArray();
                            out = null;
                            MapChooser.cache(url, bytes);
                            in = new ByteArrayInputStream(bytes);
                        }
                        catch (OutOfMemoryError err) {
                            Logger.info((String)("cant resize " + url), (Throwable)err);
                        }
                        catch (Exception ex) {
                            Logger.warn((String)("cant resize " + url), (Throwable)ex);
                        }
                    }
                }
                if (in != null) {
                    MapChooser.gotImg(key, in);
                }
            }
        }
        return aicon;
    }

    private static void gotImg(Object obj, InputStream in) {
        try {
            Image img = MapChooser.createImage(in);
            iconCache.gotImg(obj, img);
        }
        catch (OutOfMemoryError err) {
            Logger.info((String)("cant load " + obj), (Throwable)err);
        }
        catch (Exception ex) {
            throw new RuntimeException("failed to decode img " + obj, ex);
        }
    }

    public static void gotImgFromServer(Object obj, String url, byte[] data, MapServerListener msl) {
        try {
            MapChooser.gotImg(obj, new ByteArrayInputStream(data));
            if (msl != null) {
                msl.publishImg(obj);
            }
        }
        catch (RuntimeException ex) {
            System.err.println("error in image from server with url: " + url);
            throw ex;
        }
        MapChooser.cache(url, data);
    }

    @Override
    public void publishImg(Object key) {
        if (this.client != null) {
            this.list.repaint();
        }
    }

    private static void cache(String url, byte[] data) {
        if (repo != null && !repo.containsKey(url)) {
            repo.put(url, data);
        }
    }

    public static boolean haveLocalMap(String mapUID) {
        if (mapCache.containsKey(mapUID)) {
            return true;
        }
        return MapChooser.fileExists(mapUID);
    }

    public static boolean fileExists(String fileUID) {
        InputStream file = null;
        try {
            file = RiskUtil.openMapStream(fileUID);
        }
        catch (Exception exception) {
        }
        finally {
            FileUtil.close((Object)file);
        }
        return file != null;
    }

    public static void clearFromCache(String mapUID) {
        mapCache.remove(mapUID);
    }

    public static Map createMap(String file) {
        Map map;
        WeakReference wr = (WeakReference)mapCache.get(file);
        if (wr != null && (map = (Map)wr.get()) != null) {
            return map;
        }
        java.util.Map info = RiskUtil.loadInfo(file, false);
        Map map2 = new Map();
        map2.setMapUrl(file);
        String name = (String)info.get("name");
        if (name == null) {
            name = file.toLowerCase().endsWith(".map") ? file.substring(0, file.length() - 4) : file;
        }
        map2.setName(name);
        map2.setDescription((String)info.get("comment"));
        String prv = (String)info.get("prv");
        if (prv != null && !MapChooser.fileExists(prv = "preview/" + prv)) {
            prv = null;
        }
        if (prv == null) {
            prv = (String)info.get("pic");
        }
        map2.setPreviewUrl(prv);
        map2.setVersion((String)info.get("ver"));
        mapCache.put(file, new WeakReference<Map>(map2));
        return map2;
    }

    public static String getFileUID(String mapUrl) {
        int i = mapUrl.lastIndexOf(47);
        return i >= 0 ? mapUrl.substring(i + 1) : mapUrl;
    }

    void makeRequestForMap(String a, String b) {
        this.client.makeRequestXML(MAP_PAGE, a, b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(String actionCommand) {
        if ("local".equals(actionCommand)) {
            this.mainCatList(actionCommand);
            new Thread(){

                public void run() {
                    Vector<Map> riskmaps = new Vector<Map>(MapChooser.this.localMaps.size());
                    for (int c = 0; c < MapChooser.this.localMaps.size(); ++c) {
                        String file = (String)MapChooser.this.localMaps.get(c);
                        Map map = MapChooser.createMap(file);
                        riskmaps.add(map);
                    }
                    Collections.sort(riskmaps, new Comparator(){

                        public int compare(Object t1, Object t2) {
                            Map m1 = (Map)t1;
                            Map m2 = (Map)t2;
                            return String.CASE_INSENSITIVE_ORDER.compare(m1.getName(), m2.getName());
                        }
                    });
                    MapChooser.this.setListData(null, riskmaps);
                }
            }.start();
        } else if ("catagories".equals(actionCommand)) {
            this.mainCatList(actionCommand);
            this.client.makeRequestXML(CATEGORIES_PAGE, null, null);
        } else if ("top25".equals(actionCommand)) {
            this.mainCatList(actionCommand);
            this.activateGroup("Top25View");
        } else if ("search".equals(actionCommand)) {
            this.mainCatList(actionCommand);
            this.actionPerformed("doMapSearch");
        } else if ("update".equals(actionCommand)) {
            this.mainCatList(actionCommand);
            List<Map> mapsToUpdate = MapUpdateService.getInstance().mapsToUpdate;
            Component updateAll = this.loader.find("updateAll");
            if (mapsToUpdate.isEmpty()) {
                updateAll.setVisible(false);
                this.show("AllUpToDate");
            } else {
                updateAll.setVisible(true);
                this.setListData(MAP_PAGE, mapsToUpdate);
            }
        } else if ("updateall".equals(actionCommand)) {
            List<Map> mapsToUpdate;
            List<Map> updateAll = mapsToUpdate = MapUpdateService.getInstance().mapsToUpdate;
            synchronized (updateAll) {
                for (int c = 0; c < mapsToUpdate.size(); ++c) {
                    this.click(mapsToUpdate.get(c));
                }
            }
        } else if ("TOP_NEW".equals(actionCommand)) {
            this.clearList();
            this.makeRequestForMap("sort", "TOP_NEW");
        } else if ("TOP_RATINGS".equals(actionCommand)) {
            this.clearList();
            this.makeRequestForMap("sort", "TOP_RATINGS");
        } else if ("TOP_DOWNLOADS".equals(actionCommand)) {
            this.clearList();
            this.makeRequestForMap("sort", "TOP_DOWNLOADS");
        } else if ("listSelect".equals(actionCommand)) {
            Object value = this.list.getSelectedValue();
            if (value instanceof Category) {
                Category cat = (Category)value;
                this.clearList();
                this.makeRequestForMap("category", cat.getId());
            } else if (value instanceof Map) {
                Map map = (Map)value;
                this.click(map);
            }
        } else if ("sameAuthor".equals(actionCommand)) {
            Object value = this.list.getSelectedValue();
            if (value instanceof Map) {
                Map map = (Map)value;
                this.makeRequestForMap("author", map.getAuthorId());
            }
        } else if ("defaultMap".equals(actionCommand)) {
            this.chosenMap(RiskGame.getDefaultMap());
        } else if ("cancel".equals(actionCommand)) {
            this.al.actionPerformed(null);
        } else if ("doMapSearch".equals(actionCommand)) {
            TextComponent.closeNativeEditor();
            String text = ((TextComponent)this.loader.find("mapSearchBox")).getText();
            this.clearList();
            if (text != null && !"".equals(text)) {
                this.makeRequestForMap("search", text);
            } else {
                this.setListData(null, null);
            }
        } else {
            System.out.println("Unknown command " + actionCommand);
        }
    }

    public void click(Map map) {
        String fileUID = MapChooser.getFileUID(map.getMapUrl());
        String context = ((MapRenderer)this.list.getCellRenderer()).getContext();
        if (context != null) {
            if (this.client.isDownloading(fileUID)) {
                OptionPane.showMessageDialog(null, (Object)"already downloading", (String)"message", (int)0);
            } else if (this.localMaps.contains(fileUID)) {
                java.util.Map info = RiskUtil.loadInfo(fileUID, false);
                String ver = (String)info.get("ver");
                if (map.needsUpdate(ver)) {
                    this.client.downloadMap(MapChooser.getURL(context, map.mapUrl));
                    this.list.repaint();
                    return;
                }
                String pic = (String)info.get("pic");
                String crd = (String)info.get("crd");
                String imap = (String)info.get("map");
                String prv = (String)info.get("prv");
                if (!MapChooser.fileExists(pic) || !MapChooser.fileExists(crd) || !MapChooser.fileExists(imap) || prv != null && !MapChooser.fileExists("preview/" + prv)) {
                    this.client.downloadMap(MapChooser.getURL(context, map.mapUrl));
                    this.list.repaint();
                    return;
                }
                this.chosenMap(fileUID);
            } else {
                this.client.downloadMap(MapChooser.getURL(context, map.mapUrl));
                this.list.repaint();
            }
        } else {
            this.chosenMap(fileUID);
        }
    }

    private void chosenMap(String mapName) {
        this.selectedMap = mapName;
        this.al.actionPerformed(null);
    }

    public static String getURL(String context, String mapUrl) {
        if (mapUrl.indexOf(58) < 0 && context != null) {
            mapUrl = mapUrl.startsWith("/") ? context.substring(0, context.indexOf(47, "http://.".length())) + mapUrl : context + mapUrl;
        }
        return mapUrl;
    }

    public void mainCatList(String actionCommand) {
        Enumeration group = ((ButtonGroup)this.loader.getGroups().get("MapView")).getElements();
        while (group.hasMoreElements()) {
            Button button = (Button)group.nextElement();
            String action = button.getActionCommand();
            Component panel = this.loader.find(action + "Bar");
            panel.setVisible(action.equals(actionCommand));
        }
        this.clearList();
    }

    void clearList() {
        this.show("Loading");
    }

    public Panel getRoot() {
        return (Panel)this.loader.getRoot();
    }

    public String getSelectedMap() {
        return this.selectedMap;
    }

    @Override
    public void gotResultCategories(String url, List items) {
        this.setListData(url, items);
    }

    @Override
    public void gotResultMaps(String url, List maps) {
        this.setListData(url, maps);
    }

    @Override
    public void onXMLError(String error) {
        this.show("Error");
    }

    @Override
    public void onDownloadError(String error) {
        OptionPane.showMessageDialog(null, (Object)error, (String)"Error!", (int)0);
    }

    @Override
    public void downloadFinished(String download) {
        if (!this.localMaps.contains(download)) {
            this.localMaps.add(download);
        }
        if (((Button)this.loader.find("updateButton")).isSelected() && MapUpdateService.getInstance().mapsToUpdate.isEmpty()) {
            this.loader.find("updateAll").setVisible(false);
            this.show("AllUpToDate");
        }
    }

    public static String getContext(String url) {
        int i;
        if (url != null && (i = url.lastIndexOf(47)) > "http://.".length()) {
            url = url.substring(0, i + 1);
        }
        return url;
    }

    private void setListData(String url, List items) {
        Vector result;
        ((MapRenderer)this.list.getCellRenderer()).setContext(MapChooser.getContext(url));
        if (items == null) {
            result = new Vector(0);
        } else if (this.allowedMaps == null) {
            result = RiskUtil.asVector(items);
        } else {
            result = new Vector();
            for (Object item : items) {
                if (item instanceof Map) {
                    if (!this.allowedMaps.contains(MapChooser.getFileUID(((Map)item).getMapUrl()))) continue;
                    result.add(item);
                    continue;
                }
                result.add(item);
            }
        }
        this.list.setListData(result);
        boolean showNoMatch = items != null && result.isEmpty();
        this.show(showNoMatch ? "NoMatches" : "ResultList");
    }

    private void show(String name) {
        Component loading = this.loader.find("Loading");
        Component noMatches = this.loader.find("NoMatches");
        Component allUpToDate = this.loader.find("AllUpToDate");
        Component error = this.loader.find("Error");
        this.list.setSelectedIndex(-1);
        if (this.list.getSize() > 0) {
            this.list.ensureIndexIsVisible(0);
        }
        this.list.setVisible("ResultList".equals(name));
        noMatches.setVisible("NoMatches".equals(name));
        allUpToDate.setVisible("AllUpToDate".equals(name));
        loading.setVisible("Loading".equals(name));
        error.setVisible("Error".equals(name));
        this.getRoot().revalidate();
        this.getRoot().repaint();
    }

    private void activateGroup(String string) {
        String mincat = ((ButtonGroup)this.loader.getGroups().get(string)).getSelection().getActionCommand();
        this.actionPerformed(mincat);
    }

    public boolean willDownload(Map map) {
        String mapUID = MapChooser.getFileUID(map.getMapUrl());
        if (!this.localMaps.contains(mapUID)) {
            return true;
        }
        return MapUpdateService.getInstance().mapsToUpdate.contains(map);
    }

    public static Image createImage(InputStream in) throws IOException {
        try {
            Image img = Image.createImage((InputStream)in);
            if (img == null) {
                throw new IOException("Image.createImage returned null");
            }
            Image image = img;
            return image;
        }
        finally {
            FileUtil.close((Object)in);
        }
    }

    static {
        try {
            repo = new Cache("net.yura.domination");
        }
        catch (Throwable ex) {
            System.err.println("[MapChooser] no cache: " + ex);
        }
    }
}

