/*
 * Decompiled with CFR 0.152.
 */
package collisionphysics;

import collisionphysics.CollisionPhysics;
import collisionphysics.CollisionResponse;

public class Ball {
    public float x;
    public float y;
    float speedX;
    float speedY;
    public float radius;
    CollisionResponse earliestCollisionResponse = new CollisionResponse();
    private CollisionResponse tempResponse = new CollisionResponse();
    private CollisionResponse thisResponse = new CollisionResponse();
    private CollisionResponse anotherResponse = new CollisionResponse();

    public Ball(float x, float y, float radius, float speed, float angleInDegree) {
        this.x = x;
        this.y = y;
        this.speedX = (float)((double)speed * Math.cos(Math.toRadians(angleInDegree)));
        this.speedY = -speed * (float)Math.sin(Math.toRadians(angleInDegree));
        this.radius = radius;
    }

    public void intersect(int[] box, float timeLimit) {
        CollisionPhysics.pointIntersectsRectangleOuter(this.x, this.y, this.speedX, this.speedY, this.radius, 0.0f, 0.0f, box[0], box[1], timeLimit, this.tempResponse);
        if (this.tempResponse.t < this.earliestCollisionResponse.t) {
            this.earliestCollisionResponse.copy(this.tempResponse);
        }
    }

    public void intersect(Ball another, float timeLimit) {
        CollisionPhysics.pointIntersectsMovingPoint(this.x, this.y, this.speedX, this.speedY, this.radius, another.x, another.y, another.speedX, another.speedY, another.radius, timeLimit, this.thisResponse, this.anotherResponse);
        if (this.anotherResponse.t < another.earliestCollisionResponse.t) {
            another.earliestCollisionResponse.copy(this.anotherResponse);
        }
        if (this.thisResponse.t < this.earliestCollisionResponse.t) {
            this.earliestCollisionResponse.copy(this.thisResponse);
        }
    }

    public void update(float time) {
        if (this.earliestCollisionResponse.t <= time) {
            this.x = this.earliestCollisionResponse.getNewX(this.x, this.speedX);
            this.y = this.earliestCollisionResponse.getNewY(this.y, this.speedY);
            this.speedX = this.earliestCollisionResponse.newSpeedX;
            this.speedY = this.earliestCollisionResponse.newSpeedY;
        } else {
            this.x += this.speedX * time;
            this.y += this.speedY * time;
        }
        this.earliestCollisionResponse.reset();
    }

    public float getSpeed() {
        return (float)Math.sqrt(this.speedX * this.speedX + this.speedY * this.speedY);
    }

    public float getMoveAngle() {
        return (float)Math.toDegrees(Math.atan2(-this.speedY, this.speedX));
    }

    public float getMass() {
        return this.radius * this.radius * this.radius / 1000.0f;
    }

    public float getKineticEnergy() {
        return 0.5f * this.getMass() * (this.speedX * this.speedX + this.speedY * this.speedY);
    }
}

