/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.StringTokenizer;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class Stats
implements Serializable,
RevisionHandler {
    private static final long serialVersionUID = -8610544539090024102L;
    public double count = 0.0;
    public double sum = 0.0;
    public double sumSq = 0.0;
    public double stdDev = Double.NaN;
    public double mean = Double.NaN;
    public double min = Double.NaN;
    public double max = Double.NaN;
    private double stdDevFactor = 0.0;

    private void reset() {
        this.count = 0.0;
        this.sum = 0.0;
        this.sumSq = 0.0;
        this.stdDev = Double.NaN;
        this.mean = Double.NaN;
        this.min = Double.NaN;
        this.max = Double.NaN;
        this.stdDevFactor = 0.0;
    }

    private void negativeCount() {
        this.sum = Double.NaN;
        this.sumSq = Double.NaN;
        this.stdDev = Double.NaN;
        this.mean = Double.NaN;
        this.min = Double.NaN;
        this.max = Double.NaN;
    }

    private void goInvalid() {
        this.count = Double.NaN;
        this.negativeCount();
    }

    private boolean isInvalid() {
        return Double.isNaN(this.count);
    }

    public void add(double value) {
        this.add(value, 1.0);
    }

    public void add(double value, double weight) {
        if (weight < 0.0) {
            this.subtract(value, -weight);
            return;
        }
        if (this.isInvalid()) {
            return;
        }
        if (Double.isInfinite(weight) || Double.isNaN(weight) || Double.isInfinite(value) || Double.isNaN(value)) {
            this.goInvalid();
            return;
        }
        if (weight == 0.0) {
            return;
        }
        double newCount = this.count + weight;
        if (this.count < 0.0 && (newCount > 0.0 || Utils.eq(newCount, 0.0))) {
            this.reset();
            return;
        }
        this.count = newCount;
        if (this.count < 0.0) {
            return;
        }
        double weightedValue = value * weight;
        this.sum += weightedValue;
        this.sumSq += value * weightedValue;
        if (Double.isNaN(this.mean)) {
            this.mean = value;
            this.stdDevFactor = 0.0;
        } else {
            double delta = weight * (value - this.mean);
            this.mean += delta / this.count;
            this.stdDevFactor += delta * (value - this.mean);
        }
        if (Double.isNaN(this.min)) {
            this.min = this.max = value;
        } else if (value < this.min) {
            this.min = value;
        } else if (value > this.max) {
            this.max = value;
        }
    }

    public void subtract(double value) {
        this.subtract(value, 1.0);
    }

    public void subtract(double value, double weight) {
        if (weight < 0.0) {
            this.add(value, -weight);
            return;
        }
        if (this.isInvalid()) {
            return;
        }
        if (Double.isInfinite(weight) || Double.isNaN(weight) || Double.isInfinite(value) || Double.isNaN(value)) {
            this.goInvalid();
            return;
        }
        if (weight == 0.0) {
            return;
        }
        this.count -= weight;
        if (Utils.eq(this.count, 0.0)) {
            this.reset();
            return;
        }
        if (this.count < 0.0) {
            this.negativeCount();
            return;
        }
        double weightedValue = value * weight;
        this.sum -= weightedValue;
        this.sumSq -= value * weightedValue;
        double delta = weight * (value - this.mean);
        this.mean -= delta / this.count;
        this.stdDevFactor -= delta * (value - this.mean);
    }

    public void calculateDerived() {
        if (this.count <= 1.0) {
            this.stdDev = Double.NaN;
            return;
        }
        this.stdDev = this.stdDevFactor / (this.count - 1.0);
        if (this.stdDev < 0.0) {
            this.stdDev = 0.0;
            return;
        }
        this.stdDev = Math.sqrt(this.stdDev);
    }

    public String toString() {
        return "Count   " + Utils.doubleToString(this.count, 8) + '\n' + "Min     " + Utils.doubleToString(this.min, 8) + '\n' + "Max     " + Utils.doubleToString(this.max, 8) + '\n' + "Sum     " + Utils.doubleToString(this.sum, 8) + '\n' + "SumSq   " + Utils.doubleToString(this.sumSq, 8) + '\n' + "Mean    " + Utils.doubleToString(this.mean, 8) + '\n' + "StdDev  " + Utils.doubleToString(this.stdDev, 8) + '\n';
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 14074 $");
    }

    public static void main(String[] args) {
        try {
            String line;
            Stats ps = new Stats();
            LineNumberReader r = new LineNumberReader(new InputStreamReader(System.in));
            while ((line = r.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("@") || line.startsWith("%")) continue;
                StringTokenizer s = new StringTokenizer(line, " ,\t\n\r\f");
                int count = 0;
                double v1 = 0.0;
                while (s.hasMoreTokens()) {
                    double val = new Double(s.nextToken());
                    if (count != 0) {
                        System.err.println("MSG: Too many values in line \"" + line + "\", skipped.");
                        break;
                    }
                    v1 = val;
                    ++count;
                }
                if (count != true) continue;
                ps.add(v1);
            }
            ps.calculateDerived();
            System.err.println(ps);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.err.println(ex.getMessage());
        }
    }
}

