/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.graph.sequences;

import jlibs.core.graph.Sequence;
import jlibs.core.graph.sequences.AbstractSequence;

public class RepeatSequence<E>
extends AbstractSequence<E> {
    private Sequence<E> sequence;
    private int count;
    private int pos;

    public RepeatSequence(Sequence<E> sequence, int count) {
        if (count < 0) {
            throw new IllegalArgumentException(String.format("can't repeat %d times", count));
        }
        this.sequence = sequence;
        this.count = count;
    }

    @Override
    protected E findNext() {
        E next;
        if (this.pos == this.count) {
            return null;
        }
        while ((next = this.sequence.next()) == null) {
            ++this.pos;
            if (this.pos == this.count) {
                return null;
            }
            this.sequence = this.sequence.copy();
        }
        return next;
    }

    @Override
    public void reset() {
        super.reset();
        this._reset();
    }

    private void _reset() {
        this.sequence = this.sequence.copy();
        this.pos = 0;
    }

    @Override
    public RepeatSequence<E> copy() {
        return new RepeatSequence<E>(this.sequence.copy(), this.count);
    }

    @Override
    public int length() {
        return this.sequence.length() * this.count;
    }
}

