/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WrappedMapSet<T>
extends AbstractSet<T>
implements Set<T> {
    private static final Object PRESENCE = new Object();
    private Map<T, Object> map;

    public <C extends Map> WrappedMapSet(Class<C> cl) {
        if (cl == null) {
            throw new IllegalArgumentException("Class passed to WrappedMapSet must not be null");
        }
        try {
            this.map = (Map)cl.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("Expected a Class passed to WrappedMapSet to have a zero argument constructor", e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Expected a Class passed to WrappedMapSet to have a public, zero argument constructor", e);
        }
    }

    public <C extends Map> WrappedMapSet(Class<C> cl, Collection<? extends T> collection) {
        this(cl);
        this.addAll(collection);
    }

    @Override
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object item) {
        return this.map.containsKey(item);
    }

    @Override
    public boolean add(T item) {
        return this.map.put(item, PRESENCE) == null;
    }

    @Override
    public boolean remove(Object item) {
        return this.map.remove(item) == PRESENCE;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

